<?php
/**
 * Breaking  News Section options
 *
 * @package Theme Palace
 * @subpackage Fairtimes
 * @since Fairtimes 1.0.0
 */

// Add Breaking  News section
$wp_customize->add_section( 'fairtimes_breaking_news_section', array(
	'title'             => esc_html__( 'Breaking News Section','fairtimes' ),
	'description'       => esc_html__( 'Breaking News Section options.', 'fairtimes' ),
	'panel'             => 'fairtimes_front_page_panel',
) );

// Breaking  News content enable control and setting
$wp_customize->add_setting( 'fairtimes_theme_options[breaking_news_section_enable]', array(
	'default'			=> 	$options['breaking_news_section_enable'],
    'sanitize_callback' => 'fairtimes_sanitize_switch_control',
) );

$wp_customize->add_control( new Fairtimes_Switch_Control( $wp_customize, 'fairtimes_theme_options[breaking_news_section_enable]', array(
	'label'             => esc_html__( 'Breaking  News Section Enable', 'fairtimes' ),
	'section'           => 'fairtimes_breaking_news_section',
	'on_off_label' 		=> fairtimes_switch_options(),
) ) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'fairtimes_theme_options[breaking_news_section_enable]', array(
		'selector'      => '#fairtimes_breaking_news_section .tooltiptext',
		'settings'      => 'fairtimes_theme_options[breaking_news_section_enable]',
    ) );
}

// Breaking News title setting and control
$wp_customize->add_setting( 'fairtimes_theme_options[breaking_news_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['breaking_news_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'fairtimes_theme_options[breaking_news_title]', array(
	'label'           	=> esc_html__( 'Breaking News Title', 'fairtimes' ),
	'section'        	=> 'fairtimes_breaking_news_section',
	'active_callback' 	=> 'fairtimes_is_breaking_news_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'fairtimes_theme_options[breaking_news_title]', array(
		'selector'            => '#fairtimes_breaking_news_section div h2.news-title',
		'settings'            => 'fairtimes_theme_options[breaking_news_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'fairtimes_breaking_news_title_partial',
    ) );
}

// Add Breaking News dropdown category setting and control.
$wp_customize->add_setting(  'fairtimes_theme_options[breaking_news_content_category]', array(
	'sanitize_callback' => 'fairtimes_sanitize_single_category',
) ) ;

$wp_customize->add_control( new Fairtimes_Dropdown_Taxonomies_Control( $wp_customize,'fairtimes_theme_options[breaking_news_content_category]', array(
	'label'             => esc_html__( 'Select Category', 'fairtimes' ),
	'description'      	=> esc_html__( 'Note: Latest selected no of posts will be shown from selected category', 'fairtimes' ),
	'section'           => 'fairtimes_breaking_news_section',
	'type'              => 'dropdown-taxonomies',
	'active_callback'	=> 'fairtimes_is_breaking_news_section_enable'
) ) );
