<?php
/**
* Partial functions
*
* @package Theme Palace
* @subpackage Fairtimes
* @since Fairtimes 1.0.0
*/

// Breaking News
if ( ! function_exists( 'fairtimes_breaking_news_title_partial' ) ) :
    // Breaking news section partial refresh title
    function fairtimes_breaking_news_title_partial() {
        $options = fairtimes_get_theme_options();
        return esc_html( $options['breaking_news_title'] );
    }
endif;

// Copy Right
if ( ! function_exists( 'fairtimes_copyright_text_partial' ) ) :
    // copyright text
    function fairtimes_copyright_text_partial() {
        $options = fairtimes_get_theme_options();
        return esc_html( $options['copyright_text'] );
    }
endif;

// Contact
if ( ! function_exists( 'fairtimes_contact_information_no_partial' ) ) :
    // contact_information_no
    function fairtimes_contact_information_no_partial() {
        $options = fairtimes_get_theme_options();
        return esc_html( $options['contact_information_no'] );
    }
endif;

if ( ! function_exists( 'fairtimes_contact_email_partial' ) ) :
    // contact_email
    function fairtimes_contact_email_partial() {
        $options = fairtimes_get_theme_options();
        return esc_html( $options['contact_email'] );
    }
endif;

if ( ! function_exists( 'fairtimes_contact_information_location_partial' ) ) :
    // contact_information_location
    function fairtimes_contact_information_location_partial() {
        $options = fairtimes_get_theme_options();
        return esc_html( $options['contact_information_location'] );
    }
endif;

// Featured Article
if ( ! function_exists( 'fairtimes_featured_article_title_partial' ) ) :
    // featured article title
    function fairtimes_featured_article_title_partial() {
        $options = fairtimes_get_theme_options();
        return esc_html( $options['featured_article_title'] );
    }
endif;

// Latest Posts
if ( ! function_exists( 'fairtimes_latest_posts_title_partial' ) ) :
    // latest post title
    function fairtimes_latest_posts_title_partial() {
        $options = fairtimes_get_theme_options();
        return esc_html( $options['latest_posts_title'] );
    }
endif;

if ( ! function_exists( 'fairtimes_latest_posts_sub_title_partial' ) ) :
    // latest post title
    function fairtimes_latest_posts__sub_title_partial() {
        $options = fairtimes_get_theme_options();
        return esc_html( $options['latest_posts_sub_title'] );
    }
endif;

// Popular Posts
if ( ! function_exists( 'fairtimes_popular_posts_title_partial' ) ) :
    // popular post title
    function fairtimes_popular_posts_title_partial() {
        $options = fairtimes_get_theme_options();
        return esc_html( $options['popular_posts_title'] );
    }
endif;

// Most Popular
if ( ! function_exists( 'fairtimes_most_popular_title_partial' ) ) :
    // most popular post title
    function fairtimes_most_popular_title_partial() {
        $options = fairtimes_get_theme_options();
        return esc_html( $options['most_popular_title'] );
    }
endif;