<?php
/**
 * Customizer default options
 *
 * @package Theme Palace
 * @subpackage Fairtimes
 * @since Fairtimes 1.0.0
 * @return array An array of default values
 */

function fairtimes_get_default_theme_options() {
	$theme_data = wp_get_theme();
	$fairtimes_default_options = array(
		// Color Options
		'header_title_color'			=> '#212121',
		'header_tagline_color'			=> '#212121',
		'header_txt_logo_extra'			=> 'show-all',
		'colorscheme_hue'				=> '#ff4443',
		'colorscheme'					=> 'default',
		'theme_version'					=> 'dark-version',
		'home_layout'					=> 'default-design',
		
		// typography Options
		'theme_typography' 				=> 'default',
		'body_theme_typography' 		=> 'default',
		
		// loader
		'loader_enable'         		=> (bool) false,
		'loader_icon'         			=> 'default',

		// breadcrumb
		'breadcrumb_enable'				=> (bool) true,
		'breadcrumb_separator'			=> '/',
		
		// layout 
		'site_layout'         			=> 'wide',
		'sidebar_position'         		=> 'right-sidebar',
		'post_sidebar_position' 		=> 'right-sidebar',
		'page_sidebar_position' 		=> 'right-sidebar',
		'menu_sticky'					=> (bool) true,
		'nav_search_enable'				=> (bool) true,

		// excerpt options
		'long_excerpt_length'           => 25,
		
		// pagination options
		'pagination_enable'         	=> (bool) true,
		'pagination_type'         		=> 'default',

		// footer options
		'copyright_text'           		=> sprintf( esc_html_x( 'Copyright &copy; %1$s %2$s. ', '1: Year, 2: Site Title with home URL', 'fairtimes' ), '[the-year]', '[site-link]' ),
		'scroll_top_visible'        	=> (bool) true,

		// reset options
		'reset_options'      			=> (bool) false,
		
		// homepage options
		'enable_frontpage_content' 		=> (bool) false,

		// contact us
		'contact_information_enable'    => (bool) true,
		'contact_email'	                => esc_html__( 'support@gmail.com', 'fairtimes' ),

		// advertisement
		'advertisement_enable'    => (bool) true,

		// social menu
		'social_menu_enable'      => (bool) true,

		// homepage sections sortable

		// default sortable
		'customizer_sortable' 			=> 'breaking_news,header_posts,featured_article,most_popular,latest_posts,popular_posts',

		'frontpage_sortable' 			=> 'breaking_news,header_posts,featured_article,most_popular,main_posts_wrapper',


		// blog/archive options
		'your_latest_posts_title' 		=> esc_html__( 'Blogs', 'fairtimes' ),
		'single_post_hide_banner'		=> (bool) false,
		'single_post_hide_image'		=> (bool) false,
		'hide_image' 					=> (bool) false,
		'hide_category'					=> (bool) false,
		'hide_title' 					=> (bool) false,
		'hide_content' 					=> (bool) false,
		'hide_date' 					=> (bool) false,
		'hide_author' 				    => (bool) false,
		'hide_banner'					=> (bool) false,		
		
		// single post theme options
		'single_post_hide_banner'           => (bool) false,
		'single_post_hide_date' 			=> (bool) false,
		'single_post_hide_author'			=> (bool) false,
		'single_post_hide_category'			=> (bool) false,
		'single_post_hide_tags'				=> (bool) false,
		'single_post_hide_featured_image'	=> (bool) false,
		
		/* Front Page */

		// Topbar
		'topbar_section_enable'			    => (bool) false,
		'secondary_menu_enable'			    => (bool) false,
		'social_menu_enable'			    => (bool) false,
		
		// Breaking News
		'breaking_news_section_enable'	    => (bool) false,
		'breaking_news_title'			    => esc_html__('Breaking News', 'fairtimes'),

		// Header Postss
		'header_posts_section_enable'       => (bool) false,

		// Featured Article
		'featured_article_title'		    => esc_html__( 'Featured Article', 'fairtimes' ),
		'featured_article_section_enable'   => (bool) false,

		// Most Popular
		'most_popular_title'		        => esc_html__( 'Most Popular Article', 'fairtimes' ),
		'most_popular_section_enable'       => (bool) false,
		'most_popular_content_type'         => 'post',

		// Latest Posts
		'latest_posts_title'		        => esc_html__( 'Latest Article', 'fairtimes' ),
		'latest_posts_sub_title'		    => esc_html__( 'From Blog', 'fairtimes' ),
		'latest_posts_section_enable'       => (bool) false,
		
		// Popular Posts
		'popular_posts_title'		        => esc_html__( 'Fashion Article', 'fairtimes' ),
		'popular_posts_section_enable'      => (bool) false,
		'popular_posts_content_type'        => 'post',
		'popular_posts_count'               => 4,


	);

$output = apply_filters( 'fairtimes_default_theme_options', $fairtimes_default_options );

	// Sort array in ascending order, according to the key:
if ( ! empty( $output ) ) {
	ksort( $output );
}

return $output;
}