<?php
/**
 * Customizer active callbacks
 *
 * @package Theme Palace
 * @subpackage Fairtimes
 * @since Fairtimes 1.0.0
 */

if ( ! function_exists( 'fairtimes_is_loader_enable' ) ) :
	/**
	 * Check if loader is enabled.
	 *
	 * @since Fairtimes 1.0.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function fairtimes_is_loader_enable( $control ) {
		return $control->manager->get_setting( 'fairtimes_theme_options[loader_enable]' )->value();
	}
endif;

if ( ! function_exists( 'fairtimes_is_breadcrumb_enable' ) ) :
	/**
	 * Check if breadcrumb is enabled.
	 *
	 * @since Fairtimes 1.0.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function fairtimes_is_breadcrumb_enable( $control ) {
		return $control->manager->get_setting( 'fairtimes_theme_options[breadcrumb_enable]' )->value();
	}
endif;

if ( ! function_exists( 'fairtimes_is_pagination_enable' ) ) :
	/**
	 * Check if pagination is enabled.
	 *
	 * @since Fairtimes 1.0.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function fairtimes_is_pagination_enable( $control ) {
		return $control->manager->get_setting( 'fairtimes_theme_options[pagination_enable]' )->value();
	}
endif;

/**
 * Front Page Active Callbacks
 */

/**
 * Check if topbar section is enabled.
 *
 * @since Fairtimes 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function fairtimes_is_topbar_section_enable( $control ) {
	return ( $control->manager->get_setting( 'fairtimes_theme_options[topbar_section_enable]' )->value() );
}

/**
 * Front Page Active Callbacks
 */

/**
 * Check if contact information section is enabled.
 *
 * @since Fairtimes 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function fairtimes_is_contact_information_section_enable( $control ) {
	return ( $control->manager->get_setting( 'fairtimes_theme_options[contact_information_enable]' )->value() );
}

/**
 * Front Page Active Callbacks
 */

/**
 * Check if ads section is enabled.
 *
 * @since Fairtimes 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function fairtimes_is_advertisement_enable( $control ) {
	return ( $control->manager->get_setting( 'fairtimes_theme_options[advertisement_enable]' )->value() );
}

/****************************Breaking News****************************************** */

/**
 * Check if Breaking News section is enabled.
 *
 * @since Fairtimes 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function fairtimes_is_breaking_news_section_enable( $control ) {
	return ( $control->manager->get_setting( 'fairtimes_theme_options[breaking_news_section_enable]' )->value() );
}

/*=================Header Posts===============*/

/**
 * Check if featured_post section is enabled.
 *
 * @since Fairtimes 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function fairtimes_is_header_posts_section_enable( $control ) {
	return ( $control->manager->get_setting( 'fairtimes_theme_options[header_posts_section_enable]' )->value() );
}

/**
 * Check if featured_post section content type is page.
 *
 * @since Fairtimes 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function fairtimes_is_header_posts_section_content_page_enable( $control ) {
	$content_type = $control->manager->get_setting( 'fairtimes_theme_options[header_posts_content_type]' )->value();
	return fairtimes_is_header_posts_section_enable( $control ) && ( 'page' == $content_type );
}

/**
 * Check if featured_post section content type is post.
 *
 * @since Fairtimes 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function fairtimes_is_header_posts_section_content_post_enable( $control ) {
	$content_type = $control->manager->get_setting( 'fairtimes_theme_options[header_posts_content_type]' )->value();
	return fairtimes_is_header_posts_section_enable( $control ) && ( 'post' == $content_type );
}

/*==================Featured Article===============*/

/**
 * Check if featured article section is enabled.
 *
 * @since Fairtimes 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function fairtimes_is_featured_article_section_enable( $control ) {
	return ( $control->manager->get_setting( 'fairtimes_theme_options[featured_article_section_enable]' )->value() );
}

/*==================latest posts===============*/

/**
 * Check if latest posts section is enabled.
 *
 * @since Fairtimes 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function fairtimes_is_latest_posts_section_enable( $control ) {
	return ( $control->manager->get_setting( 'fairtimes_theme_options[latest_posts_section_enable]' )->value() );
}

/*==================popular posts===============*/

/**
 * Check if popular posts section is enabled.
 *
 * @since Fairtimes 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function fairtimes_is_popular_posts_section_enable( $control ) {
	return ( $control->manager->get_setting( 'fairtimes_theme_options[popular_posts_section_enable]' )->value() );
}

/**
 * Check if popular posts section content type is post.
 *
 * @since Fairtimes 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function fairtimes_is_popular_posts_section_content_post_enable( $control ) {
	$content_type = $control->manager->get_setting( 'fairtimes_theme_options[popular_posts_content_type]' )->value();
	return fairtimes_is_popular_posts_section_enable( $control ) && ( 'post' == $content_type );
}

/**
 * Check if popular posts section content type is category.
 *
 * @since Fairtimes 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function fairtimes_is_popular_posts_section_content_category_enable( $control ) {
	$content_type = $control->manager->get_setting( 'fairtimes_theme_options[popular_posts_content_type]' )->value();
	return fairtimes_is_popular_posts_section_enable( $control ) && ( 'category' == $content_type );
}


/*==================most popular===============*/

/**
 * Check if most popular section is enabled.
 *
 * @since Fairtimes 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function fairtimes_is_most_popular_section_enable( $control ) {
	return ( $control->manager->get_setting( 'fairtimes_theme_options[most_popular_section_enable]' )->value() );
}

/**
 * Check if most popular section content type is post.
 *
 * @since Fairtimes 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function fairtimes_is_most_popular_section_content_post_enable( $control ) {
	$content_type = $control->manager->get_setting( 'fairtimes_theme_options[most_popular_content_type]' )->value();
	return fairtimes_is_most_popular_section_enable( $control ) && ( 'post' == $content_type );
}

/**
 * Check if most popular section content type is category.
 *
 * @since Fairtimes 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function fairtimes_is_most_popular_section_content_category_enable( $control ) {
	$content_type = $control->manager->get_setting( 'fairtimes_theme_options[most_popular_content_type]' )->value();
	return fairtimes_is_most_popular_section_enable( $control ) && ( 'category' == $content_type );
}
