<?php
/* AJAX LOAD MORE POST FOR POPULAR POSTS */
add_action('wp_ajax_fairtimes_popular_posts_load_more_posts', 'fairtimes_popular_posts_load_more_posts');
add_action('wp_ajax_nopriv_fairtimes_popular_posts_load_more_posts', 'fairtimes_popular_posts_load_more_posts');
function fairtimes_popular_posts_load_more_posts()
{
	$options = fairtimes_get_theme_options();

	$paged    = $_POST['page'];
	$contents = '';
	$popular_posts_content_type  = $options['popular_posts_content_type'];
	$popular_posts_count = ! empty( $options['popular_posts_count'] ) ? $options['popular_posts_count'] : 4;

	$content = array();
	switch ( $popular_posts_content_type ) {

		case 'post':
		$post_ids = array();

		for ( $i = 1; $i <= $popular_posts_count; $i++ ) {
			if ( ! empty( $options['popular_posts_content_post_' . $i] ) )
				$post_ids[] = $options['popular_posts_content_post_' . $i];
		}

		$args = array(
			'post_type'             => 'post',
			'post__in'              => ( array ) $post_ids,
			'paged'                 => $paged,
			'posts_per_page'        => absint( 4 ),
			'orderby'               => 'post__in',
			'ignore_sticky_posts'   => true,
		);                    
		break;

		case 'category':
		$cat_id = ! empty( $options['popular_posts_content_category'] ) ? $options['popular_posts_content_category'] : '';
		$args = array(
			'post_type'             => 'post',
			'posts_per_page'        => absint( 4 ),
			'cat'                   => absint( $cat_id ),
			'paged'                 => $paged,
			'ignore_sticky_posts'   => true,
		);                    
		break;

		default:
		break;
	}

	$query = new WP_Query($args);

	$max_page = $query->max_num_pages;

	if ($max_page == $paged)
		$next_page = '';
	else
		$next_page = $paged + 1;

	if ($query->have_posts()) :

		ob_start();
		while ( $query->have_posts() ) : $query->the_post();
			$page_post['id']        = get_the_id();
			$page_post['title']     = get_the_title();
			$page_post['url']       = get_the_permalink();
			$page_post['excerpt']   = fairtimes_trim_content( 35 );
			$page_post['image']     = has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'post-thumbnail' ) : get_template_directory_uri() . '/assets/uploads/no-featured-image-590x650.jpg';

			// Push to the main array.
			array_push( $content, $page_post );
		endwhile;
		wp_reset_postdata();
		if ( ! empty( $content ) ) {
			$inputs = $content;
		}
		foreach($inputs as $content) : ?>
			<article class="has-post-thumbnail">
				<div class="featured-image" style="background-image: url('<?php echo esc_url( $content['image'] ); ?>');">
					<a href="<?php echo esc_url( $content['url'] ); ?>" class="post-thumbnail-link"></a>
				</div><!-- .featured-image -->

				<div class="entry-container">
					<div class="entry-meta">
						<span class="cat-links">
							<?php the_category( '', '', $content['id'] ) ?>
						</span><!-- .cat-links -->
						<?php fairtimes_posted_on( $content['id'] ); ?>
						<?php echo fairtimes_author( $content['id'] ); ?>
					</div><!-- .entry-meta -->
					<header class="entry-header">
						<h2 class="entry-title"><a href="<?php echo esc_url( $content['url'] ); ?>"><?php echo esc_html( $content['title'] ); ?></a></h2>
					</header>
					<div class="entry-content">
						<p><?php echo esc_html( $content['excerpt'] ); ?></p>
					</div><!-- .entry-content -->
				</div><!-- .entry-container -->
			</article>
		<?php endforeach;
		$contents = ob_get_clean();
	endif;
	wp_send_json(array('contents' => $contents, 'current_page' => $paged, 'next_page' => $next_page));
}