<?php
	/**
	 * The header for our theme.
	 *
	 * This is the template that displays all of the <head> section and everything up until <div id="content">
	 *
	 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
	 *
	 * @package Theme Palace
	 * @subpackage Fairtimes
	 * @since Fairtimes 1.0.0
	 */

	/**
	 * fairtimes_doctype hook
	 *
	 * @hooked fairtimes_doctype -  10
	 *
	 */
	do_action( 'fairtimes_doctype' );

?>
<head>
<?php
	/**
	 * fairtimes_before_wp_head hook
	 *
	 * @hooked fairtimes_head -  10
	 *
	 */
	do_action( 'fairtimes_before_wp_head' );

	wp_head(); 
?>
</head>

<body <?php body_class(); ?>>

<?php do_action( 'wp_body_open' ); ?>

<?php
	/**
	 * fairtimes_page_start_action hook
	 *
	 * @hooked fairtimes_page_start -  10
	 *
	 */
	do_action( 'fairtimes_page_start_action' ); 

	/**
	 * fairtimes_loader_action hook
	 *
	 * @hooked fairtimes_loader -  10
	 *
	 */
	do_action( 'fairtimes_before_header' );

	/**
	 * fairtimes_header_action hook
	 *
	 * @hooked fairtimes_header_start -  10
	 * @hooked fairtimes_site_branding -  20
	 * @hooked fairtimes_site_navigation -  30
	 * @hooked fairtimes_header_end -  50
	 *
	 */
	do_action( 'fairtimes_header_action' );

	/**
	 * fairtimes_content_start_action hook
	 *
	 * @hooked fairtimes_content_start -  10
	 *
	 */
	do_action( 'fairtimes_content_start_action' );

	/**
	 * fairtimes_header_image_action hook
	 *
	 * @hooked fairtimes_header_image -  10
	 *
	 */
	do_action( 'fairtimes_header_image_action' );
	if ( fairtimes_is_frontpage() ) {
    	$options = fairtimes_get_theme_options();

    	$sorted = explode( ',' , $options['frontpage_sortable'] );
    	
		foreach ( $sorted as $section ) {

			if ( empty( $section ) ) {
				return;
			}
			add_action( 'fairtimes_primary_content', 'fairtimes_add_'. $section .'_section' );
		}

		do_action( 'fairtimes_primary_content' );
	}