<?php
/*This file is part of eyepress child theme.

All functions of this file will be loaded before of parent theme functions.
Learn more at https://codex.wordpress.org/Child_Themes.

Note: this function loads the parent stylesheet before, then child theme stylesheet
(leave it in place unless you know what you are doing.)
*/

/**
 * Enqueue Google Fonts with preconnect for performance
 */
function eyepress_lite_fonts_url()
{
	$fonts_url = '';

	$font_families = array();

	$font_families[] = 'Rubik:400,600';
	$font_families[] = 'Roboto+Slab:400,600,700';

	$query_args = array(
		'family' => urlencode(implode('|', $font_families)),
		'subset' => urlencode('latin,latin-ext'),
		'display' => 'swap' // Add font-display for better performance
	);

	$fonts_url = add_query_arg($query_args, 'https://fonts.googleapis.com/css');

	return esc_url_raw($fonts_url);
}

/**
 * Enqueue child theme styles and scripts
 */
function eyepress_lite_enqueue_child_styles()
{
	// Preconnect to Google Fonts for performance
	add_filter('style_loader_tag', 'eyepress_lite_google_fonts_preconnect', 10, 4);
	
	wp_enqueue_style('eyepress-lite-font', eyepress_lite_fonts_url(), array(), null);
	wp_enqueue_style('eyepress-lite-parent-style', get_template_directory_uri() . '/style.css', array('bootstrap', 'eyepress-google-font', 'slick.min', 'eyepress-default'), '', 'all');
	wp_enqueue_style('eyepress-lite-main', get_stylesheet_directory_uri() . '/assets/css/main.css', array(), '1.0.7', 'all');
	
	// Enqueue RTL stylesheet if needed
	if (is_rtl()) {
		wp_enqueue_style('eyepress-lite-rtl', get_stylesheet_directory_uri() . '/rtl.css', array('eyepress-lite-parent-style'), '1.0.0', 'all');
	}
	
	// Enqueue main JavaScript with version
	wp_enqueue_script('eyepress-lite-main-js', get_stylesheet_directory_uri() . '/assets/js/main.js', array('jquery'), '1.0.0', true);
	
	// Pass theme settings to JavaScript
	$theme_settings = array(
		'dark_mode_default' => get_theme_mod('eyepress_lite_dark_mode', 'system')
	);
	wp_localize_script('eyepress-lite-main-js', 'eyepressLiteSettings', $theme_settings);
}
add_action('wp_enqueue_scripts', 'eyepress_lite_enqueue_child_styles');

/**
 * Add preconnect for Google Fonts
 */
function eyepress_lite_google_fonts_preconnect($html, $handle, $href, $media)
{
	if ($handle === 'eyepress-lite-font') {
		$html = '<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>' . $html;
	}
	return $html;
}

/**
 * Customize excerpt more text
 */
function new_excerpt_more($more)
{
	return ' .....';
}
add_filter('excerpt_more', 'new_excerpt_more');

/**
 * Filter the excerpt length to 35 words.
 */
function eyepress_lite_excerpt_length($length)
{
	return 35;
}
add_filter('excerpt_length', 'eyepress_lite_excerpt_length', 999);

/**
 * Add theme support features
 */
function eyepress_lite_setup()
{
	// Add support for post thumbnails
	add_theme_support('post-thumbnails');
	
	// Add support for HTML5 markup
	add_theme_support('html5', array(
		'search-form',
		'comment-form',
		'comment-list',
		'gallery',
		'caption',
		'style',
		'script',
	));
	
	// Add support for responsive embedded content
	add_theme_support('responsive-embeds');
	
	// Add support for custom logo
	add_theme_support('custom-logo', array(
		'height'      => 100,
		'width'       => 400,
		'flex-height' => true,
		'flex-width'  => true,
		'header-text' => array('site-title', 'site-description'),
	));
}
add_action('after_setup_theme', 'eyepress_lite_setup');

/**
 * Add lazy loading to post thumbnails
 */
function eyepress_lite_add_thumbnail_loading($html, $post_id, $post_thumbnail_id, $size, $attr)
{
	// Ensure $attr is an array
	if (!is_array($attr)) {
		$attr = array();
	}
	
	if (!empty($attr['loading'])) {
		return $html;
	}
	
	$attr['loading'] = 'lazy';
	return wp_get_attachment_image($post_thumbnail_id, $size, false, $attr);
}
add_filter('post_thumbnail_html', 'eyepress_lite_add_thumbnail_loading', 10, 5);

/**
 * Customizer additions.
 */
require get_stylesheet_directory() . '/inc/customizer.php';

/**
 * Content Security Policy headers for security enhancement
 */
function eyepress_lite_csp_headers()
{
	if (!is_admin()) {
		header("Content-Security-Policy: default-src 'self'; script-src 'self' 'unsafe-inline' 'unsafe-eval' https://fonts.googleapis.com https://fonts.gstatic.com; style-src 'self' 'unsafe-inline' https://fonts.googleapis.com https://fonts.gstatic.com; img-src 'self' data: https:; font-src 'self' https://fonts.gstatic.com https://fonts.googleapis.com;");
	}
}
add_action('send_headers', 'eyepress_lite_csp_headers');