<?php
$section_title   = get_theme_mod( 'extensive_news_main_news_title', __( 'Main News', 'extensive-news' ) );
$main_news_query = new WP_Query( $main_news_args );
if ( $main_news_query->have_posts() ) {
	?>
	<div class="slider-part">
		<?php if ( ! empty( $section_title ) ) { ?>
			<div class="section-header">
				<h3 class="section-title"><?php echo esc_html( $section_title ); ?></h3>
			</div>
		<?php } ?>
		<div class="banner-slider magazine-carousel-slider-navigation">
			<?php
			while ( $main_news_query->have_posts() ) :
				$main_news_query->the_post();
				?>
				<div class="carousel-item">
					<div class="mag-post-single banner-grid-single has-image grid-design">
						<div class="mag-post-img">
							<a href="<?php the_permalink(); ?>">
								<?php the_post_thumbnail( 'post-thumbnail' ); ?>
							</a>
						</div>
						<div class="mag-post-detail">
							<div class="mag-post-category">
								<?php extensive_news_categories_list(); ?>
							</div>
							<h3 class="mag-post-title">
								<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
							</h3>
							<div class="mag-post-meta">
								<?php
								extensive_news_posted_by();
								extensive_news_posted_on();
								?>
							</div>
						</div>
					</div>
				</div>
				<?php
			endwhile;
			wp_reset_postdata();
			?>
		</div>
	</div>
	<?php
}
