<?php
$editor_pick_title = get_theme_mod( 'extensive_news_editor_pick_title', __( 'Editor Pick', 'extensive-news' ) );
$editor_query      = new WP_Query( $editor_args );
if ( $editor_query->have_posts() ) {
	?>
	<div class="editors-pick-part">
		<?php if ( ! empty( $editor_pick_title ) ) : ?>
			<div class="section-header">
				<h3 class="section-title"><?php echo esc_html( $editor_pick_title ); ?></h3>
			</div>
		<?php endif; ?>
		<div class="editors-pick-wrapper">
			<?php
			$i = 1;
			while ( $editor_query->have_posts() ) :
				$editor_query->the_post();
				$tile_design = $i == 1 ? 'tile-design' : 'small-list-design';
				$classes     = implode( ' ', array( $tile_design ) );
				?>
				<div class="mag-post-single banner-gird-single has-image <?php echo esc_attr( $classes ); ?>">
					<?php if ( has_post_thumbnail() ) { ?>
						<div class="mag-post-img">
							<a href="<?php the_permalink(); ?>"><?php the_post_thumbnail( 'post-thumbnail' ); ?></a>
						</div>
					<?php } ?>
					<div class="mag-post-detail">
						<div class="mag-post-category <?php echo esc_attr( 1 === $i ? 'with-background' : '' ); ?>">
							<?php extensive_news_categories_list(); ?>
						</div>
						<h4 class="mag-post-title">
							<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
						</h4>
					</div>
				</div>
				<?php
				$i++;
			endwhile;
			wp_reset_postdata();
			?>
		</div>
	</div>
	<?php
}
