<?php

/**
 * Typography
 *
 * @package Extensive News
 */

$wp_customize->add_section(
	'extensive_news_typography',
	array(
		'panel' => 'extensive_news_theme_options',
		'title' => esc_html__( 'Typography', 'extensive-news' ),
	)
);

// Typography - Site Title Font.
$wp_customize->add_setting(
	'extensive_news_site_title_font',
	array(
		'default'           => 'Mukta',
		'sanitize_callback' => 'extensive_news_sanitize_google_fonts',
	)
);

$wp_customize->add_control(
	'extensive_news_site_title_font',
	array(
		'label'    => esc_html__( 'Site Title Font Family', 'extensive-news' ),
		'section'  => 'extensive_news_typography',
		'settings' => 'extensive_news_site_title_font',
		'type'     => 'select',
		'choices'  => extensive_news_get_all_google_font_families(),
	)
);

// Typography - Site Description Font.
$wp_customize->add_setting(
	'extensive_news_site_description_font',
	array(
		'default'           => 'Inter',
		'sanitize_callback' => 'extensive_news_sanitize_google_fonts',
	)
);

$wp_customize->add_control(
	'extensive_news_site_description_font',
	array(
		'label'    => esc_html__( 'Site Description Font Family', 'extensive-news' ),
		'section'  => 'extensive_news_typography',
		'settings' => 'extensive_news_site_description_font',
		'type'     => 'select',
		'choices'  => extensive_news_get_all_google_font_families(),
	)
);

// Typography - Header Font.
$wp_customize->add_setting(
	'extensive_news_header_font',
	array(
		'default'           => 'Inter',
		'sanitize_callback' => 'extensive_news_sanitize_google_fonts',
	)
);

$wp_customize->add_control(
	'extensive_news_header_font',
	array(
		'label'    => esc_html__( 'Header Font Family', 'extensive-news' ),
		'section'  => 'extensive_news_typography',
		'settings' => 'extensive_news_header_font',
		'type'     => 'select',
		'choices'  => extensive_news_get_all_google_font_families(),
	)
);

// Typography - Body Font.
$wp_customize->add_setting(
	'extensive_news_body_font',
	array(
		'default'           => 'Inter',
		'sanitize_callback' => 'extensive_news_sanitize_google_fonts',
	)
);

$wp_customize->add_control(
	'extensive_news_body_font',
	array(
		'label'    => esc_html__( 'Body Font Family', 'extensive-news' ),
		'section'  => 'extensive_news_typography',
		'settings' => 'extensive_news_body_font',
		'type'     => 'select',
		'choices'  => extensive_news_get_all_google_font_families(),
	)
);
