<?php
/**
 * Sidebar Position
 *
 * @package Extensive News
 */

$wp_customize->add_section(
	'extensive_news_sidebar_position',
	array(
		'title' => esc_html__( 'Sidebar Position', 'extensive-news' ),
		'panel' => 'extensive_news_theme_options',
	)
);

// Sidebar Position - Global Sidebar Position.
$wp_customize->add_setting(
	'extensive_news_sidebar_position',
	array(
		'sanitize_callback' => 'extensive_news_sanitize_select',
		'default'           => 'right-sidebar',
	)
);

$wp_customize->add_control(
	'extensive_news_sidebar_position',
	array(
		'label'   => esc_html__( 'Global Sidebar Position', 'extensive-news' ),
		'section' => 'extensive_news_sidebar_position',
		'type'    => 'select',
		'choices' => array(
			'right-sidebar' => esc_html__( 'Right Sidebar', 'extensive-news' ),
			'no-sidebar'    => esc_html__( 'No Sidebar', 'extensive-news' ),
		),
	)
);

// Sidebar Position - Post Sidebar Position.
$wp_customize->add_setting(
	'extensive_news_post_sidebar_position',
	array(
		'sanitize_callback' => 'extensive_news_sanitize_select',
		'default'           => 'right-sidebar',
	)
);

$wp_customize->add_control(
	'extensive_news_post_sidebar_position',
	array(
		'label'   => esc_html__( 'Post Sidebar Position', 'extensive-news' ),
		'section' => 'extensive_news_sidebar_position',
		'type'    => 'select',
		'choices' => array(
			'right-sidebar' => esc_html__( 'Right Sidebar', 'extensive-news' ),
			'no-sidebar'    => esc_html__( 'No Sidebar', 'extensive-news' ),
		),
	)
);

// Sidebar Position - Page Sidebar Position.
$wp_customize->add_setting(
	'extensive_news_page_sidebar_position',
	array(
		'sanitize_callback' => 'extensive_news_sanitize_select',
		'default'           => 'right-sidebar',
	)
);

$wp_customize->add_control(
	'extensive_news_page_sidebar_position',
	array(
		'label'   => esc_html__( 'Page Sidebar Position', 'extensive-news' ),
		'section' => 'extensive_news_sidebar_position',
		'type'    => 'select',
		'choices' => array(
			'right-sidebar' => esc_html__( 'Right Sidebar', 'extensive-news' ),
			'no-sidebar'    => esc_html__( 'No Sidebar', 'extensive-news' ),
		),
	)
);
