<?php
/**
 * Post Options
 *
 * @package Extensive News
 */

$wp_customize->add_section(
	'extensive_news_post_options',
	array(
		'title' => esc_html__( 'Post Options', 'extensive-news' ),
		'panel' => 'extensive_news_theme_options',
	)
);

// Post Options - Hide Date.
$wp_customize->add_setting(
	'extensive_news_post_hide_date',
	array(
		'default'           => false,
		'sanitize_callback' => 'extensive_news_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Extensive_News_Toggle_Switch_Custom_Control(
		$wp_customize,
		'extensive_news_post_hide_date',
		array(
			'label'   => esc_html__( 'Hide Date', 'extensive-news' ),
			'section' => 'extensive_news_post_options',
		)
	)
);

// Post Options - Hide Author.
$wp_customize->add_setting(
	'extensive_news_post_hide_author',
	array(
		'default'           => false,
		'sanitize_callback' => 'extensive_news_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Extensive_News_Toggle_Switch_Custom_Control(
		$wp_customize,
		'extensive_news_post_hide_author',
		array(
			'label'   => esc_html__( 'Hide Author', 'extensive-news' ),
			'section' => 'extensive_news_post_options',
		)
	)
);

// Post Options - Hide Category.
$wp_customize->add_setting(
	'extensive_news_post_hide_category',
	array(
		'default'           => false,
		'sanitize_callback' => 'extensive_news_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Extensive_News_Toggle_Switch_Custom_Control(
		$wp_customize,
		'extensive_news_post_hide_category',
		array(
			'label'   => esc_html__( 'Hide Category', 'extensive-news' ),
			'section' => 'extensive_news_post_options',
		)
	)
);

// Post Options - Hide Tag.
$wp_customize->add_setting(
	'extensive_news_post_hide_tags',
	array(
		'default'           => false,
		'sanitize_callback' => 'extensive_news_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Extensive_News_Toggle_Switch_Custom_Control(
		$wp_customize,
		'extensive_news_post_hide_tags',
		array(
			'label'   => esc_html__( 'Hide Tag', 'extensive-news' ),
			'section' => 'extensive_news_post_options',
		)
	)
);

// Post Options - Related Post Label.
$wp_customize->add_setting(
	'extensive_news_post_related_post_label',
	array(
		'default'           => __( 'Related Posts', 'extensive-news' ),
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'extensive_news_post_related_post_label',
	array(
		'label'    => esc_html__( 'Related Posts Label', 'extensive-news' ),
		'section'  => 'extensive_news_post_options',
		'settings' => 'extensive_news_post_related_post_label',
		'type'     => 'text',
	)
);
