<?php
/**
 * Pagination
 *
 * @package Extensive News
 */

$wp_customize->add_section(
	'extensive_news_pagination',
	array(
		'panel' => 'extensive_news_theme_options',
		'title' => esc_html__( 'Pagination', 'extensive-news' ),
	)
);

// Pagination - Enable Pagination.
$wp_customize->add_setting(
	'extensive_news_enable_pagination',
	array(
		'default'           => true,
		'sanitize_callback' => 'extensive_news_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Extensive_News_Toggle_Switch_Custom_Control(
		$wp_customize,
		'extensive_news_enable_pagination',
		array(
			'label'    => esc_html__( 'Enable Pagination', 'extensive-news' ),
			'section'  => 'extensive_news_pagination',
			'settings' => 'extensive_news_enable_pagination',
			'type'     => 'checkbox',
		)
	)
);

// Pagination - Pagination Type.
$wp_customize->add_setting(
	'extensive_news_pagination_type',
	array(
		'default'           => 'default',
		'sanitize_callback' => 'extensive_news_sanitize_select',
	)
);

$wp_customize->add_control(
	'extensive_news_pagination_type',
	array(
		'label'           => esc_html__( 'Pagination Type', 'extensive-news' ),
		'section'         => 'extensive_news_pagination',
		'settings'        => 'extensive_news_pagination_type',
		'active_callback' => 'extensive_news_is_pagination_enabled',
		'type'            => 'select',
		'choices'         => array(
			'default' => __( 'Default (Older/Newer)', 'extensive-news' ),
			'numeric' => __( 'Numeric', 'extensive-news' ),
		),
	)
);
