<?php
/**
 * Header Options
 *
 * @package Extensive News
 */

$wp_customize->add_section(
	'extensive_news_header_options',
	array(
		'panel' => 'extensive_news_theme_options',
		'title' => esc_html__( 'Header Options', 'extensive-news' ),
	)
);

// Header Options - Enable Topbar.
$wp_customize->add_setting(
	'extensive_news_enable_topbar_section',
	array(
		'sanitize_callback' => 'extensive_news_sanitize_switch',
		'default'           => false,
	)
);

$wp_customize->add_control(
	new Extensive_News_Toggle_Switch_Custom_Control(
		$wp_customize,
		'extensive_news_enable_topbar_section',
		array(
			'label'   => esc_html__( 'Enable Topbar Section', 'extensive-news' ),
			'section' => 'extensive_news_header_options',
		)
	)
);

// Header Options - Advertisement.
$wp_customize->add_setting(
	'extensive_news_header_advertisement',
	array(
		'default'           => '',
		'sanitize_callback' => 'extensive_news_sanitize_image',
	)
);

$wp_customize->add_control(
	new WP_Customize_Image_Control(
		$wp_customize,
		'extensive_news_header_advertisement',
		array(
			'label'    => esc_html__( 'Advertisement', 'extensive-news' ),
			'section'  => 'extensive_news_header_options',
			'settings' => 'extensive_news_header_advertisement',
		)
	)
);

	// Header Options - Advertisement URL.
$wp_customize->add_setting(
	'extensive_news_header_advertisement_url',
	array(
		'default'           => '',
		'sanitize_callback' => 'esc_url_raw',
	)
);

$wp_customize->add_control(
	'extensive_news_header_advertisement_url',
	array(
		'label'    => esc_html__( 'Advertisement URL', 'extensive-news' ),
		'section'  => 'extensive_news_header_options',
		'settings' => 'extensive_news_header_advertisement_url',
		'type'     => 'url',
	)
);
