<?php
/**
 * Excerpt
 *
 * @package Extensive News
 */

$wp_customize->add_section(
	'extensive_news_excerpt_options',
	array(
		'panel' => 'extensive_news_theme_options',
		'title' => esc_html__( 'Excerpt', 'extensive-news' ),
	)
);

// Excerpt - Excerpt Length.
$wp_customize->add_setting(
	'extensive_news_excerpt_length',
	array(
		'default'           => 20,
		'sanitize_callback' => 'extensive_news_sanitize_number_range',
		'validate_callback' => 'extensive_news_validate_excerpt_length',
	)
);

$wp_customize->add_control(
	'extensive_news_excerpt_length',
	array(
		'label'       => esc_html__( 'Excerpt Length (no. of words)', 'extensive-news' ),
		'description' => esc_html__( 'Note: Min 1 & Max 200. Please input the valid number and save. Then refresh the page to see the change.', 'extensive-news' ),
		'section'     => 'extensive_news_excerpt_options',
		'settings'    => 'extensive_news_excerpt_length',
		'type'        => 'number',
		'input_attrs' => array(
			'min'  => 1,
			'max'  => 200,
			'step' => 1,
		),
	)
);
