<?php
/**
 * Breadcrumb
 *
 * @package Extensive News
 */

$wp_customize->add_section(
	'extensive_news_breadcrumb',
	array(
		'title' => esc_html__( 'Breadcrumb', 'extensive-news' ),
		'panel' => 'extensive_news_theme_options',
	)
);

// Breadcrumb - Enable Breadcrumb.
$wp_customize->add_setting(
	'extensive_news_enable_breadcrumb',
	array(
		'sanitize_callback' => 'extensive_news_sanitize_switch',
		'default'           => true,
	)
);

$wp_customize->add_control(
	new Extensive_News_Toggle_Switch_Custom_Control(
		$wp_customize,
		'extensive_news_enable_breadcrumb',
		array(
			'label'   => esc_html__( 'Enable Breadcrumb', 'extensive-news' ),
			'section' => 'extensive_news_breadcrumb',
		)
	)
);

// Breadcrumb - Separator.
$wp_customize->add_setting(
	'extensive_news_breadcrumb_separator',
	array(
		'sanitize_callback' => 'sanitize_text_field',
		'default'           => '/',
	)
);

$wp_customize->add_control(
	'extensive_news_breadcrumb_separator',
	array(
		'label'           => esc_html__( 'Separator', 'extensive-news' ),
		'active_callback' => 'extensive_news_is_breadcrumb_enabled',
		'section'         => 'extensive_news_breadcrumb',
	)
);
