<?php
/**
 * Archive Layout
 *
 * @package Extensive News
 */

$wp_customize->add_section(
	'extensive_news_archive_layout',
	array(
		'title' => esc_html__( 'Archive Layout', 'extensive-news' ),
		'panel' => 'extensive_news_theme_options',
	)
);

// Archive Layout - Grid Style.
$wp_customize->add_setting(
	'extensive_news_archive_grid_style',
	array(
		'default'           => 'grid-column-3',
		'sanitize_callback' => 'extensive_news_sanitize_select',
	)
);

$wp_customize->add_control(
	'extensive_news_archive_grid_style',
	array(
		'label'   => esc_html__( 'Grid Style', 'extensive-news' ),
		'section' => 'extensive_news_archive_layout',
		'type'    => 'select',
		'choices' => array(
			'grid-column-2' => __( 'Column 2', 'extensive-news' ),
			'grid-column-3' => __( 'Column 3', 'extensive-news' ),
		),
	)
);
