<?php
/**
 * Banner Section
 *
 * @package Extensive News
 */

$wp_customize->add_section(
	'extensive_news_banner_section',
	array(
		'panel' => 'extensive_news_front_page_options',
		'title' => esc_html__( 'Banner Section', 'extensive-news' ),
	)
);

// Banner Section - Enable Section.
$wp_customize->add_setting(
	'extensive_news_enable_banner_section',
	array(
		'default'           => false,
		'sanitize_callback' => 'extensive_news_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Extensive_News_Toggle_Switch_Custom_Control(
		$wp_customize,
		'extensive_news_enable_banner_section',
		array(
			'label'    => esc_html__( 'Enable Banner Section', 'extensive-news' ),
			'section'  => 'extensive_news_banner_section',
			'settings' => 'extensive_news_enable_banner_section',
		)
	)
);

if ( isset( $wp_customize->selective_refresh ) ) {
	$wp_customize->selective_refresh->add_partial(
		'extensive_news_enable_banner_section',
		array(
			'selector' => '#extensive_news_banner_section .section-link',
			'settings' => 'extensive_news_enable_banner_section',
		)
	);
}

// Editor Pick Section - Section Title.
$wp_customize->add_setting(
	'extensive_news_editor_pick_title',
	array(
		'default'           => __( 'Editor Pick', 'extensive-news' ),
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'extensive_news_editor_pick_title',
	array(
		'label'           => esc_html__( 'Editor Pick Section Title', 'extensive-news' ),
		'section'         => 'extensive_news_banner_section',
		'settings'        => 'extensive_news_editor_pick_title',
		'type'            => 'text',
		'active_callback' => 'extensive_news_is_banner_section_enabled',
	)
);

// Editor Pick Section - Content Type.
$wp_customize->add_setting(
	'extensive_news_editor_pick_content_type',
	array(
		'default'           => 'post',
		'sanitize_callback' => 'extensive_news_sanitize_select',
	)
);

$wp_customize->add_control(
	'extensive_news_editor_pick_content_type',
	array(
		'label'           => esc_html__( 'Select Editor Pick Content Type', 'extensive-news' ),
		'section'         => 'extensive_news_banner_section',
		'settings'        => 'extensive_news_editor_pick_content_type',
		'type'            => 'select',
		'active_callback' => 'extensive_news_is_banner_section_enabled',
		'choices'         => array(
			'post'     => esc_html__( 'Post', 'extensive-news' ),
			'category' => esc_html__( 'Category', 'extensive-news' ),
		),
	)
);

for ( $i = 1; $i <= 4; $i++ ) {
	// Editor Pick Section - Select Post.
	$wp_customize->add_setting(
		'extensive_news_editor_pick_content_post_' . $i,
		array(
			'sanitize_callback' => 'absint',
		)
	);

	$wp_customize->add_control(
		'extensive_news_editor_pick_content_post_' . $i,
		array(
			'label'           => sprintf( esc_html__( 'Select Post %d', 'extensive-news' ), $i ),
			'section'         => 'extensive_news_banner_section',
			'settings'        => 'extensive_news_editor_pick_content_post_' . $i,
			'active_callback' => 'extensive_news_is_editor_pick_section_and_content_type_post_enabled',
			'type'            => 'select',
			'choices'         => extensive_news_get_post_choices(),
		)
	);

}

// Editor Pick Section - Select Category.
$wp_customize->add_setting(
	'extensive_news_editor_pick_content_category',
	array(
		'sanitize_callback' => 'extensive_news_sanitize_select',
	)
);

$wp_customize->add_control(
	'extensive_news_editor_pick_content_category',
	array(
		'label'           => esc_html__( 'Select Category', 'extensive-news' ),
		'section'         => 'extensive_news_banner_section',
		'settings'        => 'extensive_news_editor_pick_content_category',
		'active_callback' => 'extensive_news_is_editor_pick_section_and_content_type_category_enabled',
		'type'            => 'select',
		'choices'         => extensive_news_get_post_cat_choices(),
	)
);

// Banner Section - Horizontal Line.
$wp_customize->add_setting(
	'extensive_news_editor_pick_horizontal_line',
	array(
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	new Extensive_News_Customize_Horizontal_Line(
		$wp_customize,
		'extensive_news_editor_pick_horizontal_line',
		array(
			'section'         => 'extensive_news_banner_section',
			'settings'        => 'extensive_news_editor_pick_horizontal_line',
			'active_callback' => 'extensive_news_is_banner_section_enabled',
			'type'            => 'hr',
		)
	)
);

// Banner Section - Section Title.
$wp_customize->add_setting(
	'extensive_news_main_news_title',
	array(
		'default'           => __( 'Main News', 'extensive-news' ),
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'extensive_news_main_news_title',
	array(
		'label'           => esc_html__( 'Main News Section Title', 'extensive-news' ),
		'section'         => 'extensive_news_banner_section',
		'settings'        => 'extensive_news_main_news_title',
		'type'            => 'text',
		'active_callback' => 'extensive_news_is_banner_section_enabled',
	)
);

// Banner Section - Main News Content Type.
$wp_customize->add_setting(
	'extensive_news_main_news_content_type',
	array(
		'default'           => 'post',
		'sanitize_callback' => 'extensive_news_sanitize_select',
	)
);

$wp_customize->add_control(
	'extensive_news_main_news_content_type',
	array(
		'label'           => esc_html__( 'Select Main News Content Type', 'extensive-news' ),
		'section'         => 'extensive_news_banner_section',
		'settings'        => 'extensive_news_main_news_content_type',
		'type'            => 'select',
		'active_callback' => 'extensive_news_is_banner_section_enabled',
		'choices'         => array(
			'post'     => esc_html__( 'Post', 'extensive-news' ),
			'category' => esc_html__( 'Category', 'extensive-news' ),
		),
	)
);

for ( $i = 1; $i <= 3; $i++ ) {
	// Banner Section - Select Post.
	$wp_customize->add_setting(
		'extensive_news_main_news_content_post_' . $i,
		array(
			'sanitize_callback' => 'absint',
		)
	);

	$wp_customize->add_control(
		'extensive_news_main_news_content_post_' . $i,
		array(
			'label'           => sprintf( esc_html__( 'Select Post %d', 'extensive-news' ), $i ),
			'section'         => 'extensive_news_banner_section',
			'settings'        => 'extensive_news_main_news_content_post_' . $i,
			'active_callback' => 'extensive_news_is_banner_section_and_content_type_post_enabled',
			'type'            => 'select',
			'choices'         => extensive_news_get_post_choices(),
		)
	);

}

// Banner Section - Select Category.
$wp_customize->add_setting(
	'extensive_news_main_news_content_category',
	array(
		'sanitize_callback' => 'extensive_news_sanitize_select',
	)
);

$wp_customize->add_control(
	'extensive_news_main_news_content_category',
	array(
		'label'           => esc_html__( 'Select Category', 'extensive-news' ),
		'section'         => 'extensive_news_banner_section',
		'settings'        => 'extensive_news_main_news_content_category',
		'active_callback' => 'extensive_news_is_banner_section_and_content_type_category_enabled',
		'type'            => 'select',
		'choices'         => extensive_news_get_post_cat_choices(),
	)
);

// Banner Section - Horizontal Line.
$wp_customize->add_setting(
	'extensive_news_main_news_horizontal_line',
	array(
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	new Extensive_News_Customize_Horizontal_Line(
		$wp_customize,
		'extensive_news_main_news_horizontal_line',
		array(
			'section'         => 'extensive_news_banner_section',
			'settings'        => 'extensive_news_main_news_horizontal_line',
			'active_callback' => 'extensive_news_is_banner_section_enabled',
			'type'            => 'hr',
		)
	)
);

// Trending Posts Section - Section Title.
$wp_customize->add_setting(
	'extensive_news_trending_posts_title',
	array(
		'default'           => __( 'Trending Posts', 'extensive-news' ),
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'extensive_news_trending_posts_title',
	array(
		'label'           => esc_html__( 'Trending Posts Section Title', 'extensive-news' ),
		'section'         => 'extensive_news_banner_section',
		'settings'        => 'extensive_news_trending_posts_title',
		'type'            => 'text',
		'active_callback' => 'extensive_news_is_banner_section_enabled',
	)
);

// Trending Section - Content Type.
$wp_customize->add_setting(
	'extensive_news_trending_posts_content_type',
	array(
		'default'           => 'post',
		'sanitize_callback' => 'extensive_news_sanitize_select',
	)
);

$wp_customize->add_control(
	'extensive_news_trending_posts_content_type',
	array(
		'label'           => esc_html__( 'Select Trending Content Type', 'extensive-news' ),
		'section'         => 'extensive_news_banner_section',
		'settings'        => 'extensive_news_trending_posts_content_type',
		'type'            => 'select',
		'active_callback' => 'extensive_news_is_banner_section_enabled',
		'choices'         => array(
			'post'     => esc_html__( 'Post', 'extensive-news' ),
			'category' => esc_html__( 'Category', 'extensive-news' ),
		),
	)
);

for ( $i = 1; $i <= 7; $i++ ) {
	// Trending Section - Select Post.
	$wp_customize->add_setting(
		'extensive_news_trending_posts_content_post_' . $i,
		array(
			'sanitize_callback' => 'absint',
		)
	);

	$wp_customize->add_control(
		'extensive_news_trending_posts_content_post_' . $i,
		array(
			'label'           => sprintf( esc_html__( 'Select Post %d', 'extensive-news' ), $i ),
			'section'         => 'extensive_news_banner_section',
			'settings'        => 'extensive_news_trending_posts_content_post_' . $i,
			'active_callback' => 'extensive_news_is_trending_posts_section_and_content_type_post_enabled',
			'type'            => 'select',
			'choices'         => extensive_news_get_post_choices(),
		)
	);

}

// Trending Section - Select Category.
$wp_customize->add_setting(
	'extensive_news_trending_posts_content_category',
	array(
		'sanitize_callback' => 'extensive_news_sanitize_select',
	)
);

$wp_customize->add_control(
	'extensive_news_trending_posts_content_category',
	array(
		'label'           => esc_html__( 'Select Category', 'extensive-news' ),
		'section'         => 'extensive_news_banner_section',
		'settings'        => 'extensive_news_trending_posts_content_category',
		'active_callback' => 'extensive_news_is_trending_posts_section_and_content_type_category_enabled',
		'type'            => 'select',
		'choices'         => extensive_news_get_post_cat_choices(),
	)
);

// Banner Section - Horizontal Line.
$wp_customize->add_setting(
	'extensive_news_trending_posts_horizontal_line',
	array(
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	new Extensive_News_Customize_Horizontal_Line(
		$wp_customize,
		'extensive_news_trending_posts_horizontal_line',
		array(
			'section'         => 'extensive_news_banner_section',
			'settings'        => 'extensive_news_trending_posts_horizontal_line',
			'active_callback' => 'extensive_news_is_banner_section_enabled',
			'type'            => 'hr',
		)
	)
);
