<?php

/**
 * Template part for displaying front page introduction.
 *
 * @package Express News
 */

// Banner Section.
$banner_section = get_theme_mod( 'express_news_banner_section_enable', false );

if ( false === $banner_section ) {
	return;
}

$banner_post_content_ids   = array();
$banner_post_content_ids[] = get_theme_mod( 'express_news_banner_posts_post' );

$banner_posts_args = array(
	'post_type'           => 'post',
	'post__in'            => array_filter( $banner_post_content_ids ),
	'orderby'             => 'post__in',
	'posts_per_page'      => absint( 1 ),
	'ignore_sticky_posts' => true,
);
?>

<div id="express_news_banner_section" class="main-banner-section style-2 adore-navigation">
	<div class="theme-wrapper">
		<div class="main-banner-section-wrapper">

			<!-- Banner Posts -->
			<div class="banner-post-outer">
				<div class="banner-post-wrapper">
					<?php
					$banner_posts = new WP_Query( $banner_posts_args );
					if ( $banner_posts->have_posts() ) {
						while ( $banner_posts->have_posts() ) :
							$banner_posts->the_post();
							$excerpt_length = get_theme_mod( 'express_news_banner_posts_excerpt_length', 120 );
							?>
							<div class="post-item">
								<div class="blog-banner">
									<?php if ( has_post_thumbnail() ) { ?>
										<div class="post-item-image">
											<a href="<?php the_permalink(); ?>">
												<?php the_post_thumbnail( 'post-thumbnail' ); ?>
											</a>
										</div>
									<?php } ?>
									<div class="post-item-content">
										<div class="entry-cat">
											<?php the_category( '', '', get_the_ID() ); ?>
										</div>
										<h2 class="entry-title">
											<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
										</h2>
										<ul class="entry-meta">
											<li class="post-author"> <a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>"><span class="far fa-user"></span><?php echo esc_html( get_the_author() ); ?></a></li>
											<li class="post-date"> <span class="far fa-calendar-alt"></span><?php echo esc_html( get_the_date() ); ?></li>
											<li class="post-comment"><span class="far fa-comment"></span><?php echo absint( get_comments_number( get_the_ID() ) ); ?></li>
										</ul>
										<div class="post-exerpt">
											<?php echo wp_kses_post( wp_trim_words( get_the_content(), $excerpt_length ) ); ?>
										</div>
									</div>
								</div>
							</div>
							<!-- Related Posts Section -->
							<?php
							$cat_content_id = get_the_category( $post->ID )[0]->term_id;
							$posts_orderby  = get_theme_mod( 'express_news_banner_posts_related_posts_orderby', 'date' );
							$args           = array(
								'cat'            => $cat_content_id,
								'posts_per_page' => 3,
								'post__not_in'   => array( $post->ID ),
								'orderby'        => $posts_orderby,
							);
							$query          = new WP_Query( $args );
							if ( $query->have_posts() ) :
								$related_title = get_theme_mod( 'express_news_banner_posts_related_posts_title', __( 'Related Posts', 'express-news' ) );
								?>
								<div class="banner-related-posts-section">
									<?php if ( ! empty( $related_title ) ) : ?>
										<h3 class="related-title"><?php echo esc_html( $related_title ); ?></h3>
									<?php endif; ?>
									<div class="banner-related-posts">
										<?php
										while ( $query->have_posts() ) :
											$query->the_post();
											?>
											<div class="banner-related-article">
												<span class="post-date"> <span class="far fa-calendar-alt"></span><?php echo esc_html( get_the_date() ); ?></span>
												<h3 class="entry-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
											</div>
											<?php
										endwhile;
										wp_reset_postdata();
										?>
									</div>
								</div>
								<?php
							endif;
							// End Related Posts Section.
						endwhile;
						wp_reset_postdata();
					}
					?>
				</div>
			</div>
			<!-- End Banner Posts -->

			<?php
			$latest_news_enable = get_theme_mod( 'express_news_latest_news_tab_enable', true );
			$random_news_enable = get_theme_mod( 'express_news_random_news_tab_enable', true );

			if ( $latest_news_enable === true || $random_news_enable === true ) {

				$latest_news_title = get_theme_mod( 'express_news_latest_news_tab_title', __( 'Latest News', 'express-news' ) );
				$random_news_title = get_theme_mod( 'express_news_random_news_tab_title', __( 'Random News', 'express-news' ) );

				?>
				<!-- Post Tab -->
				<div class="post-tabs-wrapper">
					<div class="post-tabs-head">
						<ul class="post-tabs">
							<?php if ( $latest_news_enable === true ) : ?>
								<li><a href="#tab-1" class="latest"><i class="far fa-clock"></i><?php echo esc_html( $latest_news_title ); ?></a></li>
							<?php endif; ?>
							<?php if ( $random_news_enable === true ) : ?>
								<li><a href="#tab-3" class="latest"><i class="fas fa-random"></i><?php echo esc_html( $random_news_title ); ?></a></li>
							<?php endif; ?>
						</ul>
					</div>
					<div class="post-tab-content-wrapper">
						<?php if ( $latest_news_enable === true ) : ?>
							<div class="post-tab-container" id="tab-1">
								<?php
								$latest_news_args  = array(
									'post_type'      => 'post',
									'post_status'    => 'publish',
									'posts_per_page' => absint( 5 ),
								);
								$latest_news_query = new WP_Query( $latest_news_args );
								if ( $latest_news_query->have_posts() ) :
									while ( $latest_news_query->have_posts() ) :
										$latest_news_query->the_post();
										$excerpt_length = get_theme_mod( 'express_news_tab_posts_excerpt_length', 10 );
										?>
										<div class="post-item post-list">
											<div class="post-item-content">
												<div class="entry-cat no-bg">
													<?php the_category( '', '', get_the_ID() ); ?>
												</div>
												<h3 class="entry-title">
													<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
												</h3>
												<ul class="entry-meta">
													<li class="post-author"> <a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>"><span class="far fa-user"></span><?php echo esc_html( get_the_author() ); ?></a></li>
													<li class="post-date"> <span class="far fa-calendar-alt"></span><?php echo esc_html( get_the_date() ); ?></li>
													<li class="post-comment"><span class="far fa-comment"></span><?php echo absint( get_comments_number( get_the_ID() ) ); ?></li>
												</ul>
												<div class="post-exerpt">
													<p><?php echo wp_kses_post( wp_trim_words( get_the_content(), $excerpt_length ) ); ?></p>
												</div>
											</div>
										</div>
										<?php
									endwhile;
									wp_reset_postdata();
								endif;
								?>
							</div>
						<?php endif; ?>
						<?php if ( $random_news_enable === true ) : ?>
							<div class="post-tab-container" id="tab-3">
								<?php
								$random_posts_args = array(
									'posts_per_page'      => 5,
									'post_type'           => 'post',
									'ignore_sticky_posts' => true,
									'orderby'             => 'rand',
								);
								$random_query      = new WP_Query( $random_posts_args );
								if ( $random_query->have_posts() ) {
									while ( $random_query->have_posts() ) :
										$random_query->the_post();
										?>
										<div class="post-item post-list">
											<div class="post-item-content">
												<div class="entry-cat no-bg">
													<?php the_category( '', '', get_the_ID() ); ?>
												</div>
												<h3 class="entry-title">
													<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
												</h3>
												<ul class="entry-meta">
													<li class="post-author"> <a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>"><span class="far fa-user"></span><?php echo esc_html( get_the_author() ); ?></a></li>
													<li class="post-date"> <span class="far fa-calendar-alt"></span><?php echo esc_html( get_the_date() ); ?></li>
													<li class="post-comment"><span class="far fa-comment"></span><?php echo absint( get_comments_number( get_the_ID() ) ); ?></li>
												</ul>
												<div class="post-exerpt">
													<p><?php echo wp_kses_post( wp_trim_words( get_the_content(), $excerpt_length ) ); ?></p>
												</div>
											</div>
										</div>
										<?php
									endwhile;
									wp_reset_postdata();
								}
								?>
							</div>
						<?php endif; ?>
					</div>
				</div>
				<!-- End Post Tab -->

			<?php } ?>

		</div>
	</div>
</div>
