<?php
/**
 * Single Post Options
 */

$wp_customize->add_section(
	'express_news_single_page_options',
	array(
		'title' => esc_html__( 'Single Post Options', 'express-news' ),
		'panel' => 'express_news_theme_options_panel',
	)
);

// Enable single post category setting.
$wp_customize->add_setting(
	'express_news_enable_single_category',
	array(
		'default'           => true,
		'sanitize_callback' => 'express_news_sanitize_checkbox',
	)
);

$wp_customize->add_control(
	new Express_News_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'express_news_enable_single_category',
		array(
			'label'    => esc_html__( 'Enable Category', 'express-news' ),
			'settings' => 'express_news_enable_single_category',
			'section'  => 'express_news_single_page_options',
			'type'     => 'checkbox',
		)
	)
);

// Enable single post author setting.
$wp_customize->add_setting(
	'express_news_enable_single_author',
	array(
		'default'           => true,
		'sanitize_callback' => 'express_news_sanitize_checkbox',
	)
);

$wp_customize->add_control(
	new Express_News_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'express_news_enable_single_author',
		array(
			'label'    => esc_html__( 'Enable Author', 'express-news' ),
			'settings' => 'express_news_enable_single_author',
			'section'  => 'express_news_single_page_options',
			'type'     => 'checkbox',
		)
	)
);

// Enable single post date setting.
$wp_customize->add_setting(
	'express_news_enable_single_date',
	array(
		'default'           => true,
		'sanitize_callback' => 'express_news_sanitize_checkbox',
	)
);

$wp_customize->add_control(
	new Express_News_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'express_news_enable_single_date',
		array(
			'label'    => esc_html__( 'Enable Date', 'express-news' ),
			'settings' => 'express_news_enable_single_date',
			'section'  => 'express_news_single_page_options',
			'type'     => 'checkbox',
		)
	)
);

// Enable single post tag setting.
$wp_customize->add_setting(
	'express_news_enable_single_tag',
	array(
		'default'           => true,
		'sanitize_callback' => 'express_news_sanitize_checkbox',
	)
);

$wp_customize->add_control(
	new Express_News_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'express_news_enable_single_tag',
		array(
			'label'    => esc_html__( 'Enable Post Tag', 'express-news' ),
			'settings' => 'express_news_enable_single_tag',
			'section'  => 'express_news_single_page_options',
			'type'     => 'checkbox',
		)
	)
);

// Single post related Posts title label.
$wp_customize->add_setting(
	'express_news_related_posts_title',
	array(
		'default'           => __( 'Related Posts', 'express-news' ),
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'express_news_related_posts_title',
	array(
		'label'    => esc_html__( 'Related Posts Title', 'express-news' ),
		'section'  => 'express_news_single_page_options',
		'settings' => 'express_news_related_posts_title',
	)
);
