<?php
/**
 * Sidebar settings.
 */

$wp_customize->add_section(
	'express_news_sidebar_option',
	array(
		'title' => esc_html__( 'Sidebar Options', 'express-news' ),
		'panel' => 'express_news_theme_options_panel',
	)
);

// Sidebar Option - Global Sidebar Position.
$wp_customize->add_setting(
	'express_news_sidebar_position',
	array(
		'sanitize_callback' => 'express_news_sanitize_select',
		'default'           => 'right-sidebar',
	)
);

$wp_customize->add_control(
	'express_news_sidebar_position',
	array(
		'label'   => esc_html__( 'Global Sidebar Position', 'express-news' ),
		'section' => 'express_news_sidebar_option',
		'type'    => 'select',
		'choices' => array(
			'right-sidebar' => esc_html__( 'Right Sidebar', 'express-news' ),
			'no-sidebar'    => esc_html__( 'No Sidebar', 'express-news' ),
		),
	)
);

// Sidebar Option - Post Sidebar Position.
$wp_customize->add_setting(
	'express_news_post_sidebar_position',
	array(
		'sanitize_callback' => 'express_news_sanitize_select',
		'default'           => 'right-sidebar',
	)
);

$wp_customize->add_control(
	'express_news_post_sidebar_position',
	array(
		'label'   => esc_html__( 'Post Sidebar Position', 'express-news' ),
		'section' => 'express_news_sidebar_option',
		'type'    => 'select',
		'choices' => array(
			'right-sidebar' => esc_html__( 'Right Sidebar', 'express-news' ),
			'no-sidebar'    => esc_html__( 'No Sidebar', 'express-news' ),
		),
	)
);

// Sidebar Option - Page Sidebar Position.
$wp_customize->add_setting(
	'express_news_page_sidebar_position',
	array(
		'sanitize_callback' => 'express_news_sanitize_select',
		'default'           => 'right-sidebar',
	)
);

$wp_customize->add_control(
	'express_news_page_sidebar_position',
	array(
		'label'   => esc_html__( 'Page Sidebar Position', 'express-news' ),
		'section' => 'express_news_sidebar_option',
		'type'    => 'select',
		'choices' => array(
			'right-sidebar' => esc_html__( 'Right Sidebar', 'express-news' ),
			'no-sidebar'    => esc_html__( 'No Sidebar', 'express-news' ),
		),
	)
);
