<?php
/**
 * Header Options settings
 */

$wp_customize->add_section(
	'express_news_header_options_section',
	array(
		'title' => esc_html__( 'Header Options', 'express-news' ),
		'panel' => 'express_news_theme_options_panel',
	)
);

// Enable topbar Options.
$wp_customize->add_setting(
	'express_news_enable_topbar',
	array(
		'default'           => true,
		'sanitize_callback' => 'express_news_sanitize_checkbox',
	)
);

$wp_customize->add_control(
	new Express_News_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'express_news_enable_topbar',
		array(
			'label'    => esc_html__( 'Enable Topbar.', 'express-news' ),
			'section'  => 'express_news_header_options_section',
			'settings' => 'express_news_enable_topbar',
			'type'     => 'checkbox',
			'priority' => 10,
		)
	)
);
