<?php
/**
 * Back To Top settings
 */

$wp_customize->add_section(
	'express_news_back_to_top_section',
	array(
		'title' => esc_html__( 'Scroll Up ( Back To Top )', 'express-news' ),
		'panel' => 'express_news_theme_options_panel',
	)
);

// Scroll to top enable setting.
$wp_customize->add_setting(
	'express_news_enable_scroll_to_top',
	array(
		'default'           => true,
		'sanitize_callback' => 'express_news_sanitize_checkbox',
	)
);
$wp_customize->add_control(
	new Express_News_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'express_news_enable_scroll_to_top',
		array(
			'label'    => esc_html__( 'Enable scroll to top.', 'express-news' ),
			'settings' => 'express_news_enable_scroll_to_top',
			'section'  => 'express_news_back_to_top_section',
			'type'     => 'checkbox',
		)
	)
);
