<?php
/**
 * Template Name: Custom Home
 */

get_header(); ?>

<main id="skip-content" role="main">

	<?php do_action( 'expert_teacher_above_slider' ); ?>

	<?php if( get_theme_mod('expert_teacher_slider_hide_show') != ''){ ?>
		<section id="slider">
			<div id="carouselExampleIndicators" class="carousel" data-ride="carousel"> 
			    <?php $expert_teacher_slider_pages = array();
			    for ( $count = 1; $count <= 4; $count++ ) {
			        $mod = intval( get_theme_mod( 'expert_teacher_slider'. $count ));
			        if ( 'page-none-selected' != $mod ) {
			          $expert_teacher_slider_pages[] = $mod;
			        }
			    }
		      	if( !empty($expert_teacher_slider_pages) ) :
			        $args = array(
			          	'post_type' => 'page',
			          	'post__in' => $expert_teacher_slider_pages,
			          	'orderby' => 'post__in'
			        );
		        	$query = new WP_Query( $args );
		        if ( $query->have_posts() ) :
		          	$i = 1;
		    	?>     
				    <div class="carousel-inner" role="listbox">
				      	<?php  while ( $query->have_posts() ) : $query->the_post(); ?>
					        <div <?php if($i == 1){echo 'class="carousel-item fade-in-image active"';} else{ echo 'class="carousel-item fade-in-image"';}?>>
					        	<div class="slider-main py-5">
					        		<div class="container">
							        	<div class="row">
						            		<div class="col-lg-6 col-md-6 slider-content">
											<?php
												$expert_teacher_slider_effect = get_theme_mod('expert_teacher_slider_effect', '') 
											?>
						            			<div class="carousel-caption <?php echo ($expert_teacher_slider_effect); ?>">
										            <div class="inner-carousel">
										              	<h2><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
										              	<p><?php $expert_teacher_excerpt = get_the_excerpt(); echo esc_html( expert_teacher_string_limit_words( $expert_teacher_excerpt, esc_attr(get_theme_mod('expert_teacher_slider_excerpt_length','15') ) )); ?></p>
										              	<a href="<?php the_permalink(); ?>" class="read-btn"><span><?php echo esc_html('Read More','expert-teacher'); ?></span></a>
								            		</div>
								            	</div>
								            </div>
							        		<div class="col-lg-6 col-md-6 slider-bg position-relative">
									        	<div class="slider-img text-right">
						            				<?php if (has_post_thumbnail()) { ?>
														<img src="<?php echo esc_url(get_the_post_thumbnail_url(null, 'full')); ?>" alt="<?php the_title_attribute(); ?>" />
													<?php } else { ?>
														<img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/slider.png" alt="<?php the_title_attribute(); ?>" />
													<?php } ?>
						            				<?php if (get_theme_mod('expert_teacher_experience_text')){ ?>
						            					<div class="experience-text">
						            						<span><?php echo esc_html(get_theme_mod('expert_teacher_experience_text')); ?></span>
						            					</div>
						            				<?php }?>
						            			</div>
						            		</div>
								        </div>
								    </div>
							    </div>
					        </div>
				      	<?php $i++; endwhile; 
				      	wp_reset_postdata();?>
				    </div>
			    <?php else : ?>
			    	<div class="no-postfound"></div>
	      		<?php endif;
			    endif;?>
			    <a class="carousel-control-prev" href="#carouselExampleIndicators" role="button" data-slide="prev">
			      	<span class="carousel-control-prev-icon" aria-hidden="true"><i class="fas fa-chevron-left"></i></span>
			      	<span class="screen-reader-text"><?php esc_html_e( 'Prev','expert-teacher' );?></span>
			    </a>
			    <a class="carousel-control-next" href="#carouselExampleIndicators" role="button" data-slide="next">
			      	<span class="carousel-control-next-icon" aria-hidden="true"><i class="fas fa-chevron-right"></i></span>
			      	<span class="screen-reader-text"><?php esc_html_e( 'Next','expert-teacher' );?></span>
			    </a>
			</div>
		  	<div class="clearfix"></div>
		</section>
	<?php }?>
	
	<?php do_action('expert_teacher_below_slider'); ?>

	<?php if(get_theme_mod('expert_teacher_section_title') != '' || get_theme_mod('expert_teacher_small_title') != '' || get_theme_mod('expert_teacher_category_setting') != ''){ ?>
		<section id="courses-section" class="py-4">
			<div class="container">
				<div class="row">
					<div class="col-lg-5 col-md-5 pr-5">
						<?php if(get_theme_mod('expert_teacher_courses_image') != ''){?>
							<img src="<?php echo esc_url(get_theme_mod('expert_teacher_courses_image')); ?>" alt="<?php echo esc_attr('Courses Image', 'expert-teacher'); ?>" class="courses-img">
						<?php }?>
					</div>
					<div class="col-lg-7 col-md-7">
						<div class="courses-head">
							<?php if(get_theme_mod('expert_teacher_section_title') != ''){?>
								<h3><?php echo esc_html(get_theme_mod('expert_teacher_section_title')); ?></h3>
							<?php }?>
							<?php if(get_theme_mod('expert_teacher_section_text') != ''){?>
								<p class="mb-0"><?php echo esc_html(get_theme_mod('expert_teacher_section_text')); ?></p>
							<?php }?>
						</div>
						<?php if(get_theme_mod('expert_teacher_subject_title') != ''){?>
							<h4><?php echo esc_html(get_theme_mod('expert_teacher_subject_title')); ?></h4>
						<?php }?>
						<?php $expert_teacher_catData1 =  get_theme_mod('expert_teacher_category_setting');
						if($expert_teacher_catData1){ 
							$args = array(
								'post_type' => 'post',
								'category_name' => esc_html($expert_teacher_catData1 ,'expert-teacher'),
					          	'posts_per_page' => get_theme_mod('expert_teacher_subject_number', 4)
					        );
					        $i=1; $counter = 1; ?>
					        <div class="row">
				        		<?php $query = new WP_Query( $args );
					          	if ( $query->have_posts() ) :
					        		while( $query->have_posts() ) : $query->the_post(); ?>
					          			<div class="col-lg-6 col-md-12">
					          				<div class="courses-box mb-4">
					          					<div class="row">
					          						<div class="col-lg-3 col-md-3 col-3 align-self-center">
					          							<div class="courses-icon text-center">
						      								<i class="<?php echo esc_attr(get_theme_mod('expert_teacher_courses_icon' . $i, 'fas fa-calculator')); ?>"></i>
						      							</div>
					          						</div>
					          						<div class="col-lg-9 col-md-9 col-9 align-self-center">
					          							<div class="courses-content">
										            		<h5><a href="<?php the_permalink() ?>"><?php the_title(); ?></a></h5>
											              	<p><?php $expert_teacher_excerpt = get_the_excerpt(); echo esc_html( expert_teacher_string_limit_words( $expert_teacher_excerpt,8 ) ); ?></p>
							            				</div>
					          						</div>
					          					</div>
					          				</div>
									    </div>
					          		<?php $i++; $counter++; endwhile; 
					          		wp_reset_postdata(); ?>
					          	<?php else : ?>
					              	<div class="no-postfound"></div>
					            <?php endif; ?>
			          		</div>
			      		<?php }?>
					</div>
				</div>
			</div>
		</section>
	<?php }?>

	<?php do_action('expert_teacher_below_service_section'); ?>

	<div class="container">
	  	<?php while ( have_posts() ) : the_post(); ?>
	  		<div class="lz-content">
	        	<?php the_content(); ?>
	        </div>
	    <?php endwhile; // end of the loop. ?>
	</div>
</main>

<?php get_footer(); ?>