<?php 

	$expert_teacher_custom_style = '';

	// Logo Size
	$expert_teacher_logo_top_margin = get_theme_mod('expert_teacher_logo_top_margin');
	$expert_teacher_logo_bottom_margin = get_theme_mod('expert_teacher_logo_bottom_margin');
	$expert_teacher_logo_left_margin = get_theme_mod('expert_teacher_logo_left_margin');
	$expert_teacher_logo_right_margin = get_theme_mod('expert_teacher_logo_right_margin');

	if( $expert_teacher_logo_top_margin != '' || $expert_teacher_logo_bottom_margin != '' || $expert_teacher_logo_left_margin != '' || $expert_teacher_logo_right_margin != ''){
		$expert_teacher_custom_style .=' .logo {';
			$expert_teacher_custom_style .=' margin-top: '.esc_attr($expert_teacher_logo_top_margin).'px ;
			margin-bottom: '.esc_attr($expert_teacher_logo_bottom_margin).'px ;
			margin-left: '.esc_attr($expert_teacher_logo_left_margin).'px ;
			margin-right: '.esc_attr($expert_teacher_logo_right_margin).'px ;';
		$expert_teacher_custom_style .=' }';
	}

	$expert_teacher_logo_size = get_theme_mod('expert_teacher_logo_size');
	if( $expert_teacher_logo_size != '') {
		if($expert_teacher_logo_size == 100) {
			$expert_teacher_custom_style .=' .custom-logo-link img {';
				$expert_teacher_custom_style .=' width: 350px;';
			$expert_teacher_custom_style .=' }';
		} else if($expert_teacher_logo_size >= 10 && $expert_teacher_logo_size < 100) {
			$expert_teacher_custom_style .=' .custom-logo-link img {';
				$expert_teacher_custom_style .=' width: '.esc_attr($expert_teacher_logo_size).'%;';
			$expert_teacher_custom_style .=' }';
		}
	}

	// Site Title Font Size
	$expert_teacher_site_title_fontsize = get_theme_mod('expert_teacher_site_title_fontsize');
	if( $expert_teacher_site_title_fontsize != ''){
		$expert_teacher_custom_style .=' .logo h1.site-title, .logo p.site-title {';
			$expert_teacher_custom_style .=' font-size: '.esc_attr($expert_teacher_site_title_fontsize).'px;';
		$expert_teacher_custom_style .=' }';
	}

	$expert_teacher_site_title_color = get_theme_mod('expert_teacher_site_title_color');
	if ( $expert_teacher_site_title_color != '') {
		$expert_teacher_custom_style .=' h1.site-title a, p.site-title a {';
			$expert_teacher_custom_style .=' color:'.esc_attr($expert_teacher_site_title_color).';';
		$expert_teacher_custom_style .=' }';
	}

	$expert_teacher_site_tagline_color = get_theme_mod('expert_teacher_site_tagline_color');
	if ( $expert_teacher_site_tagline_color != '') {
		$expert_teacher_custom_style .=' p.site-description {';
			$expert_teacher_custom_style .=' color:'.esc_attr($expert_teacher_site_tagline_color).';';
		$expert_teacher_custom_style .=' }';
	}

	//layout width
	$expert_teacher_boxfull_width = get_theme_mod('expert_teacher_boxfull_width');
	if ($expert_teacher_boxfull_width !== '') {
		switch ($expert_teacher_boxfull_width) {
			case 'container':
				$expert_teacher_custom_style .= ' body, #header, .bottom-header {
					max-width: 1140px;
					width: 100%;
					padding-right: 15px;
					padding-left: 15px;
					margin-right: auto;
					margin-left: auto;
					}';
				break;
			case 'container-fluid':
				$expert_teacher_custom_style .= ' body, #header, .bottom-header { 
					width: 100%;
					padding-right: 15px;
					padding-left: 15px;
					margin-right: auto;
					margin-left: auto;
					}';
				break;
			case 'none':
				// No specific width specified, so no additional style needed.
				break;
			default:
				// Handle unexpected values.
				break;
		}
	}

	//Menu animation
	$expert_teacher_dropdown_anim = get_theme_mod('expert_teacher_dropdown_anim');

	if ( $expert_teacher_dropdown_anim != '') {
		$expert_teacher_custom_style .=' .nav-menu ul ul {';
			$expert_teacher_custom_style .=' animation:'.esc_attr($expert_teacher_dropdown_anim).' 1s ease;';
		$expert_teacher_custom_style .=' }';
	}

	// Header Image
	$header_image_url = expert_teacher_banner_image( $image_url = '' );
	if( $header_image_url != ''){
		$expert_teacher_custom_style .=' #inner-pages-header {';
			$expert_teacher_custom_style .=' background-image: url('. esc_url( $header_image_url ).'); background-size: cover; background-repeat: no-repeat; background-attachment: fixed;';
		$expert_teacher_custom_style .=' }';
		$expert_teacher_custom_style .=' .header-overlay {';
			$expert_teacher_custom_style .=' position: absolute; 	width: 100%; height: 100%; 	top: 0; left: 0; background: #000; opacity: 0.3;';
		$expert_teacher_custom_style .=' }';
	} else {
		$expert_teacher_custom_style .=' #inner-pages-header {';
			$expert_teacher_custom_style .=' background: linear-gradient(0deg,#eceffc,#fff 80%) no-repeat; ';
		$expert_teacher_custom_style .=' }';
		$expert_teacher_custom_style .=' #inner-pages-header h1, #inner-pages-header .theme-breadcrumb, #inner-pages-header .theme-breadcrumb span, #inner-pages-header .theme-breadcrumb a {';
			$expert_teacher_custom_style .=' color: #000; ';
		$expert_teacher_custom_style .=' }';
	}

	$expert_teacher_menu_color = get_theme_mod('expert_teacher_menu_color');
	if ( $expert_teacher_menu_color != '') {
		$expert_teacher_custom_style .=' .nav-menu ul li a {';
			$expert_teacher_custom_style .=' color:'.esc_attr($expert_teacher_menu_color).';';
		$expert_teacher_custom_style .=' }';
	}

	$expert_teacher_menuhvr_color = get_theme_mod('expert_teacher_menuhvr_color');
	if ( $expert_teacher_menuhvr_color != '') {
		$expert_teacher_custom_style .=' .nav-menu ul li a:hover {';
			$expert_teacher_custom_style .=' color:'.esc_attr($expert_teacher_menuhvr_color).';';
		$expert_teacher_custom_style .=' }';
	}

	$expert_teacher_menuhvrbdr_color = get_theme_mod('expert_teacher_menuhvrbdr_color');
	if ( $expert_teacher_menuhvrbdr_color != '') {
		$expert_teacher_custom_style .=' .nav-menu ul li a:before {';
			$expert_teacher_custom_style .=' background:'.esc_attr($expert_teacher_menuhvrbdr_color).';';
		$expert_teacher_custom_style .=' }';
	}

	$expert_teacher_hdrbtn_color = get_theme_mod('expert_teacher_hdrbtn_color');
	$expert_teacher_hdrbtnbg_color = get_theme_mod('expert_teacher_hdrbtnbg_color');
	if ( $expert_teacher_hdrbtn_color != '') {
		$expert_teacher_custom_style .=' .menu-section a.contact-btn {';
			$expert_teacher_custom_style .=' color:'.esc_attr($expert_teacher_hdrbtn_color).'; background:'.esc_attr($expert_teacher_hdrbtnbg_color).';';
		$expert_teacher_custom_style .=' }';
	}

	//slider color
	$expert_teacher_slider_hide_show = get_theme_mod('expert_teacher_slider_hide_show',false);
	if( $expert_teacher_slider_hide_show == true){
		$expert_teacher_custom_style .=' .page-template-custom-home-page #inner-pages-header {';
			$expert_teacher_custom_style .=' display:none;';
		$expert_teacher_custom_style .=' }';
	} else {
		$expert_teacher_custom_style .=' .page-template-custom-home-page #header, .admin-bar.page-template-custom-home-page #header {';
			$expert_teacher_custom_style .=' position: static; border-bottom: 1px solid #3a8dfa; margin:0;';
		$expert_teacher_custom_style .=' }';
	}

	$expert_teacher_slider_title_fontsize = get_theme_mod('expert_teacher_slider_title_fontsize');
	if( $expert_teacher_slider_title_fontsize != ''){
		$expert_teacher_custom_style .=' #slider h2 {';
			$expert_teacher_custom_style .=' font-size: '.esc_attr($expert_teacher_slider_title_fontsize).'px;';
		$expert_teacher_custom_style .=' }';
	}

	$expert_teacher_slider_text_fontsize = get_theme_mod('expert_teacher_slider_text_fontsize');
	if( $expert_teacher_slider_text_fontsize != ''){
		$expert_teacher_custom_style .=' #slider p {';
			$expert_teacher_custom_style .=' font-size: '.esc_attr($expert_teacher_slider_text_fontsize).'px;';
		$expert_teacher_custom_style .=' }';
	}

	$expert_teacher_slider_opacity = get_theme_mod('expert_teacher_slider_opacity');
	if ( $expert_teacher_slider_opacity != '') {
		$expert_teacher_custom_style .=' #slider .slider-img{';
			$expert_teacher_custom_style .=' opacity:'.esc_attr($expert_teacher_slider_opacity).';';
		$expert_teacher_custom_style .=' }';
	}

	$expert_teacher_slider_img_color = get_theme_mod('expert_teacher_slider_img_color');
	if ( $expert_teacher_slider_img_color != '') {
		$expert_teacher_custom_style .=' #slider .slider-img:after{';
			$expert_teacher_custom_style .=' filter: invert(0.4) sepia(1) hue-rotate('.esc_attr($expert_teacher_slider_img_color).'deg) saturate(1000%) !important;';
		$expert_teacher_custom_style .=' }';
	}

	$expert_teacher_slider_title_color = get_theme_mod('expert_teacher_slider_title_color');
	if ( $expert_teacher_slider_title_color != '') {
		$expert_teacher_custom_style .=' #slider h2 a {';
			$expert_teacher_custom_style .=' color:'.esc_attr($expert_teacher_slider_title_color).';';
		$expert_teacher_custom_style .=' }';
	}

	$expert_teacher_slider_text_color = get_theme_mod('expert_teacher_slider_text_color');
	if ( $expert_teacher_slider_text_color != '') {
		$expert_teacher_custom_style .=' #slider p {';
			$expert_teacher_custom_style .=' color:'.esc_attr($expert_teacher_slider_text_color).';';
		$expert_teacher_custom_style .=' }';
	}

	$expert_teacher_slider_btntext_color = get_theme_mod('expert_teacher_slider_btntext_color');
	if ( $expert_teacher_slider_btntext_color != '') {
		$expert_teacher_custom_style .=' #slider a.read-btn span, .article_content .read-btn a span {';
			$expert_teacher_custom_style .=' color:'.esc_attr($expert_teacher_slider_btntext_color).';';
		$expert_teacher_custom_style .=' }';
	}

	$expert_teacher_slider_btnbg_color = get_theme_mod('expert_teacher_slider_btnbg_color');
	if ( $expert_teacher_slider_btnbg_color != '') {
		$expert_teacher_custom_style .=' #slider a.read-btn, .article_content .read-btn a {';
			$expert_teacher_custom_style .=' background-color:'.esc_attr($expert_teacher_slider_btnbg_color).';';
		$expert_teacher_custom_style .=' }';
	}

	$expert_teacher_slider_btnhvr_color = get_theme_mod('expert_teacher_slider_btnhvr_color');
	if ( $expert_teacher_slider_btnhvr_color != '') {
		$expert_teacher_custom_style .=' #slider a.read-btn:hover span, .article_content .read-btn a:hover span {';
			$expert_teacher_custom_style .=' color:'.esc_attr($expert_teacher_slider_btnhvr_color).';';
		$expert_teacher_custom_style .=' }';
	}

	$expert_teacher_slider_np_color = get_theme_mod('expert_teacher_slider_np_color');
	if ( $expert_teacher_slider_np_color != '') {
		$expert_teacher_custom_style .=' #slider .carousel-control-prev-icon i, #slider .carousel-control-next-icon i {';
			$expert_teacher_custom_style .=' color:'.esc_attr($expert_teacher_slider_np_color).'; border-color:'.esc_attr($expert_teacher_slider_np_color).';';
		$expert_teacher_custom_style .=' }';
	}

	$expert_teacher_slider_exptext_color = get_theme_mod('expert_teacher_slider_exptext_color');
	if ( $expert_teacher_slider_exptext_color != '') {
		$expert_teacher_custom_style .=' #slider .slider-img .experience-text span {';
			$expert_teacher_custom_style .=' color:'.esc_attr($expert_teacher_slider_exptext_color).'; border-color:'.esc_attr($expert_teacher_slider_exptext_color).';';
		$expert_teacher_custom_style .=' }';
	}

	$expert_teacher_slider_exptextbg_color1 = get_theme_mod('expert_teacher_slider_exptextbg_color1');
	$expert_teacher_slider_exptextbg_color2 = get_theme_mod('expert_teacher_slider_exptextbg_color2');
	if ( $expert_teacher_slider_exptextbg_color1 != '') {
		$expert_teacher_custom_style .=' #slider .slider-img .experience-text {';
			$expert_teacher_custom_style .=' background: linear-gradient(93deg, '.esc_attr($expert_teacher_slider_exptextbg_color1).' 0%, '.esc_attr($expert_teacher_slider_exptextbg_color2).' 100%);';
		$expert_teacher_custom_style .=' }';
	}

	//Corces color
	$expert_teacher_section_title_fontsize = get_theme_mod('expert_teacher_section_title_fontsize');
	if( $expert_teacher_section_title_fontsize != ''){
		$expert_teacher_custom_style .=' #courses-section h3 {';
			$expert_teacher_custom_style .=' font-size: '.esc_attr($expert_teacher_section_title_fontsize).'px;';
		$expert_teacher_custom_style .=' }';
	}

	$expert_teacher_section_text_fontsize = get_theme_mod('expert_teacher_section_text_fontsize');
	if( $expert_teacher_section_text_fontsize != ''){
		$expert_teacher_custom_style .=' #courses-section .courses-head p {';
			$expert_teacher_custom_style .=' font-size: '.esc_attr($expert_teacher_section_text_fontsize).'px;';
		$expert_teacher_custom_style .=' }';
	}

	$expert_teacher_courses_color = get_theme_mod('expert_teacher_courses_color');
	if ( $expert_teacher_courses_color != '') {
		$expert_teacher_custom_style .='  #courses-section h3,#courses-section .courses-head p,#courses-section h4,#courses-section .courses-box h5,#courses-section .courses-box p,#courses-section .courses-box h5 a {';
			$expert_teacher_custom_style .=' color:'.esc_attr($expert_teacher_courses_color).';';
		$expert_teacher_custom_style .=' }';
	}

	$expert_teacher_coursesbox_color = get_theme_mod('expert_teacher_coursesbox_color');
	if ( $expert_teacher_coursesbox_color != '') {
		$expert_teacher_custom_style .=' #courses-section .courses-box {';
			$expert_teacher_custom_style .=' background-color:'.esc_attr($expert_teacher_coursesbox_color).';';
		$expert_teacher_custom_style .=' }';
	}

	$expert_teacher_coursesicon_color = get_theme_mod('expert_teacher_coursesicon_color');
	if ( $expert_teacher_coursesicon_color != '') {
		$expert_teacher_custom_style .=' #courses-section .courses-box i {';
			$expert_teacher_custom_style .=' color:'.esc_attr($expert_teacher_coursesicon_color).';';
		$expert_teacher_custom_style .=' }';
	}

	// Footer css
	$expert_teacher_copyright_padding = get_theme_mod('expert_teacher_copyright_padding');
	if( $expert_teacher_copyright_padding != ''){
		$expert_teacher_custom_style .=' .site-info {';
			$expert_teacher_custom_style .=' padding-top: '.esc_attr($expert_teacher_copyright_padding).'px; padding-bottom: '.esc_attr($expert_teacher_copyright_padding).'px;';
		$expert_teacher_custom_style .=' }';
	}

	$expert_teacher_tbarrow_color = get_theme_mod('expert_teacher_tbarrow_color');
	$expert_teacher_tbarrowbg_color = get_theme_mod('expert_teacher_tbarrowbg_color');
	if ( $expert_teacher_tbarrow_color != '') {
		$expert_teacher_custom_style .=' .back-to-top {';
			$expert_teacher_custom_style .=' color:'.esc_attr($expert_teacher_tbarrow_color).'; background-color:'.esc_attr($expert_teacher_tbarrowbg_color).';';
		$expert_teacher_custom_style .=' }';
	}

	$expert_teacher_footer_widget_color = get_theme_mod('expert_teacher_footer_widget_color');
	if ( $expert_teacher_footer_widget_color != '') {
		$expert_teacher_custom_style .=' .site-footer h2.widget-title {';
			$expert_teacher_custom_style .=' color:'.esc_attr($expert_teacher_footer_widget_color).';';
		$expert_teacher_custom_style .=' }';
	}

	$expert_teacher_footer_widget_menu_color = get_theme_mod('expert_teacher_footer_widget_menu_color');
	if ( $expert_teacher_footer_widget_menu_color != '') {
		$expert_teacher_custom_style .=' .widget ul li a, .site-footer .widget-area ul li a, .site-footer .widget-area ul li a {';
			$expert_teacher_custom_style .=' color:'.esc_attr($expert_teacher_footer_widget_menu_color).';';
		$expert_teacher_custom_style .=' }';
	}

	$expert_teacher_copyright_color = get_theme_mod('expert_teacher_copyright_color');
	if ( $expert_teacher_copyright_color != '') {
		$expert_teacher_custom_style .=' .site-info p, .site-info a {';
			$expert_teacher_custom_style .=' color:'.esc_attr($expert_teacher_copyright_color).';';
		$expert_teacher_custom_style .=' }';
	}

	$expert_teacher_copyrightbdr_color = get_theme_mod('expert_teacher_copyrightbdr_color');
	if ( $expert_teacher_copyrightbdr_color != '') {
		$expert_teacher_custom_style .=' .site-info {';
			$expert_teacher_custom_style .=' border-top-color:'.esc_attr($expert_teacher_copyrightbdr_color).';';
		$expert_teacher_custom_style .=' }';
	}

	$expert_teacher_footerbg_color = get_theme_mod('expert_teacher_footerbg_color');
	if ( $expert_teacher_footerbg_color != '') {
		$expert_teacher_custom_style .=' .footer-overlay {';
			$expert_teacher_custom_style .=' background-color:'.esc_attr($expert_teacher_footerbg_color).';';
		$expert_teacher_custom_style .=' }';
	}