<?php
/**
 * Expert Teacher: Customizer
 *
 * @subpackage Expert Teacher
 * @since 1.0
 */

use WPTRT\Customize\Section\Expert_Teacher_Button;

add_action( 'customize_register', function( $manager ) {

	$manager->register_section_type( Expert_Teacher_Button::class );

	$manager->add_section(
		new Expert_Teacher_Button( $manager, 'expert_teacher_pro', [
			'title'      => __( 'Expert Teacher Pro', 'expert-teacher' ),
			'priority'    => 0,
			'button_text' => __( 'Go Pro', 'expert-teacher' ),
			'button_url'  => esc_url( 'https://www.luzuk.com/products/teacher-wordpress-theme/', 'expert-teacher')
		] )
	);

} );

// Load the JS and CSS.
add_action( 'customize_controls_enqueue_scripts', function() {

	$version = wp_get_theme()->get( 'Version' );

	wp_enqueue_script(
		'expert-teacher-customize-section-button',
		get_theme_file_uri( 'vendor/wptrt/customize-section-button/public/js/customize-controls.js' ),
		[ 'customize-controls' ],
		$version,
		true
	);

	wp_enqueue_style(
		'expert-teacher-customize-section-button',
		get_theme_file_uri( 'vendor/wptrt/customize-section-button/public/css/customize-controls.css' ),
		[ 'customize-controls' ],
 		$version
	);

} );

function expert_teacher_customize_register( $wp_customize ) {

	$wp_customize->add_setting('expert_teacher_logo_size',array(
		'sanitize_callback'	=> 'expert_teacher_sanitize_float'
	));
	$wp_customize->add_control('expert_teacher_logo_size',array(
		'type' => 'range',
		'label' => __('Logo Size','expert-teacher'),
		'section' => 'title_tagline'
	));

	$wp_customize->add_setting('expert_teacher_logo_margin',array(
		'sanitize_callback'	=> 'esc_html'
	));
	$wp_customize->add_control('expert_teacher_logo_margin',array(
		'label' => __('Logo Margin','expert-teacher'),
		'section' => 'title_tagline'
	));

	$wp_customize->add_setting('expert_teacher_logo_top_margin',array(
		'default' => '',
		'sanitize_callback'	=> 'expert_teacher_sanitize_float'
	));
	$wp_customize->add_control('expert_teacher_logo_top_margin',array(
		'type' => 'number',
		'description' => __('Top','expert-teacher'),
		'section' => 'title_tagline',
	));

	$wp_customize->add_setting('expert_teacher_logo_bottom_margin',array(
		'default' => '',
		'sanitize_callback'	=> 'expert_teacher_sanitize_float'
	));
	$wp_customize->add_control('expert_teacher_logo_bottom_margin',array(
		'type' => 'number',
		'description' => __('Bottom','expert-teacher'),
		'section' => 'title_tagline',
	));

	$wp_customize->add_setting('expert_teacher_logo_left_margin',array(
		'default' => '',
		'sanitize_callback'	=> 'expert_teacher_sanitize_float'
	));
	$wp_customize->add_control('expert_teacher_logo_left_margin',array(
		'type' => 'number',
		'description' => __('Left','expert-teacher'),
		'section' => 'title_tagline',
	));

	$wp_customize->add_setting('expert_teacher_logo_right_margin',array(
		'default' => '',
		'sanitize_callback'	=> 'expert_teacher_sanitize_float'
 	));
 	$wp_customize->add_control('expert_teacher_logo_right_margin',array(
		'type' => 'number',
		'description' => __('Right','expert-teacher'),
		'section' => 'title_tagline',
    ));

	$wp_customize->add_setting('expert_teacher_show_site_title',array(
		'default' => true,
		'sanitize_callback'	=> 'expert_teacher_sanitize_checkbox'
	));
	$wp_customize->add_control('expert_teacher_show_site_title',array(
		'type' => 'checkbox',
		'label' => __('Show / Hide Site Title','expert-teacher'),
		'section' => 'title_tagline'
	));

	$wp_customize->add_setting('expert_teacher_site_title_fontsize',array(
		'default' => '',
		'sanitize_callback'	=> 'expert_teacher_sanitize_float'
	));
	$wp_customize->add_control('expert_teacher_site_title_fontsize',array(
		'type' => 'number',
		'label' => __('Site Title Font Size','expert-teacher'),
		'section' => 'title_tagline',
	));

	$wp_customize->add_setting( 'expert_teacher_site_title_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	   ));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'expert_teacher_site_title_color', array(
		'label' => 'Title Color',
		'section' => 'title_tagline',
	)));

	$wp_customize->add_setting('expert_teacher_show_tagline',array(
		'default' => true,
		'sanitize_callback'	=> 'expert_teacher_sanitize_checkbox'
	));
	$wp_customize->add_control('expert_teacher_show_tagline',array(
		'type' => 'checkbox',
		'label' => __('Show / Hide Site Tagline','expert-teacher'),
		'section' => 'title_tagline'
	));

	$wp_customize->add_setting( 'expert_teacher_site_tagline_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	   ));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'expert_teacher_site_tagline_color', array(
		'label' => 'Tagline Color',
		'section' => 'title_tagline',
	)));

	$wp_customize->add_panel( 'expert_teacher_panel_id', array(
		'priority' => 10,
		'capability' => 'edit_theme_options',
		'theme_supports' => '',
		'title' => __( 'Theme Settings', 'expert-teacher' ),
		'description' => __( 'Description of what this panel does.', 'expert-teacher' ),
	) );

	$wp_customize->add_section( 'expert_teacher_theme_options_section', array(
    	'title'      => __( 'General Settings', 'expert-teacher' ),
		'priority'   => 30,
		'panel' => 'expert_teacher_panel_id'
	) );

	$wp_customize->add_setting('expert_teacher_theme_options',array(
		'default' => 'Right Sidebar',
		'sanitize_callback' => 'expert_teacher_sanitize_choices'
	));
	$wp_customize->add_control('expert_teacher_theme_options',array(
		'type' => 'select',
		'label' => __('Blog Page Sidebar Layout','expert-teacher'),
		'section' => 'expert_teacher_theme_options_section',
		'choices' => array(
		   'Left Sidebar' => __('Left Sidebar','expert-teacher'),
		   'Right Sidebar' => __('Right Sidebar','expert-teacher'),
		   'One Column' => __('One Column','expert-teacher'),
		   'Grid Layout' => __('Grid Layout','expert-teacher')
		),
	));

	$wp_customize->add_setting('expert_teacher_single_post_sidebar',array(
		'default' => 'Right Sidebar',
		'sanitize_callback' => 'expert_teacher_sanitize_choices'
	));
	$wp_customize->add_control('expert_teacher_single_post_sidebar',array(
        'type' => 'select',
        'label' => __('Single Post Sidebar Layout','expert-teacher'),
        'section' => 'expert_teacher_theme_options_section',
        'choices' => array(
            'Left Sidebar' => __('Left Sidebar','expert-teacher'),
            'Right Sidebar' => __('Right Sidebar','expert-teacher'),
            'One Column' => __('One Column','expert-teacher')
        ),
	));

	$wp_customize->add_setting('expert_teacher_page_sidebar',array(
		'default' => 'One Column',
		'sanitize_callback' => 'expert_teacher_sanitize_choices'
	));
	$wp_customize->add_control('expert_teacher_page_sidebar',array(
        'type' => 'select',
        'label' => __('Page Sidebar Layout','expert-teacher'),
        'section' => 'expert_teacher_theme_options_section',
        'choices' => array(
            'Left Sidebar' => __('Left Sidebar','expert-teacher'),
            'Right Sidebar' => __('Right Sidebar','expert-teacher'),
            'One Column' => __('One Column','expert-teacher')
        ),
	));

	$wp_customize->add_setting('expert_teacher_archive_page_sidebar',array(
		'default' => 'Right Sidebar',
		'sanitize_callback' => 'expert_teacher_sanitize_choices'
	));
	$wp_customize->add_control('expert_teacher_archive_page_sidebar',array(
        'type' => 'select',
        'label' => __('Archive & Search Page Sidebar Layout','expert-teacher'),
        'section' => 'expert_teacher_theme_options_section',
        'choices' => array(
            'Left Sidebar' => __('Left Sidebar','expert-teacher'),
            'Right Sidebar' => __('Right Sidebar','expert-teacher'),
            'One Column' => __('One Column','expert-teacher'),
            'Grid Layout' => __('Grid Layout','expert-teacher')
        ),
	));

	$wp_customize->add_setting( 'expert_teacher_boxfull_width', array(
		'default'           => '',
		'sanitize_callback' => 'expert_teacher_sanitize_choices'
	));
	
	$wp_customize->add_control( 'expert_teacher_boxfull_width', array(
		'label'    => __( 'Section Width', 'expert-teacher' ),
		'section'  => 'expert_teacher_theme_options_section',
		'type'     => 'select',
		'choices'  => array(
			'container'  => __('Box Width', 'expert-teacher'),
			'container-fluid' => __('Full Width', 'expert-teacher'),
			'none' => __('None', 'expert-teacher')
		),
	));

	$wp_customize->add_setting( 'expert_teacher_dropdown_anim', array(
		'default'           => 'None',
		'sanitize_callback' => 'expert_teacher_sanitize_choices'
	));
	$wp_customize->add_control( 'expert_teacher_dropdown_anim', array(
		'label'    => __( 'Menu Dropdown Animations', 'expert-teacher' ),
		'section'  => 'expert_teacher_theme_options_section',
		'type'     => 'select',
		'choices'  => array(
			'bounceInUp'  => __('bounceInUp', 'expert-teacher'),
			'fadeInUp' => __('fadeInUp', 'expert-teacher'),
			'zoomIn'    => __('zoomIn', 'expert-teacher'),
			'None'    => __('None', 'expert-teacher')
		),
	));

	//Header
	$wp_customize->add_section( 'expert_teacher_header_section' , array(
    	'title'    => __( 'Header', 'expert-teacher' ),
		'priority' => null,
		'panel' => 'expert_teacher_panel_id'
	) );

	$wp_customize->add_setting('expert_teacher_contact_btn_text',array(
    	'default' => '',
    	'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('expert_teacher_contact_btn_text',array(
	   	'type' => 'text',
	   	'label' => __('Add Button Text','expert-teacher'),
	   	'section' => 'expert_teacher_header_section',
	));

	$wp_customize->add_setting('expert_teacher_contact_btn_url',array(
    	'default' => '',
    	'sanitize_callback'	=> 'esc_url_raw'
	));
	$wp_customize->add_control('expert_teacher_contact_btn_url',array(
	   	'type' => 'url',
	   	'label' => __('Add Button URL','expert-teacher'),
	   	'section' => 'expert_teacher_header_section',
	));

	$wp_customize->add_setting( 'expert_teacher_menu_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	   ));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'expert_teacher_menu_color', array(
		'label' => 'Menu Color',
		'section' => 'expert_teacher_header_section',
	)));

	$wp_customize->add_setting( 'expert_teacher_menuhvr_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	   ));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'expert_teacher_menuhvr_color', array(
		'label' => 'Menu Hover Color',
		'section' => 'expert_teacher_header_section',
	)));

	$wp_customize->add_setting( 'expert_teacher_menuhvrbdr_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	   ));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'expert_teacher_menuhvrbdr_color', array(
		'label' => 'Menu Hover Border Color',
		'section' => 'expert_teacher_header_section',
	)));

	$wp_customize->add_setting( 'expert_teacher_hdrbtn_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	   ));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'expert_teacher_hdrbtn_color', array(
		'label' => 'Button Text Color',
		'section' => 'expert_teacher_header_section',
	)));

	$wp_customize->add_setting( 'expert_teacher_hdrbtnbg_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	   ));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'expert_teacher_hdrbtnbg_color', array(
		'label' => 'Button Background Color',
		'section' => 'expert_teacher_header_section',
	)));

	//home page slider
	$wp_customize->add_section( 'expert_teacher_slider_section' , array(
    	'title'    => __( 'Slider Settings', 'expert-teacher' ),
		'priority' => null,
		'panel' => 'expert_teacher_panel_id'
	) );

	$wp_customize->add_setting('expert_teacher_slider_hide_show',array(
    	'default' => false,
    	'sanitize_callback'	=> 'expert_teacher_sanitize_checkbox'
	));
	$wp_customize->add_control('expert_teacher_slider_hide_show',array(
	   	'type' => 'checkbox',
	   	'label' => __('Show / Hide Slider','expert-teacher'),
	   	'section' => 'expert_teacher_slider_section',
	));

	$wp_customize->add_setting( 'expert_teacher_slider_effect', array(
		'default'           => '',
		'sanitize_callback' => 'expert_teacher_sanitize_choices'
	));
	$wp_customize->add_control( 'expert_teacher_slider_effect', array(
		'label'    => __( 'Onload Transactions Effects', 'expert-teacher' ),
		'section'  => 'expert_teacher_slider_section',
		'type'     => 'select',
		'choices'  => array(
			'bounceInLeft'  => __('bounceInLeft', 'expert-teacher'),
			'bounceInRight' => __('bounceInRight', 'expert-teacher'),
			'bounceInUp'    => __('bounceInUp', 'expert-teacher'),
			'bounceInDown'    => __('bounceInDown', 'expert-teacher'),
			'zoomIn'  => __('zoomIn', 'expert-teacher'),
			'zoomOut' => __('zoomOut', 'expert-teacher'),
			'fadeInDown'    => __('fadeInDown', 'expert-teacher'),
			'fadeInUp'    => __('fadeInUp', 'expert-teacher'),
			'fadeInLeft'  => __('fadeInLeft', 'expert-teacher'),
			'fadeInRight' => __('fadeInRight', 'expert-teacher'),
			'flip-up'    => __('flip-up', 'expert-teacher'),
			'none'    => __('none', 'expert-teacher')
		),
	));

	for ( $count = 1; $count <= 4; $count++ ) {
		$wp_customize->add_setting( 'expert_teacher_slider' . $count, array(
			'default'           => '',
			'sanitize_callback' => 'expert_teacher_sanitize_dropdown_pages'
		));
		$wp_customize->add_control( 'expert_teacher_slider' . $count, array(
			'label' => __('Select Slider Image Page', 'expert-teacher' ),
			'description'=> __('Image size (450px x 350px)','expert-teacher'),
			'section' => 'expert_teacher_slider_section',
			'type' => 'dropdown-pages'
		));
	}

    $wp_customize->add_setting('expert_teacher_experience_text',array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('expert_teacher_experience_text',array(
		'label'	=> __('Experience Text','expert-teacher'),
		'section' => 'expert_teacher_slider_section',
		'type' => 'text'
	));

	$wp_customize->add_setting('expert_teacher_slider_excerpt_length',array(
		'default' => '15',
		'sanitize_callback'	=> 'expert_teacher_sanitize_float'
	));
	$wp_customize->add_control('expert_teacher_slider_excerpt_length',array(
		'type' => 'number',
		'label' => __('Slider Excerpt Length','expert-teacher'),
		'section' => 'expert_teacher_slider_section',
	));

	$wp_customize->add_setting('expert_teacher_slider_title_fontsize',array(
		'default' => '',
		'sanitize_callback'	=> 'expert_teacher_sanitize_float'
	));
	$wp_customize->add_control('expert_teacher_slider_title_fontsize',array(
		'type' => 'number',
		'label' => __('Title Font Size','expert-teacher'),
		'section' => 'expert_teacher_slider_section',
	));

	$wp_customize->add_setting('expert_teacher_slider_text_fontsize',array(
		'default' => '',
		'sanitize_callback'	=> 'expert_teacher_sanitize_float'
	));
	$wp_customize->add_control('expert_teacher_slider_text_fontsize',array(
		'type' => 'number',
		'label' => __('Text Font Size','expert-teacher'),
		'section' => 'expert_teacher_slider_section',
	));

	$wp_customize->add_setting('expert_teacher_slider_opacity',array(
		'default' => '',
		'sanitize_callback'	=> 'expert_teacher_sanitize_float'
	));
	$wp_customize->add_control('expert_teacher_slider_opacity',array(
		'type' => 'range',
		'label' => __('Image Opacity','expert-teacher'),
		'section' => 'expert_teacher_slider_section',
		'input_attrs' => array(
			'min' => 0,
			'max' => 1,
			'step' => 0.1
		)
	));

	$wp_customize->add_setting('expert_teacher_slider_img_color',array(
		'default' => '',
		'sanitize_callback'	=> 'expert_teacher_sanitize_float'
	));
	$wp_customize->add_control('expert_teacher_slider_img_color',array(
		'type' => 'number',
		'description'=> __('Change color with number(-1 to 1)','expert-teacher'),
		'label' => __('Image Frame Color','expert-teacher'),
		'section' => 'expert_teacher_slider_section',
	));

	$wp_customize->add_setting( 'expert_teacher_slider_title_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'expert_teacher_slider_title_color', array(
		'label' => 'Title Color',
		'section' => 'expert_teacher_slider_section',
	)));

	$wp_customize->add_setting( 'expert_teacher_slider_text_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	   ));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'expert_teacher_slider_text_color', array(
		'label' => 'Text Color',
		'section' => 'expert_teacher_slider_section',
	)));

	$wp_customize->add_setting( 'expert_teacher_slider_btntext_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	   ));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'expert_teacher_slider_btntext_color', array(
		'label' => 'Button Text Color',
		'section' => 'expert_teacher_slider_section',
	)));

	$wp_customize->add_setting( 'expert_teacher_slider_btnbg_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	   ));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'expert_teacher_slider_btnbg_color', array(
		'label' => 'Button Background Color',
		'section' => 'expert_teacher_slider_section',
	)));

	$wp_customize->add_setting( 'expert_teacher_slider_btnhvr_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	   ));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'expert_teacher_slider_btnhvr_color', array(
		'label' => 'Button Hover Text Color',
		'section' => 'expert_teacher_slider_section',
	)));

	$wp_customize->add_setting( 'expert_teacher_slider_exptext_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	   ));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'expert_teacher_slider_exptext_color', array(
		'label' => 'Exprience Text Color',
		'section' => 'expert_teacher_slider_section',
	)));

	$wp_customize->add_setting( 'expert_teacher_slider_exptextbg_color1', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	   ));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'expert_teacher_slider_exptextbg_color1', array(
		'label' => 'Exprience Text Bg Color 1',
		'section' => 'expert_teacher_slider_section',
	)));

	$wp_customize->add_setting( 'expert_teacher_slider_exptextbg_color2', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	   ));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'expert_teacher_slider_exptextbg_color2', array(
		'label' => 'Exprience Text Bg Color 2',
		'section' => 'expert_teacher_slider_section',
	)));

	$wp_customize->add_setting( 'expert_teacher_slider_np_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	   ));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'expert_teacher_slider_np_color', array(
		'label' => 'Pre/Next Arrow Color',
		'section' => 'expert_teacher_slider_section',
	)));

	//Services Section
	$wp_customize->add_section('expert_teacher_courses_section',array(
		'title'	=> __('Courses Section','expert-teacher'),
		'description'=> __('Note : This section will appear below the slider.','expert-teacher'),
		'panel' => 'expert_teacher_panel_id',
	));

    $wp_customize->add_setting('expert_teacher_section_title',array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('expert_teacher_section_title',array(
		'label'	=> __('Section Title','expert-teacher'),
		'section' => 'expert_teacher_courses_section',
		'type' => 'text'
	));

	$wp_customize->add_setting('expert_teacher_section_title_fontsize',array(
		'default' => '',
		'sanitize_callback'	=> 'expert_teacher_sanitize_float'
	));
	$wp_customize->add_control('expert_teacher_section_title_fontsize',array(
		'type' => 'number',
		'label' => __('Font Size','expert-teacher'),
		'section' => 'expert_teacher_courses_section',
	));

    $wp_customize->add_setting('expert_teacher_section_text',array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('expert_teacher_section_text',array(
		'label'	=> __('Section Text','expert-teacher'),
		'section' => 'expert_teacher_courses_section',
		'type' => 'text'
	));

	$wp_customize->add_setting('expert_teacher_section_text_fontsize',array(
		'default' => '',
		'sanitize_callback'	=> 'expert_teacher_sanitize_float'
	));
	$wp_customize->add_control('expert_teacher_section_text_fontsize',array(
		'type' => 'number',
		'label' => __('Font Size','expert-teacher'),
		'section' => 'expert_teacher_courses_section',
	));

	$wp_customize->add_setting('expert_teacher_courses_image',array(
		'default'	=> '',
		'sanitize_callback'	=> 'esc_url_raw',
	));
	$wp_customize->add_control( new WP_Customize_Image_Control($wp_customize,'expert_teacher_courses_image',array(
		'label' => __('Course Image','expert-teacher'),
		'description'=> __('Image size (445px x 460px)','expert-teacher'),
		'section' => 'expert_teacher_courses_section',
	)));

    $wp_customize->add_setting('expert_teacher_subject_title',array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('expert_teacher_subject_title',array(
		'label'	=> __('Subject Title','expert-teacher'),
		'section' => 'expert_teacher_courses_section',
		'type' => 'text'
	));

	$categories = get_categories();
	$cats = array();
	$i = 0;
	$cat_pst[]= 'select';
	foreach($categories as $category){
		if($i==0){
			$default = $category->slug;
			$i++;
		}
		$cat_pst[$category->slug] = $category->name;
	}

	$wp_customize->add_setting('expert_teacher_category_setting',array(
		'default' => 'select',
		'sanitize_callback' => 'expert_teacher_sanitize_choices',
	));
	$wp_customize->add_control('expert_teacher_category_setting',array(
		'type' => 'select',
		'choices' => $cat_pst,
		'label' => __('Select Category To Display Post','expert-teacher'),
		'section' => 'expert_teacher_courses_section',
	));

	$wp_customize->add_setting('expert_teacher_subject_number',array(
		'default'	=> '4',
		'sanitize_callback'	=> 'sanitize_text_field',
	));
	$wp_customize->add_control('expert_teacher_subject_number',array(
		'label'	=> __('Number Of Posts To Show In A Category','expert-teacher'),
		'section' => 'expert_teacher_courses_section',
		'type'	  => 'number'
	));

	$expert_teacher_service_number = get_theme_mod('expert_teacher_service_number', 4);
	for ($i=1; $i <= $expert_teacher_service_number; $i++) { 
	   	$wp_customize->add_setting('expert_teacher_courses_icon' . $i, array(
	      	'default' => 'fas fa-calculator',
	      	'sanitize_callback' => 'sanitize_text_field'
	   	));
	   	$wp_customize->add_control(new Expert_Teacher_Fontawesome_Icon_Chooser($wp_customize, 'expert_teacher_courses_icon' . $i, array(
	      	'section' => 'expert_teacher_courses_section',
	      	'type' => 'icon',
	      	'label' => esc_html__('Course Icon ', 'expert-teacher') . $i
	  	)));
	}

	$wp_customize->add_setting( 'expert_teacher_courses_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	   ));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'expert_teacher_courses_color', array(
		'label' => 'Text Color',
		'section' => 'expert_teacher_courses_section',
	)));

	$wp_customize->add_setting( 'expert_teacher_coursesbox_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	   ));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'expert_teacher_coursesbox_color', array(
		'label' => 'Box Bg Color',
		'section' => 'expert_teacher_courses_section',
	)));

	$wp_customize->add_setting( 'expert_teacher_coursesicon_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	   ));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'expert_teacher_coursesicon_color', array(
		'label' => 'Icon Color',
		'section' => 'expert_teacher_courses_section',
	)));

	//Footer
    $wp_customize->add_section( 'expert_teacher_footer', array(
    	'title'  => __( 'Footer Setting', 'expert-teacher' ),
		'priority' => null,
		'panel' => 'expert_teacher_panel_id'
	) );

	$wp_customize->add_setting('expert_teacher_show_back_totop',array(
       'default' => true,
       'sanitize_callback'	=> 'expert_teacher_sanitize_checkbox'
    ));
    $wp_customize->add_control('expert_teacher_show_back_totop',array(
       'type' => 'checkbox',
       'label' => __('Show / Hide Back to Top','expert-teacher'),
       'section' => 'expert_teacher_footer'
    ));

    $wp_customize->add_setting('expert_teacher_footer_copy',array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('expert_teacher_footer_copy',array(
		'label'	=> __('Copyright Text','expert-teacher'),
		'section' => 'expert_teacher_footer',
		'setting' => 'expert_teacher_footer_copy',
		'type' => 'text'
	));

	$wp_customize->add_setting('expert_teacher_copyright_padding',array(
		'default' => '',
		'sanitize_callback'	=> 'expert_teacher_sanitize_float'
 	));
 	$wp_customize->add_control('expert_teacher_copyright_padding',array(
		'type' => 'number',
		'label' => __('Copyright Top Bottom Padding','expert-teacher'),
		'section' => 'expert_teacher_footer',
	));

	$wp_customize->add_setting( 'expert_teacher_footer_widget_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'expert_teacher_footer_widget_color', array(
		'label' => 'Widgets Title Color',
		'section' => 'expert_teacher_footer',
	)));

	$wp_customize->add_setting( 'expert_teacher_footer_widget_menu_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'expert_teacher_footer_widget_menu_color', array(
		'label' => 'Widgets Menu Color',
		'section' => 'expert_teacher_footer',
	)));

	$wp_customize->add_setting( 'expert_teacher_copyright_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'expert_teacher_copyright_color', array(
		'label' => 'Copyright Text Color',
		'section' => 'expert_teacher_footer',
	)));

	$wp_customize->add_setting( 'expert_teacher_copyrightbdr_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'expert_teacher_copyrightbdr_color', array(
		'label' => 'Copyright Border Color',
		'section' => 'expert_teacher_footer',
	)));

	$wp_customize->add_setting( 'expert_teacher_tbarrow_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'expert_teacher_tbarrow_color', array(
		'label' => 'Back To Top Arrow Color',
		'section' => 'expert_teacher_footer',
	)));

	$wp_customize->add_setting( 'expert_teacher_tbarrowbg_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'expert_teacher_tbarrowbg_color', array(
		'label' => 'Back To Top Arrow Bg Color',
		'section' => 'expert_teacher_footer',
	)));

	$wp_customize->add_setting( 'expert_teacher_footerbg_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'expert_teacher_footerbg_color', array(
		'label' => 'Overlay Color',
		'section' => 'expert_teacher_footer',
	)));

	$wp_customize->get_setting( 'blogname' )->transport          = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport   = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport  = 'postMessage';

	$wp_customize->selective_refresh->add_partial( 'blogname', array(
		'selector' => '.site-title a',
		'render_callback' => 'expert_teacher_customize_partial_blogname',
	) );
	$wp_customize->selective_refresh->add_partial( 'blogdescription', array(
		'selector' => '.site-description',
		'render_callback' => 'expert_teacher_customize_partial_blogdescription',
	) );
}
add_action( 'customize_register', 'expert_teacher_customize_register' );

function expert_teacher_customize_partial_blogname() {
	bloginfo( 'name' );
}

function expert_teacher_customize_partial_blogdescription() {
	bloginfo( 'description' );
}

function expert_teacher_is_static_front_page() {
	return ( is_front_page() && ! is_home() );
}

function expert_teacher_is_view_with_layout_option() {
	// This option is available on all pages. It's also available on archives when there isn't a sidebar.
	return ( is_page() || ( is_archive() && ! is_active_sidebar( 'sidebar-1' ) ) );
}

if (class_exists('WP_Customize_Control')) {

   	class Expert_Teacher_Fontawesome_Icon_Chooser extends WP_Customize_Control {

      	public $type = 'icon';

      	public function render_content() { ?>
	     	<label>
	            <span class="customize-control-title">
	               <?php echo esc_html($this->label); ?>
	            </span>

	            <?php if ($this->description) { ?>
	                <span class="description customize-control-description">
	                   <?php echo wp_kses_post($this->description); ?>
	                </span>
	            <?php } ?>

	            <div class="expert-teacher-selected-icon">
	                <i class="fa <?php echo esc_attr($this->value()); ?>"></i>
	                <span><i class="fa fa-angle-down"></i></span>
	            </div>

	            <ul class="expert-teacher-icon-list clearfix">
	                <?php
	                $expert_teacher_font_awesome_icon_array = expert_teacher_font_awesome_icon_array();
	                foreach ($expert_teacher_font_awesome_icon_array as $expert_teacher_font_awesome_icon) {
	                   $icon_class = $this->value() == $expert_teacher_font_awesome_icon ? 'icon-active' : '';
	                   echo '<li class=' . esc_attr($icon_class) . '><i class="' . esc_attr($expert_teacher_font_awesome_icon) . '"></i></li>';
	                }
	                ?>
	            </ul>
	            <input type="hidden" value="<?php $this->value(); ?>" <?php $this->link(); ?> />
	        </label>
	        <?php
      	}
  	}
}
function expert_teacher_customizer_script() {
   wp_enqueue_style( 'font-awesome-1', esc_url(get_template_directory_uri()).'/assets/css/fontawesome-all.css');
}
add_action( 'customize_controls_enqueue_scripts', 'expert_teacher_customizer_script' );