<?php 
$expert_photographer_slider = get_theme_mod('expert_photographer_slider_setting', true);

if ($expert_photographer_slider == '1') :
?>

<section id="slider">
    <div id="owl-carousel" class="owl-carousel">
        <?php

        $expert_photographer_slide_pages = array();
        for ($expert_photographer_count = 1; $expert_photographer_count <= 3; $expert_photographer_count++) {
            $expert_photographer_mod = intval(get_theme_mod('expert_photographer_slider_page' . $expert_photographer_count));
        
            if ('page-none-selected' !== $expert_photographer_mod && $expert_photographer_mod > 0) {
                $expert_photographer_slide_pages[] = $expert_photographer_mod;
            }
        }

        if (!empty($expert_photographer_slide_pages)) :
            $expert_photographer_args = array(
                'post_type' => 'page',
                'post__in' => $expert_photographer_slide_pages,
                'orderby' => 'post__in'
            );
            $expert_photographer_query = new WP_Query($expert_photographer_args);
            if ($expert_photographer_query->have_posts()) :
                while ($expert_photographer_query->have_posts()) : $expert_photographer_query->the_post(); ?>
                    <div class="item">
                        <?php if (has_post_thumbnail()) { ?>
                            <img src="<?php echo esc_url(get_the_post_thumbnail_url(get_the_ID(), 'full')); ?>" alt="<?php echo esc_attr(get_the_title()); ?>" />
                        <?php } else { ?>
                            <div class="slider-color-box"></div>
                        <?php } ?>

                        <div class="container">
                            <div class="carousel-caption">
                                <div class="inner_carousel">
                                    <h1 class="custom-title mb-2">
                                      <a href="<?php the_permalink(); ?>" class="title-link">
                                        <?php
                                        $expert_photographer_title = get_the_title();

                                        $expert_photographer_words = explode(' ', $expert_photographer_title);
                                        if (count($expert_photographer_words) >= 4) {
                                            $expert_photographer_words[3] = '<span class="highlight">' . $expert_photographer_words[3] . '</span>';
                                        }

                                        echo implode(' ', $expert_photographer_words);
                                        ?>
                                      </a>
                                    </h1>
                                    <p class="mb-2"><?php echo esc_html(wp_trim_words(get_the_content(), 50)); ?></p>
                                    <div class="more-btn mt-4">
                                        <?php if ( get_theme_mod('expert_photographer_slider_btn_text','Get Started') != "" || get_theme_mod('expert_photographer_slider_btn_link') != '') { ?>
                                            <a target="_blank" class="text-capitalize mb-3 slider-btn1" href="<?php echo esc_url(get_theme_mod('expert_photographer_slider_btn_link')!= '') ? esc_url(get_theme_mod('expert_photographer_slider_btn_link')) : esc_url(get_permalink()); ?>">
                                            <?php echo esc_html(get_theme_mod('expert_photographer_slider_btn_text',__('Get Started','expert-photographer'))); ?>
                                          </a>
                                        <?php }?>
                                         <?php if ( get_theme_mod('expert_photographer_slider_video')!= '') { ?>
                                            <a class="slider-video ms-lg-4 ms-3" href="<?php echo esc_url( get_theme_mod('expert_photographer_slider_video') ); ?>" target="_blank"><i class="fas fa-play me-3"></i><?php esc_html_e('Watch Video','expert-photographer'); ?></a>
                                        <?php }?>
                                    </div>
                                    <div class="main-product-section">
                                        <p class="the_timer" data-date="<?php echo esc_attr($expert_photographer_end_date_); ?>"></p>
                                    </div>

                                    <div class="countdowntimer">
                                        <?php
                                        $expert_photographer_dateday = get_theme_mod('expert_photographer_product_clock_timer_end');

                                        if (!empty($expert_photographer_dateday)) : ?>
                                            <p id="timer" class="countdown2 d-flex mb-0">
                                                <input type="hidden" class="date2" value="<?php echo esc_attr($expert_photographer_dateday); ?>">
                                            </p>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endwhile;
                wp_reset_postdata(); ?>
            <?php else : ?>
                <div class="no-postfound"></div>
            <?php endif;
        endif; ?>
    </div>
</section>
<?php endif; ?>
