<?php
/**
 * Customizer: Sanitization Callbacks
 *
 * This file demonstrates how to define sanitization callback functions for various data types.
 * 
 * @package   Expert Photographer
 * @copyright Copyright (c) 2015, WordPress Theme Review Team
 * @license   http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU General Public License, v2 (or newer)
 */

function expert_photographer_sanitize_checkbox( $expert_photographer_checked ) {
	return ( ( isset( $expert_photographer_checked ) && true == $expert_photographer_checked ) ? true : false );
}

/* Sanitization Text*/
function expert_photographer_sanitize_text( $expert_photographer_text ) {
	return wp_filter_post_kses( $expert_photographer_text );
}

function expert_photographer_sanitize_choices( $expert_photographer_input, $expert_photographer_setting ) {
    global $wp_customize; 
    $expert_photographer_control = $wp_customize->get_control( $expert_photographer_setting->id ); 
    if ( array_key_exists( $expert_photographer_input, $expert_photographer_control->choices ) ) {
        return $expert_photographer_input;
    } else {
        return $expert_photographer_setting->default;
    }
}

function expert_photographer_sanitize_select( $expert_photographer_input, $expert_photographer_setting ) {
  $expert_photographer_input = sanitize_key( $expert_photographer_input );
  $choices = $expert_photographer_setting->manager->get_control( $expert_photographer_setting->id )->choices;
  return ( array_key_exists( $expert_photographer_input, $choices ) ? $expert_photographer_input : $expert_photographer_setting->default );
}

function expert_photographer_sanitize_dropdown_pages( $expert_photographer_page_id, $expert_photographer_setting ) {
  // Ensure $expert_photographer_input is an absolute integer.
  $expert_photographer_page_id = absint( $expert_photographer_page_id );
  // If $expert_photographer_page_id is an ID of a published page, return it; otherwise, return the default.
  return ( 'publish' == get_post_status( $expert_photographer_page_id ) ? $expert_photographer_page_id : $expert_photographer_setting->default );
}

function expert_photographer_sanitize_phone_number( $expert_photographer_phone ) {
    return preg_replace( '/[^\d+]/', '', $expert_photographer_phone );
}
// Sanitize the input
function expert_photographer_sanitize_sidebar_position( $expert_photographer_input ) {
    $expert_photographer_valid = array( 'right', 'left' );

    if ( in_array( $expert_photographer_input, $expert_photographer_valid ) ) {
        return $expert_photographer_input;
    } else {
        return 'right';
    }
}

function expert_photographer_sanitize_copyright_position( $expert_photographer_input ) {
    $expert_photographer_valid = array( 'right', 'left', 'center' );

    if ( in_array( $expert_photographer_input, $expert_photographer_valid, true ) ) {
        return $expert_photographer_input;
    } else {
        return 'right';
    }
}