<?php
function expert_photographer_sidebar_setting( $wp_customize ) {
$selective_refresh = isset( $wp_customize->selective_refresh ) ? 'postMessage' : 'refresh';
	$wp_customize->add_panel(
		'expert_photographer_sidebar', array(
			'priority' => 31,
			'title' => esc_html__( 'Sidebar Options', 'expert-photographer' ),
		)
	);

	/*=========================================
	Sidebar Option  Section
	=========================================*/
	$wp_customize->add_section(
		'expert_photographer_sidebar_settings', array(
			'title' => esc_html__( 'Sidebar Options', 'expert-photographer' ),
			'priority' => 1,
			'panel' => 'expert_photographer_general',
		)
	);
	

	// Archive Sidebar Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_photographer_archive_sidebar_setting' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'expert_photographer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'expert_photographer_archive_sidebar_setting', 
		array(
			'label'	      => esc_html__( 'Hide / Show Archive Sidebar', 'expert-photographer' ),
			'section'     => 'expert_photographer_sidebar_settings',
			'settings'    => 'expert_photographer_archive_sidebar_setting',
			'type'        => 'checkbox'
		) 
	);

	// Index Sidebar Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_photographer_index_sidebar_setting' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'expert_photographer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'expert_photographer_index_sidebar_setting', 
		array(
			'label'	      => esc_html__( 'Hide / Show Index Sidebar', 'expert-photographer' ),
			'section'     => 'expert_photographer_sidebar_settings',
			'settings'    => 'expert_photographer_index_sidebar_setting',
			'type'        => 'checkbox'
		) 
	);

	// Pages Sidebar Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_photographer_paged_sidebar_setting' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'expert_photographer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'expert_photographer_paged_sidebar_setting', 
		array(
			'label'	      => esc_html__( 'Hide / Show Pages Sidebar', 'expert-photographer' ),
			'section'     => 'expert_photographer_sidebar_settings',
			'settings'    => 'expert_photographer_paged_sidebar_setting',
			'type'        => 'checkbox'
		) 
	);

	// Search Result Sidebar Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_photographer_search_result_sidebar_setting' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'expert_photographer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'expert_photographer_search_result_sidebar_setting', 
		array(
			'label'	      => esc_html__( 'Hide / Show Search Result Sidebar', 'expert-photographer' ),
			'section'     => 'expert_photographer_sidebar_settings',
			'settings'    => 'expert_photographer_search_result_sidebar_setting',
			'type'        => 'checkbox'
		) 
	);

	// Single Post Sidebar Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_photographer_single_post_sidebar_setting' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'expert_photographer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'expert_photographer_single_post_sidebar_setting', 
		array(
			'label'	      => esc_html__( 'Hide / Show Single Post Sidebar', 'expert-photographer' ),
			'section'     => 'expert_photographer_sidebar_settings',
			'settings'    => 'expert_photographer_single_post_sidebar_setting',
			'type'        => 'checkbox'
		) 
	);

	// Sidebar Page Sidebar Date Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_photographer_single_page_sidebar_setting' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'expert_photographer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'expert_photographer_single_page_sidebar_setting', 
		array(
			'label'	      => esc_html__( 'Hide / Show Page Width Sidebar', 'expert-photographer' ),
			'section'     => 'expert_photographer_sidebar_settings',
			'settings'    => 'expert_photographer_single_page_sidebar_setting',
			'type'        => 'checkbox'
		) 
	);

	$wp_customize->add_setting( 'expert_photographer_sidebar_position', array(
        'default'   => 'right',
        'sanitize_callback' => 'expert_photographer_sanitize_sidebar_position',
    ));

    $wp_customize->add_control( 'expert_photographer_sidebar_position', array(
        'label'    => __( 'Sidebar Position', 'expert-photographer' ),
        'section'  => 'expert_photographer_sidebar_settings',
        'settings' => 'expert_photographer_sidebar_position',
        'type'     => 'radio',
        'choices'  => array(
            'right' => __( 'Right Sidebar', 'expert-photographer' ),
            'left'  => __( 'Left Sidebar', 'expert-photographer' ),
        ),
    ));

	 $wp_customize->add_setting( 'expert_photographer_upgrade_page_settings_15',
        array(
            'sanitize_callback' => 'sanitize_text_field'
        )
    );
    $wp_customize->add_control( new Expert_Photographer_Control_Upgrade(
        $wp_customize, 'expert_photographer_upgrade_page_settings_15',
            array(
                'priority'      => 200,
                'section'       => 'expert_photographer_sidebar_settings',
                'settings'      => 'expert_photographer_upgrade_page_settings_15',
                'label'         => __( 'Expert Photographer Pro comes with additional features.', 'expert-photographer' ),
                'choices'       => array( __( '15+ Ready-Made Sections', 'expert-photographer' ), __( 'One-Click Demo Import', 'expert-photographer' ), __( 'WooCommerce Integrated', 'expert-photographer' ), __( 'Drag & Drop Section Reordering', 'expert-photographer' ),__( 'Advanced Typography Control', 'expert-photographer' ),__( 'Intuitive Customization Options', 'expert-photographer' ),__( '24/7 Support', 'expert-photographer' ), )
            )
        )
    ); 
}

add_action( 'customize_register', 'expert_photographer_sidebar_setting' );