<?php
function expert_photographer_post_setting( $wp_customize ) {
$selective_refresh = isset( $wp_customize->selective_refresh ) ? 'postMessage' : 'refresh';
	$wp_customize->add_panel(
		'expert_photographer_post', array(
			'priority' => 31,
			'title' => esc_html__( 'Post Options', 'expert-photographer' ),
		)
	);

	/*=========================================
	Archive Post  Section
	=========================================*/
	$wp_customize->add_section(
		'expert_photographer_archive_post_setting', array(
			'title' => esc_html__( 'Archive Post', 'expert-photographer' ),
			'priority' => 1,
			'panel' => 'expert_photographer_post',
		)
	);

	// Layouts Post
	$wp_customize->add_setting('expert_photographer_blog_layout_option_setting',array(
	  'default' => 'Default',
	  'sanitize_callback' => 'expert_photographer_sanitize_choices'
	));
	$wp_customize->add_control(new Expert_Photographer_Image_Radio_Control($wp_customize, 'expert_photographer_blog_layout_option_setting', array(
	  'type' => 'select',
	  'label' => __('Blog Post Layouts','expert-photographer'),
	  'section' => 'expert_photographer_archive_post_setting',
	  'choices' => array(
		'Default' => esc_url(get_template_directory_uri()).'/assets/images/layout-1.png',
		'Left' => esc_url(get_template_directory_uri()).'/assets/images/layout-2.png',
		'Right' => esc_url(get_template_directory_uri()).'/assets/images/layout-3.png',
	))));
		
	// Post Heading Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_photographer_post_heading_settings' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'expert_photographer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
		'expert_photographer_post_heading_settings', 
		array(
			'label'	      => esc_html__( 'Hide / Show Post Heading', 'expert-photographer' ),
			'section'     => 'expert_photographer_archive_post_setting',
			'settings'    => 'expert_photographer_post_heading_settings',
			'type'        => 'checkbox'
		) 
	);

	// Post Content Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_photographer_post_content_settings' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'expert_photographer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'expert_photographer_post_content_settings', 
		array(
			'label'	      => esc_html__( 'Hide / Show Post Content', 'expert-photographer' ),
			'section'     => 'expert_photographer_archive_post_setting',
			'settings'    => 'expert_photographer_post_content_settings',
			'type'        => 'checkbox'
		) 
	);

	// Post Featured Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_photographer_post_featured_image_settings' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'expert_photographer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'expert_photographer_post_featured_image_settings', 
		array(
			'label'	      => esc_html__( 'Hide / Show Post Feature Image', 'expert-photographer' ),
			'section'     => 'expert_photographer_archive_post_setting',
			'settings'    => 'expert_photographer_post_featured_image_settings',
			'type'        => 'checkbox'
		) 
	);

	// Post Date Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_photographer_post_date_settings' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'expert_photographer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'expert_photographer_post_date_settings', 
		array(
			'label'	      => esc_html__( 'Hide / Show Post Date', 'expert-photographer' ),
			'section'     => 'expert_photographer_archive_post_setting',
			'settings'    => 'expert_photographer_post_date_settings',
			'type'        => 'checkbox'
		) 
	);

	// Post Date Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_photographer_post_comments_settings' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'expert_photographer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'expert_photographer_post_comments_settings', 
		array(
			'label'	      => esc_html__( 'Hide / Show Post Comment', 'expert-photographer' ),
			'section'     => 'expert_photographer_archive_post_setting',
			'settings'    => 'expert_photographer_post_comments_settings',
			'type'        => 'checkbox'
		) 
	);

	// Post Date Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_photographer_post_author_settings' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'expert_photographer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'expert_photographer_post_author_settings', 
		array(
			'label'	      => esc_html__( 'Hide / Show Post Author', 'expert-photographer' ),
			'section'     => 'expert_photographer_archive_post_setting',
			'settings'    => 'expert_photographer_post_author_settings',
			'type'        => 'checkbox'
		) 
	);

	// Post Timing Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_photographer_post_timing_settings' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'expert_photographer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'expert_photographer_post_timing_settings', 
		array(
			'label'	      => esc_html__( 'Hide / Show Post Timings', 'expert-photographer' ),
			'section'     => 'expert_photographer_archive_post_setting',
			'settings'    => 'expert_photographer_post_timing_settings',
			'type'        => 'checkbox'
		) 
	);

	// Post Tags Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_photographer_post_tags_settings' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'expert_photographer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'expert_photographer_post_tags_settings', 
		array(
			'label'	      => esc_html__( 'Hide / Show Post Tags', 'expert-photographer' ),
			'section'     => 'expert_photographer_archive_post_setting',
			'settings'    => 'expert_photographer_post_tags_settings',
			'type'        => 'checkbox'
		) 
	);

	$wp_customize->add_setting('expert_photographer_excerpt_limit', array(
        'default'           => 50,
        'sanitize_callback' => 'absint',
    ));

    $wp_customize->add_control('expert_photographer_excerpt_limit', array(
        'label'   => __('Excerpt Word Limit', 'expert-photographer'),
        'section' => 'expert_photographer_archive_post_setting',
        'type'    => 'number',
    ));

	$wp_customize->add_setting( 'expert_photographer_upgrade_page_settings_133',
	array(
		'sanitize_callback' => 'sanitize_text_field'
		)
	);
	$wp_customize->add_control( new Expert_Photographer_Control_Upgrade(
		$wp_customize, 'expert_photographer_upgrade_page_settings_133',
			array(
				'priority'      => 200,
				'section'       => 'expert_photographer_archive_post_setting',
				'settings'      => 'expert_photographer_upgrade_page_settings_133',
				'label'         => __( 'Expert Photographer Pro comes with additional features.', 'expert-photographer' ),
				'choices'       => array( __( '15+ Ready-Made Sections', 'expert-photographer' ), __( 'One-Click Demo Import', 'expert-photographer' ), __( 'WooCommerce Integrated', 'expert-photographer' ), __( 'Drag & Drop Section Reordering', 'expert-photographer' ),__( 'Advanced Typography Control', 'expert-photographer' ),__( 'Intuitive Customization Options', 'expert-photographer' ),__( '24/7 Support', 'expert-photographer' ), )
			)
		)
	); 

	/*=========================================
	Single Post  Section
	=========================================*/
	$wp_customize->add_section(
		'expert_photographer_single_post', array(
			'title' => esc_html__( 'Single Post', 'expert-photographer' ),
			'priority' => 3,
			'panel' => 'expert_photographer_post',
		)
	);
	
	// Post Heading Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_photographer_single_post_heading_settings' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'expert_photographer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'expert_photographer_single_post_heading_settings', 
		array(
			'label'	      => esc_html__( 'Hide / Show Post Heading', 'expert-photographer' ),
			'section'     => 'expert_photographer_single_post',
			'settings'    => 'expert_photographer_single_post_heading_settings',
			'type'        => 'checkbox'
		) 
	);

	// Post Content Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_photographer_single_post_content_settings' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'expert_photographer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'expert_photographer_single_post_content_settings', 
		array(
			'label'	      => esc_html__( 'Hide / Show Post Content', 'expert-photographer' ),
			'section'     => 'expert_photographer_single_post',
			'settings'    => 'expert_photographer_single_post_content_settings',
			'type'        => 'checkbox'
		) 
	);

	// Post Featured Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_photographer_single_post_featured_image_settings' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'expert_photographer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'expert_photographer_single_post_featured_image_settings', 
		array(
			'label'	      => esc_html__( 'Hide / Show Post Feature Image', 'expert-photographer' ),
			'section'     => 'expert_photographer_single_post',
			'settings'    => 'expert_photographer_single_post_featured_image_settings',
			'type'        => 'checkbox'
		) 
	);

	// Post Date Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_photographer_single_post_date_settings' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'expert_photographer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'expert_photographer_single_post_date_settings', 
		array(
			'label'	      => esc_html__( 'Hide / Show Post Date', 'expert-photographer' ),
			'section'     => 'expert_photographer_single_post',
			'settings'    => 'expert_photographer_single_post_date_settings',
			'type'        => 'checkbox'
		) 
	);

	// Post Date Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_photographer_single_post_comments_settings' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'expert_photographer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'expert_photographer_single_post_comments_settings', 
		array(
			'label'	      => esc_html__( 'Hide / Show Post Comment', 'expert-photographer' ),
			'section'     => 'expert_photographer_single_post',
			'settings'    => 'expert_photographer_single_post_comments_settings',
			'type'        => 'checkbox'
		) 
	);

	// Post Date Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_photographer_single_post_author_settings' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'expert_photographer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'expert_photographer_single_post_author_settings', 
		array(
			'label'	      => esc_html__( 'Hide / Show Post Author', 'expert-photographer' ),
			'section'     => 'expert_photographer_single_post',
			'settings'    => 'expert_photographer_single_post_author_settings',
			'type'        => 'checkbox'
		) 
	);

	// Post Date Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_photographer_single_post_timing_settings' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'expert_photographer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'expert_photographer_single_post_timing_settings', 
		array(
			'label'	      => esc_html__( 'Hide / Show Post Timings', 'expert-photographer' ),
			'section'     => 'expert_photographer_single_post',
			'settings'    => 'expert_photographer_single_post_timing_settings',
			'type'        => 'checkbox'
		) 
	);

	// Post Tags Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_photographer_single_post_tags_settings' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'expert_photographer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'expert_photographer_single_post_tags_settings', 
		array(
			'label'	      => esc_html__( 'Hide / Show Post Tags', 'expert-photographer' ),
			'section'     => 'expert_photographer_single_post',
			'settings'    => 'expert_photographer_single_post_tags_settings',
			'type'        => 'checkbox'
		) 
	);

	// Related Posts Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_photographer_show_hide_related_post' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'expert_photographer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'expert_photographer_show_hide_related_post', 
		array(
			'label'	      => esc_html__( 'Hide / Show Related Posts', 'expert-photographer' ),
			'section'     => 'expert_photographer_single_post',
			'settings'    => 'expert_photographer_show_hide_related_post',
			'type'        => 'checkbox'
		) 
	);

	$wp_customize->add_setting( 
    	'expert_photographer_related_posts_heading',
    	array(
			'default' => 'Related Posts',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'sanitize_text_field',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'expert_photographer_related_posts_heading',
		array(
		    'label'   		=> __('Related Post Heading','expert-photographer'),
		    'section'		=> 'expert_photographer_single_post',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)
	);

	$wp_customize->add_setting('expert_photographer_related_post_counts', array(
        'default'           => 3,
        'sanitize_callback' => 'absint',
    ));

    $wp_customize->add_control('expert_photographer_related_post_counts', array(
        'label'   => __('Number Of Related Posts To Show', 'expert-photographer'),
        'section' => 'expert_photographer_single_post',
        'type'    => 'number',
    ));

	$wp_customize->add_setting( 'expert_photographer_upgrade_page_settings_58',
	array(
		'sanitize_callback' => 'sanitize_text_field'
	)
	);
	$wp_customize->add_control( new Expert_Photographer_Control_Upgrade(
		$wp_customize, 'expert_photographer_upgrade_page_settings_58',
			array(
				'priority'      => 200,
				'section'       => 'expert_photographer_single_post',
				'settings'      => 'expert_photographer_upgrade_page_settings_58',
				'label'         => __( 'Expert Photographer Pro comes with additional features.', 'expert-photographer' ),
				'choices'       => array( __( '15+ Ready-Made Sections', 'expert-photographer' ), __( 'One-Click Demo Import', 'expert-photographer' ), __( 'WooCommerce Integrated', 'expert-photographer' ), __( 'Drag & Drop Section Reordering', 'expert-photographer' ),__( 'Advanced Typography Control', 'expert-photographer' ),__( 'Intuitive Customization Options', 'expert-photographer' ),__( '24/7 Support', 'expert-photographer' ), )
			)
		)
	); 
}

add_action( 'customize_register', 'expert_photographer_post_setting' );