<?php
function expert_photographer_general_setting( $wp_customize ) {
$selective_refresh = isset( $wp_customize->selective_refresh ) ? 'postMessage' : 'refresh';
	$wp_customize->add_panel(
		'expert_photographer_general', array(
			'priority' => 2,
			'title' => esc_html__( 'General Options', 'expert-photographer' ),
		)
	);

	/*=========================================
	Breadcrumb  Section
	=========================================*/
	$wp_customize->add_section(
		'expert_photographer_breadcrumb_setting', array(
			'title' => esc_html__( 'Breadcrumb Options', 'expert-photographer' ),
			'priority' => 1,
			'panel' => 'expert_photographer_general',
		)
	);
	
	// Settings 
	$wp_customize->add_setting(
		'expert_photographer_breadcrumb_settings'
			,array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'expert_photographer_sanitize_text',
			'priority' => 1,
		)
	);

	$wp_customize->add_control(
	'expert_photographer_breadcrumb_settings',
		array(
			'type' => 'hidden',
			'label' => __('Settings','expert-photographer'),
			'section' => 'expert_photographer_breadcrumb_setting',
		)
	);
	
	// Breadcrumb Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_photographer_hs_breadcrumb' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'expert_photographer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'expert_photographer_hs_breadcrumb', 
		array(
			'label'	      => esc_html__( 'Hide / Show Section', 'expert-photographer' ),
			'section'     => 'expert_photographer_breadcrumb_setting',
			'settings'    => 'expert_photographer_hs_breadcrumb',
			'type'        => 'checkbox'
		) 
	);

		$wp_customize->add_setting(
    	'expert_photographer_breadcrumb_seprator',
    	array(
			'default' => '/',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
		'expert_photographer_breadcrumb_seprator',
		array(
		    'label'   		=> __('Breadcrumb separator','expert-photographer'),
		    'section'		=> 'expert_photographer_breadcrumb_setting',
			'type' 			=> 'text',
		)  
	);

	$wp_customize->add_setting( 'expert_photographer_upgrade_page_settings_5',
        array(
            'sanitize_callback' => 'sanitize_text_field'
        )
    );
    $wp_customize->add_control( new Expert_Photographer_Control_Upgrade(
        $wp_customize, 'expert_photographer_upgrade_page_settings_5',
            array(
                'priority'      => 200,
                'section'       => 'expert_photographer_breadcrumb_setting',
                'settings'      => 'expert_photographer_upgrade_page_settings_5',
                'label'         => __( 'Expert Photographer Pro comes with additional features.', 'expert-photographer' ),
                'choices'       => array( __( '15+ Ready-Made Sections', 'expert-photographer' ), __( 'One-Click Demo Import', 'expert-photographer' ), __( 'WooCommerce Integrated', 'expert-photographer' ), __( 'Drag & Drop Section Reordering', 'expert-photographer' ),__( 'Advanced Typography Control', 'expert-photographer' ),__( 'Intuitive Customization Options', 'expert-photographer' ),__( '24/7 Support', 'expert-photographer' ), )
            )
        )
    ); 

	/*=========================================
	Preloader Section
	=========================================*/
	$wp_customize->add_section(
		'expert_photographer_preloader_section_setting', array(
			'title' => esc_html__( 'Preloader Options', 'expert-photographer' ),
			'priority' => 3,
			'panel' => 'expert_photographer_general',
		)
	);

	// Preloader Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_photographer_preloader_setting' , 
			array(
			'sanitize_callback' => 'expert_photographer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
		) 
	);
	
	$wp_customize->add_control(
	'expert_photographer_preloader_setting', 
		array(
			'label'	      => esc_html__( 'Hide / Show Preloader', 'expert-photographer' ),
			'section'     => 'expert_photographer_preloader_section_setting',
			'settings'    => 'expert_photographer_preloader_setting',
			'type'        => 'checkbox'
		) 
	);

	
	$wp_customize->add_setting(
    	'expert_photographer_preloader_text',
    	array(
			'default' => 'Loading',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
		'expert_photographer_preloader_text',
		array(
		    'label'   		=> __('Preloader Text','expert-photographer'),
		    'section'		=> 'expert_photographer_preloader_section_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)
	);

	// Preloader Background Color Setting
    $wp_customize->add_setting(
        'expert_photographer_preloader_bg_color',
        array(
            'default' => '#ffffff',
            'sanitize_callback' => 'sanitize_hex_color',
            'capability' => 'edit_theme_options',
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'expert_photographer_preloader_bg_color',
            array(
                'label' => esc_html__('Preloader Background Color', 'expert-photographer'),
                'section' => 'expert_photographer_preloader_section_setting', // Adjust section if needed
                'settings' => 'expert_photographer_preloader_bg_color',
            )
        )
    );

    // Preloader Color Setting
    $wp_customize->add_setting(
        'expert_photographer_preloader_color',
        array(
            'default' => '#5a50e7',
            'sanitize_callback' => 'sanitize_hex_color',
            'capability' => 'edit_theme_options',
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'expert_photographer_preloader_color',
            array(
                'label' => esc_html__('Preloader Color', 'expert-photographer'),
                'section' => 'expert_photographer_preloader_section_setting', // Adjust section if needed
                'settings' => 'expert_photographer_preloader_color',
            )
        )
    );

	$wp_customize->add_setting( 'expert_photographer_upgrade_page_settings_6',
        array(
            'sanitize_callback' => 'sanitize_text_field'
        )
    );
    $wp_customize->add_control( new Expert_Photographer_Control_Upgrade(
        $wp_customize, 'expert_photographer_upgrade_page_settings_6',
            array(
                'priority'      => 200,
                'section'       => 'expert_photographer_preloader_section_setting',
                'settings'      => 'expert_photographer_upgrade_page_settings_6',
                'label'         => __( 'Expert Photographer Pro comes with additional features.', 'expert-photographer' ),
                'choices'       => array( __( '15+ Ready-Made Sections', 'expert-photographer' ), __( 'One-Click Demo Import', 'expert-photographer' ), __( 'WooCommerce Integrated', 'expert-photographer' ), __( 'Drag & Drop Section Reordering', 'expert-photographer' ),__( 'Advanced Typography Control', 'expert-photographer' ),__( 'Intuitive Customization Options', 'expert-photographer' ),__( '24/7 Support', 'expert-photographer' ), )
            )
        )
    ); 


	/*=========================================
	Scroll To Top Section
	=========================================*/
	$wp_customize->add_section(
		'expert_photographer_scroll_to_top_section_setting', array(
			'title' => esc_html__( 'Scroll To Top Options', 'expert-photographer' ),
			'priority' => 3,
			'panel' => 'expert_photographer_footer_section',
		)
	);

	// Scroll To Top Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_photographer_scroll_top_setting' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'expert_photographer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
		) 
	);
	
	$wp_customize->add_control(
	'expert_photographer_scroll_top_setting', 
		array(
			'label'	      => esc_html__( 'Hide / Show Scroll To Top', 'expert-photographer' ),
			'section'     => 'expert_photographer_scroll_to_top_section_setting',
			'settings'    => 'expert_photographer_scroll_top_setting',
			'type'        => 'checkbox'
		) 
	);

	// Scroll To Top Color Setting
	$wp_customize->add_setting(
		'expert_photographer_scroll_top_color',
		array(
			'default'           => '#fff',
			'sanitize_callback' => 'sanitize_hex_color',
			'capability'        => 'edit_theme_options',
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'expert_photographer_scroll_top_color',
			array(
				'label'    => esc_html__( 'Scroll To Top Color', 'expert-photographer' ),
				'section'  => 'expert_photographer_scroll_to_top_section_setting',
				'settings' => 'expert_photographer_scroll_top_color',
			)
		)
	);

	// Scroll To Top Background Color Setting
	$wp_customize->add_setting(
		'expert_photographer_scroll_top_bg_color',
		array(
			'default'           => '#5a50e7',
			'sanitize_callback' => 'sanitize_hex_color',
			'capability'        => 'edit_theme_options',
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'expert_photographer_scroll_top_bg_color',
			array(
				'label'    => esc_html__( 'Scroll To Top Background Color', 'expert-photographer' ),
				'section'  => 'expert_photographer_scroll_to_top_section_setting',
				'settings' => 'expert_photographer_scroll_top_bg_color',
			)
		)
	);

	$wp_customize->add_setting( 'expert_photographer_upgrade_page_settings_7',
        array(
            'sanitize_callback' => 'sanitize_text_field'
        )
    );
    $wp_customize->add_control( new Expert_Photographer_Control_Upgrade(
        $wp_customize, 'expert_photographer_upgrade_page_settings_7',
            array(
                'priority'      => 200,
                'section'       => 'expert_photographer_scroll_to_top_section_setting',
                'settings'      => 'expert_photographer_upgrade_page_settings_7',
                'label'         => __( 'Expert Photographer Pro comes with additional features.', 'expert-photographer' ),
                'choices'       => array( __( '15+ Ready-Made Sections', 'expert-photographer' ), __( 'One-Click Demo Import', 'expert-photographer' ), __( 'WooCommerce Integrated', 'expert-photographer' ), __( 'Drag & Drop Section Reordering', 'expert-photographer' ),__( 'Advanced Typography Control', 'expert-photographer' ),__( 'Intuitive Customization Options', 'expert-photographer' ),__( '24/7 Support', 'expert-photographer' ), )
            )
        )
    ); 

	/*=========================================
	Woocommerce Section
	=========================================*/
	$wp_customize->add_section(
		'expert_photographer_woocommerce_section_setting', array(
			'title' => esc_html__( 'Woocommerce Settings', 'expert-photographer' ),
			'priority' => 3,
			'panel' => 'woocommerce',
		)
	);

	$wp_customize->add_setting(
    	'expert_photographer_custom_shop_per_columns',
    	array(
			'default' => '3',
			'sanitize_callback' => 'absint',
		)
	);	
	$wp_customize->add_control( 
		'expert_photographer_custom_shop_per_columns',
		array(
		    'label'   		=> __('Product Per Columns','expert-photographer'),
		    'section'		=> 'expert_photographer_woocommerce_section_setting',
			'type' 			=> 'number',
			'transport'         => $selective_refresh,
		)  
	);

	$wp_customize->add_setting(
    	'expert_photographer_custom_shop_product_per_page',
    	array(
			'default' => '9',
			'sanitize_callback' => 'absint',
		)
	);	
	$wp_customize->add_control( 
		'expert_photographer_custom_shop_product_per_page',
		array(
		    'label'   		=> __('Product Per Page','expert-photographer'),
		    'section'		=> 'expert_photographer_woocommerce_section_setting',
			'type' 			=> 'number',
			'transport'         => $selective_refresh,
		)  
	);

	// Woocommerce Sidebar Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_photographer_wocommerce_sidebar_setting' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'expert_photographer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
		) 
	);
	
	$wp_customize->add_control(
	'expert_photographer_wocommerce_sidebar_setting', 
		array(
			'label'	      => esc_html__( 'Hide / Show Woocommerce Sidebar', 'expert-photographer' ),
			'section'     => 'expert_photographer_woocommerce_section_setting',
			'settings'    => 'expert_photographer_wocommerce_sidebar_setting',
			'type'        => 'checkbox'
		)
	);

	$wp_customize->add_setting( 'expert_photographer_upgrade_page_settings_8',
        array(
            'sanitize_callback' => 'sanitize_text_field'
        )
    );
    $wp_customize->add_control( new Expert_Photographer_Control_Upgrade(
        $wp_customize, 'expert_photographer_upgrade_page_settings_8',
            array(
                'priority'      => 200,
                'section'       => 'expert_photographer_woocommerce_section_setting',
                'settings'      => 'expert_photographer_upgrade_page_settings_8',
                'label'         => __( 'Expert Photographer Pro comes with additional features.', 'expert-photographer' ),
                'choices'       => array( __( '15+ Ready-Made Sections', 'expert-photographer' ), __( 'One-Click Demo Import', 'expert-photographer' ), __( 'WooCommerce Integrated', 'expert-photographer' ), __( 'Drag & Drop Section Reordering', 'expert-photographer' ),__( 'Advanced Typography Control', 'expert-photographer' ),__( 'Intuitive Customization Options', 'expert-photographer' ),__( '24/7 Support', 'expert-photographer' ), )
            )
        )
    ); 
	
	/*=========================================
	404 Section
	=========================================*/
	$wp_customize->add_section(
		'expert_photographer_404_section', array(
			'title' => esc_html__( '404 Page Options', 'expert-photographer' ),
			'priority' => 1,
			'panel' => 'expert_photographer_general',
		)
	);

	$wp_customize->add_setting(
    	'expert_photographer_404_title',
    	array(
			'default' => '404',
			'sanitize_callback' => 'sanitize_text_field',
			'priority' => 2,
		)
	);	
	$wp_customize->add_control( 
		'expert_photographer_404_title',
		array(
		    'label'   		=> __('404 Heading','expert-photographer'),
		    'section'		=> 'expert_photographer_404_section',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);

	$wp_customize->add_setting(
    	'expert_photographer_404_Text',
    	array(
			'default' => 'Page Not Found',
			'sanitize_callback' => 'sanitize_text_field',
			'priority' => 2,
		)
	);	
	$wp_customize->add_control( 
		'expert_photographer_404_Text',
		array(
		    'label'   		=> __('404 Title','expert-photographer'),
		    'section'		=> 'expert_photographer_404_section',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);

	$wp_customize->add_setting(
    	'expert_photographer_404_content',
    	array(
			'default' => 'The page you were looking for could not be found.',
			'sanitize_callback' => 'sanitize_text_field',
			'priority' => 2,
		)
	);	
	$wp_customize->add_control( 
		'expert_photographer_404_content',
		array(
		    'label'   		=> __('404 Content','expert-photographer'),
		    'section'		=> 'expert_photographer_404_section',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);

	 $wp_customize->add_setting( 'expert_photographer_upgrade_page_settings_10',
        array(
            'sanitize_callback' => 'sanitize_text_field'
        )
    );
    $wp_customize->add_control( new Expert_Photographer_Control_Upgrade(
        $wp_customize, 'expert_photographer_upgrade_page_settings_10',
            array(
                'priority'      => 200,
                'section'       => 'expert_photographer_404_section',
                'settings'      => 'expert_photographer_upgrade_page_settings_10',
                'label'         => __( 'Expert Photographer Pro comes with additional features.', 'expert-photographer' ),
                'choices'       => array( __( '15+ Ready-Made Sections', 'expert-photographer' ), __( 'One-Click Demo Import', 'expert-photographer' ), __( 'WooCommerce Integrated', 'expert-photographer' ), __( 'Drag & Drop Section Reordering', 'expert-photographer' ),__( 'Advanced Typography Control', 'expert-photographer' ),__( 'Intuitive Customization Options', 'expert-photographer' ),__( '24/7 Support', 'expert-photographer' ), )
            )
        )
    ); 

}

add_action( 'customize_register', 'expert_photographer_general_setting' );