<?php

function expert_photographer_footer( $wp_customize ) {
	$selective_refresh = isset( $wp_customize->selective_refresh ) ? 'postMessage' : 'refresh';
	// Footer Panel // 
	$wp_customize->add_panel( 
		'expert_photographer_footer_section', 
		array(
			'priority'      => 34,
			'capability'    => 'edit_theme_options',
			'title'			=> __('Footer Options', 'expert-photographer'),
		) 
	);

	// Footer Widgets // 
	$wp_customize->add_section(
        'expert_photographer_footer_top',
        array(
            'title' 		=> __('Footer Widgets','expert-photographer'),
			'panel'  		=> 'expert_photographer_footer_section',
			'priority'      => 3,
		)
    );

    // Footer Widgets Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_photographer_footer_widgets_setting' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'expert_photographer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
		) 
	);
	
	$wp_customize->add_control(
	'expert_photographer_footer_widgets_setting', 
		array(
			'label'	      => esc_html__( 'Hide / Show Footer Widgets', 'expert-photographer' ),
			'section'     => 'expert_photographer_footer_top',
			'settings'    => 'expert_photographer_footer_widgets_setting',
			'type'        => 'checkbox'
		) 
	);

	// Footer Background Image Setting
	$wp_customize->add_setting('expert_photographer_footer_bg_image',array(
		'default'	=> '',
		'sanitize_callback'	=> 'esc_url_raw',
	));
	$wp_customize->add_control( new WP_Customize_Image_Control($wp_customize,'expert_photographer_footer_bg_image',array(
	'label' => __('Footer Background Image','expert-photographer'),
	'section' => 'expert_photographer_footer_top'
	)));

	// Footer Background Image Opacity
	$wp_customize->add_setting('expert_photographer_footer_bg_image_opacity', array(
		'default'           => 50,
		'sanitize_callback' => 'absint',
		'capability'        => 'edit_theme_options',
	));

	$wp_customize->add_control('expert_photographer_footer_bg_image_opacity', array(
		'label'    => __('Footer Background Image Opacity (%)', 'expert-photographer'),
		'section'  => 'expert_photographer_footer_top',
		'type'     => 'range',
		'input_attrs' => array(
			'min'  => 0,
			'max'  => 100,
			'step' => 1,
		),
	));

	// Footer Background Color Setting
    $wp_customize->add_setting('expert_photographer_footer_bg_color',array(
		'default' => '#000000',
		'sanitize_callback' => 'sanitize_hex_color',
		'capability' => 'edit_theme_options',
	));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize,'expert_photographer_footer_bg_color',array(
		'label' => esc_html__('Footer Background Color', 'expert-photographer'),
		'section' => 'expert_photographer_footer_top', // Adjust section if needed
		'settings' => 'expert_photographer_footer_bg_color',
	)));

	$wp_customize->add_setting( 'expert_photographer_upgrade_page_settings_1',
        array(
            'sanitize_callback' => 'sanitize_text_field'
        )
    );
    $wp_customize->add_control( new Expert_Photographer_Control_Upgrade(
        $wp_customize, 'expert_photographer_upgrade_page_settings_1',
            array(
                'priority'      => 200,
                'section'       => 'expert_photographer_footer_top',
                'settings'      => 'expert_photographer_upgrade_page_settings_1',
                'label'         => __( 'Expert Photographer Pro comes with additional features.', 'expert-photographer' ),
                'choices'       => array( __( '15+ Ready-Made Sections', 'expert-photographer' ), __( 'One-Click Demo Import', 'expert-photographer' ), __( 'WooCommerce Integrated', 'expert-photographer' ), __( 'Drag & Drop Section Reordering', 'expert-photographer' ),__( 'Advanced Typography Control', 'expert-photographer' ),__( 'Intuitive Customization Options', 'expert-photographer' ),__( '24/7 Support', 'expert-photographer' ), )
            )
        )
    ); 

	// Footer Bottom // 
	$wp_customize->add_section(
        'expert_photographer_footer_bottom',
        array(
            'title' 		=> __('Footer Bottom','expert-photographer'),
			'panel'  		=> 'expert_photographer_footer_section',
			'priority'      => 3,
		)
    );

	// Site Title Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_photographer_footer_copyright_setting' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'expert_photographer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
		) 
	);
	
	$wp_customize->add_control(
	'expert_photographer_footer_copyright_setting', 
		array(
			'label'	      => esc_html__( 'Hide / Show Footer Copytight', 'expert-photographer' ),
			'section'     => 'expert_photographer_footer_bottom',
			'settings'    => 'expert_photographer_footer_copyright_setting',
			'type'        => 'checkbox'
		) 
	);
	
	// Footer Copyright 
	$wp_customize->add_setting(
    	'expert_photographer_footer_copyright',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 4,
		)
	);

	$wp_customize->add_control( 
		'expert_photographer_footer_copyright',
		array(
		    'label'   		=> __('Edit Copyright Text','expert-photographer'),
		    'section'		=> 'expert_photographer_footer_bottom',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);

	$wp_customize->add_setting( 'expert_photographer_copyright_alignment', array(
        'default'   => 'center',
        'sanitize_callback' => 'expert_photographer_sanitize_copyright_position',
    ));

    $wp_customize->add_control( 'expert_photographer_copyright_alignment', array(
        'label'    => __( 'Copyright Position', 'expert-photographer' ),
        'section'  => 'expert_photographer_footer_bottom',
        'settings' => 'expert_photographer_copyright_alignment',
        'type'     => 'radio',
        'choices'  => array(
            'right' => __( 'Right Align', 'expert-photographer' ),
            'left'  => __( 'Left Align', 'expert-photographer' ),
            'center'  => __( 'Center Align', 'expert-photographer' ),
        ),
    ));

	$wp_customize->add_setting( 'expert_photographer_upgrade_page_settings_2',
        array(
            'sanitize_callback' => 'sanitize_text_field'
        )
    );
    $wp_customize->add_control( new Expert_Photographer_Control_Upgrade(
        $wp_customize, 'expert_photographer_upgrade_page_settings_2',
            array(
                'priority'      => 200,
                'section'       => 'expert_photographer_footer_bottom',
                'settings'      => 'expert_photographer_upgrade_page_settings_2',
                'label'         => __( 'Expert Photographer Pro comes with additional features.', 'expert-photographer' ),
                'choices'       => array( __( '15+ Ready-Made Sections', 'expert-photographer' ), __( 'One-Click Demo Import', 'expert-photographer' ), __( 'WooCommerce Integrated', 'expert-photographer' ), __( 'Drag & Drop Section Reordering', 'expert-photographer' ),__( 'Advanced Typography Control', 'expert-photographer' ),__( 'Intuitive Customization Options', 'expert-photographer' ),__( '24/7 Support', 'expert-photographer' ), )
            )
        )
    ); 
}
add_action( 'customize_register', 'expert_photographer_footer' );

// Footer selective refresh
function expert_photographer_footer_partials( $wp_customize ){
	// footer_copyright
	$wp_customize->selective_refresh->add_partial( 'footer_copyright', array(
		'selector'            => '.copy-right .copyright-text',
		'settings'            => 'footer_copyright',
		'render_callback'  => 'expert_photographer_footer_copyright_render_callback',
	) );
}
add_action( 'customize_register', 'expert_photographer_footer_partials' );

// copyright_content
function expert_photographer_footer_copyright_render_callback() {
	return get_theme_mod( 'footer_copyright' );
}