// Menu Functions
function expert_photographer_openNav() {
    jQuery(".sidenav").addClass('show');
  }
  
  function expert_photographer_closeNav() {
    jQuery(".sidenav").removeClass('show');
  }
  
  /////////////////////// Focus handling ///////////////////////
  (function(window, document) {
    function expert_photographer_handleMobileMenuNavigation() {
      document.addEventListener('keydown', function(e) {
        if (window.innerWidth > 991) return;
        const nav = document.querySelector('.sidenav.show');
        if (!nav) return;
        const focusableElements = Array.from(nav.querySelectorAll(
          'a, button, [tabindex="0"], input, [tabindex]:not([tabindex="-1"])'
        )).filter(el => el.offsetParent !== null);
  
        if (focusableElements.length === 0) return;
  
        const firstElement = focusableElements[0];
        const lastElement = focusableElements[focusableElements.length - 1];
        const activeElement = document.activeElement;
  
        if (e.key === 'Tab') {
          if (!e.shiftKey && activeElement === lastElement) {
            e.preventDefault();
            firstElement.focus();
          } 
          else if (e.shiftKey && activeElement === firstElement) {
            e.preventDefault();
            lastElement.focus();
          }
          else if (!nav.contains(activeElement)) {
            e.preventDefault();
            firstElement.focus();
          }
          return;
        }
  
        if (e.key === 'Tab' && e.shiftKey) {
          const activeElement = document.activeElement;
  
          if (activeElement.closest('.dropdown-menu')) {
            e.preventDefault();
            
            //current submenu
            const currentSubmenu = activeElement.closest('.dropdown-menu');
            const submenuItems = Array.from(currentSubmenu.querySelectorAll('a, button, [tabindex="0"]'))
              .filter(el => el.offsetParent !== null);
            const currentIndex = submenuItems.indexOf(activeElement);
            if (currentIndex > 0) {
              submenuItems[currentIndex - 1].focus();
            } else {
              const parentDropdown = currentSubmenu.closest('.dropdown, .page_item_has_children');
              if (parentDropdown) {
                // Find all focusable elements in parent
                const allFocusable = Array.from(parentDropdown.querySelectorAll('a, button, [tabindex="0"]'))
                  .filter(el => el.offsetParent !== null);
                
                // Filter to only direct children of parentDropdown
                const parentItems = allFocusable.filter(el => el.parentElement === parentDropdown);
                
                if (parentItems.length > 0) {
                  parentItems[0].focus();
                }
              }
            }
          }
        }
      });
    }
  
    document.addEventListener('DOMContentLoaded', function() {
      expert_photographer_handleMobileMenuNavigation();
  
      document.addEventListener('focusin', function(e) {
        if (window.innerWidth > 991) return;
        
        const focusedItem = e.target;
        const submenu = focusedItem.closest('.dropdown-menu');
        if (submenu) {
          submenu.style.display = 'block';
          submenu.classList.add('show');
        }
      });
    });
  })(window, document);
  
  /////////////////////// end ///////////////////////
  

jQuery(function($) {
    "use strict";

    /////////////////////// Menu events binding ///////////////////////

  $(document).ready(function () {
    /*--- adding dropdown class to menu -----*/
    $("ul.sub-menu,ul.children").parent().addClass("dropdown");
    $("ul.sub-menu,ul.children").addClass("dropdown-menu");
    $("ul#menuid li.dropdown a,ul.children li.dropdown a").addClass("dropdown-toggle");
    $("ul.sub-menu li a,ul.children li a").removeClass("dropdown-toggle");
    $('nav li.dropdown > a, .page_item_has_children a').append('<span class="caret"></span>');
    $('a.dropdown-toggle').attr('data-toggle', 'dropdown');

    /*-- Mobile menu --*/
    if ($('#site-navigation').length) {
        $('#site-navigation .menu li.dropdown,li.page_item_has_children').append(function () {
            return '<i class="fas fa-caret-down abc" aria-hd="true"></i>';
        });
        $('#site-navigation .menu li.dropdown .fas,li.page_item_has_children .fas').on('click', function () {
            $(this).parent('li').children('ul').slideToggle().toggleClass('show');
        });
    }

    /*-- tooltip --*/
    $('[data-toggle="tooltip"]').tooltip();

    /*-- Button Up --*/
    var btnUp = $('<div/>', { 'class': 'btntoTop' });
    btnUp.appendTo('body');
    $(document).on('click', '.btntoTop', function (e) {
        e.preventDefault();
        $('html, body').animate({
            scrollTop: 0
        }, 700);
    });

    $(window).on('scroll', function () {
        if ($(this).scrollTop() > 200)
            $('.btntoTop').addClass('active');
        else
            $('.btntoTop').removeClass('active');
    });

    /*-- Reload page when width is between 320 and 768px and only from desktop */
    var isMobile = /Android|webOS|iPhone|iPad|iPod|BlackBerry/i.test(navigator.userAgent) ? true : false;
    $(window).on('resize', function () {
        var win = $(this); //this = window
        if (win.width() > 320 && win.width() < 991 && isMobile == false && !$("body").hasClass("elementor-editor-active")) {
            location.reload();
        }
    });
    });
    ExpertPhotographerSearchFocusHandler();

  /////////////////////// end ///////////////////////

    // Scroll to top button
    let scrollTopButton = $('#scrolltop');
    $(window).scroll(function() {
        if ($(window).scrollTop() > 300) {
            scrollTopButton.addClass('scroll');
        } else {
            scrollTopButton.removeClass('scroll');
        }
    });
    scrollTopButton.on('click', function(e) {
        e.preventDefault();
        $('html, body').animate({ scrollTop: 0 }, '300');
    });

    // Loading screen (preloader)
    window.addEventListener('load', function() {
        $(".loading").delay(2000).fadeOut("slow");
    });

    // Search focus handler
    function ExpertPhotographerSearchFocusHandler() {
        const searchFirstTab = $('.inner_searchbox input[type="search"]');
        const searchLastTab = $('button.search-close');

        $(".open-search").click(function(e) {
            e.preventDefault();
            e.stopPropagation();
            $('body').addClass("search-focus");
            searchFirstTab.focus();
        });

        $("button.search-close").click(function(e) {
            e.preventDefault();
            e.stopPropagation();
            $('body').removeClass("search-focus");
            $(".open-search").focus();
        });
        // Redirect last tab to first input
        searchLastTab.on('keydown', function(e) {
            if ($('body').hasClass('search-focus') && e.which === 9 && !e.shiftKey) {
                e.preventDefault();
                searchFirstTab.focus();
            }
        });
        // Redirect first shift+tab to last input
        searchFirstTab.on('keydown', function(e) {
            if ($('body').hasClass('search-focus') && e.which === 9 && e.shiftKey) {
                e.preventDefault();
                searchLastTab.focus();
            }
        });
        // Allow escape key to close menu
        $('.inner_searchbox').on('keyup', function(e) {
            if ($('body').hasClass('search-focus') && e.keyCode === 27) {
                $('body').removeClass('search-focus');
                searchLastTab.focus();
            }
        });
    }

});

// slider section
jQuery(document).ready(function($) {
    var isRTL = $('html').attr('dir') === 'rtl'; // Check if the HTML direction is RTL
    $('#slider .owl-carousel').owlCarousel({
        loop: true,
        margin: 10,
        nav: true,
        dots: false,
        autoplay: false,
        autoplayTimeout: 5000,
        items: 1,
        rtl: isRTL 
    });
}); 


function flashcountdown($timer, mydate) {
    // Set the date we're counting down to
    var countDownDate = new Date(mydate).getTime();

    // Update the count down every 1 second
    var x = setInterval(function() {
        // Get today's date and time
        var now = new Date().getTime();

        // Find the distance between now and the countdown date
        var distance = countDownDate - now;

        // Time calculations for days, hours, minutes, and seconds
        var days = Math.floor(distance / (1000 * 60 * 60 * 24));
        var hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
        var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
        var seconds = Math.floor((distance % (1000 * 60)) / 1000);

        // Output the result in an element with separate classes for each unit
        $timer.html(
            "<div class='numbers days'>" + days + "d</div> " +
            "<div class='numbers hours'>" + hours + "h</div> " +
            "<div class='numbers minutes'>" + minutes + "m</div> " +
            "<div class='numbers seconds'>" + seconds + "s</div>"
        );

        // If the countdown is over, display "Timer Up - EVENT EXPIRED"
        if (distance < 0) {
            clearInterval(x);
            $timer.html("Timer Up - EVENT EXPIRED");
        }
    }, 1000);
}

// Get the date from an element with class .date2
var mydate = jQuery('.date2').val();

// Loop through each element with the class .countdown2 and apply the countdown
jQuery(".countdown2").each(function() {
    flashcountdown(jQuery(this), mydate);
});