<?php
?>
<?php $expert_photographer_static_image = get_stylesheet_directory_uri() . '/assets/images/sliderimage.png'; ?>

<?php if(get_theme_mod('expert_photographer_services_show_hide') != true){ ?>
<div id="services" class="mt-5 px-lg-3">
  <div class="container">
    <?php if( get_theme_mod( 'expert_photographer_news_heading' ) != '' ) { ?>
        <h2 class="text-center mb-4 service-title text-capitalize"><?php echo esc_html( get_theme_mod( 'expert_photographer_news_heading', '' ) ); ?></h2>
    <?php } ?>
    <?php if (get_theme_mod('expert_photographer_section_text')) : ?>
        <p class="main-content"><?php echo esc_html(get_theme_mod('expert_photographer_section_text')); ?></p>
      <?php endif; ?>
    <div class="row">
      <?php
        $expert_photographer_post_category = get_theme_mod('expert_photographer_services_section_category','uncategorized');
        if($expert_photographer_post_category){
          $expert_photographer_page_query = new WP_Query(array( 'category_name' => esc_html( $expert_photographer_post_category ,'expert-photographer')));?>
          <?php while( $expert_photographer_page_query->have_posts() ) : $expert_photographer_page_query->the_post(); ?>
            <div class="col-lg-4 col-md-6 col-sm-6">
              <div class="custom_block text-center my-3">
                <div class="services-heading">
                  <h4><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
                </div>
                <div class="services-inner">
                  <?php if(has_post_thumbnail()) { ?>
                    <?php the_post_thumbnail(); ?>
                  <?php } else { ?>
                    <div class="post-color"></div>
                  <?php } ?>
                </div>
                <div class="service-body">
                  <div class="services_p">
                   <p><?php echo wp_trim_words( get_the_content(),15 );?></p> 
                    <div class="demo-box">
                    <div class="box-btn">
                    <a href="<?php the_permalink(); ?>"><?php esc_html_e('View More','expert-photographer'); ?>     <i class="fas fa-arrow-right"></i></a>
                  </div>
                </div>
                  </div>
                </div>
              </div>
            </div>
          <?php endwhile;
          wp_reset_postdata();
        }
      ?>
    </div>
  </div>
</div>
 <?php } ?>