<header>
    <div class="vertical-head">
        <div class="main-header headerbox">
            <div class="scrollable-content">
                <div class="middle-header-area h-100 d-flex flex-column">
                    <div class="container-fluid h-100">
                        <div class="row h-100">
                            <div class="col-lg-12 col-md-4 logo-col text-center align-self-center">
                                <div class="logo">
                                    <?php 
                                    if (has_custom_logo()) {
                                        the_custom_logo();
                                    } else {
                                        // Check if both title and tagline settings are disabled
                                        $expert_photographer_tagline_enabled = get_theme_mod('expert_photographer_tagline_setting', false);
                                        $expert_photographer_title_enabled = get_theme_mod('expert_photographer_site_title_setting', false);

                                        if (!$expert_photographer_tagline_enabled && !$expert_photographer_title_enabled) {
                                            // Display the default logo
                                            $expert_photographer_default_logo_url = get_template_directory_uri() . '/assets/images/logo.png'; // Replace with your default logo path
                                            echo '<a href="' . esc_url(home_url('/')) . '">';
                                            echo '<img src="' . esc_url($expert_photographer_default_logo_url) . '" alt="' . esc_attr(get_bloginfo('name')) . '">';
                                            echo '</a>';
                                        }

                                        // Display tagline if the setting is enabled
                                        if ($expert_photographer_tagline_enabled) :
                                            $expert_photographer_site_desc = get_bloginfo('description'); ?>
                                            <p class="site-description"><?php echo esc_html($expert_photographer_site_desc); ?></p>
                                        <?php endif; ?>

                                        <?php
                                        // Display site title if the setting is enabled
                                        if ($expert_photographer_title_enabled) : ?>
                                            <p class="site-title">
                                                <a href="<?php echo esc_url(home_url('/')); ?>">
                                                    <?php echo esc_html(get_bloginfo('name')); ?>
                                                </a>
                                            </p>
                                        <?php endif; ?>
                                    <?php } ?>
                                </div>
                            </div>
                            <div class="col-lg-12 col-md-4 col-12 menu-col">
                                <div class="menubox">
                                    <div class="navbar-menubar responsive-menu navigation_header">
                                        <div class="toggle-nav mobile-menu">
                                            <button onclick="expert_photographer_openNav()">
                                                <i class="fa-solid fa-bars"></i> <!-- Initial hamburger icon -->
                                            </button>
                                        </div>
                                        <div id="mySidenav" class="nav sidenav">
                                            <nav id="site-navigation" class="main-navigation navbar navbar-expand-xl" aria-label="<?php esc_attr_e( 'Top Menu', 'expert-photographer' ); ?>">

                                                <?php 
                                                    wp_nav_menu(
                                                        array(
                                                            'theme_location' => 'primary',
                                                            'container_class' => 'main-menu clearfix',
                                                            'menu_class' => 'clearfix menu',
                                                            'items_wrap' => '<ul id="%1$s" class="%2$s mobile_nav">%3$s</ul>',
                                                            'fallback_cb' => 'wp_page_menu',
                                                        )
                                                    );
                                                ?>
                                                <a href="javascript:void(0)" class="closebtn mobile-menu" onclick="expert_photographer_closeNav()">
                                                    <i class="fa-solid fa-times"></i> <!-- Close icon for the menu -->
                                                </a>
                                            </nav>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-12 col-md-4 text-left">
                                <div class="social-media">
                                    <?php if (get_theme_mod('expert_photographer_facebook_url','#')) : ?>
                                        <a target="_blank" rel="noopener noreferrer" href="<?php echo esc_url(get_theme_mod('expert_photographer_facebook_url','#')); ?>">
                                            <i class="fab fa-facebook-f me-2"></i>
                                        </a>
                                    <?php endif; ?>
                                    <?php if (get_theme_mod('expert_photographer_instagram_url','#')) : ?>
                                        <a target="_blank" rel="noopener noreferrer" href="<?php echo esc_url(get_theme_mod('expert_photographer_instagram_url','#')); ?>">
                                            <i class="fab fa-instagram me-2"></i>
                                        </a>
                                    <?php endif; ?>
                                    <?php if (get_theme_mod('expert_photographer_twitter_url','#')) : ?>
                                        <a target="_blank" rel="noopener noreferrer" href="<?php echo esc_url(get_theme_mod('expert_photographer_twitter_url','#')); ?>">
                                            <i class="fab fa-twitter me-2"></i>
                                        </a>
                                    <?php endif; ?>
                                    <?php if (get_theme_mod('expert_photographer_youtube_url','#')) : ?>
                                        <a target="_blank" rel="noopener noreferrer" href="<?php echo esc_url(get_theme_mod('expert_photographer_youtube_url','#')); ?>">
                                            <i class="fab fa-youtube me-2"></i>
                                        </a>
                                    <?php endif; ?>
                                    <?php if (get_theme_mod('expert_photographer_pinterest_url','#')) : ?>
                                        <a target="_blank" rel="noopener noreferrer" href="<?php echo esc_url(get_theme_mod('expert_photographer_pinterest_url','#')); ?>">
                                            <i class="fab fa-pinterest me-2"></i>
                                        </a>
                                    <?php endif; ?>
                                    <?php if (get_theme_mod('expert_photographer_linkedin_url','#')) : ?>
                                        <a target="_blank" rel="noopener noreferrer" href="<?php echo esc_url(get_theme_mod('expert_photographer_linkedin_url','#')); ?>">
                                            <i class="fab fa-linkedin me-2"></i>
                                        </a>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php if (get_theme_mod('expert_photographer_topbar', true)) : ?>
        <div class="main-tophead">
            <div class="top-header">
                <div class="container">
                  <div class="row m-0">
                    <div class="col-lg-3 col-md-3 align-self-center">
                      <div class="timebox call">
                        <?php if( get_theme_mod( 'expert_photographer_call','+1800-123-456')) { ?>
                          <i class="fas fa-phone-volume"></i>
                          <span class="phone"><a href="tel:<?php echo esc_html( get_theme_mod('expert_photographer_call','+1800-123-456') ); ?>"><?php echo esc_html( get_theme_mod('expert_photographer_call','+1800-123-456')); ?></a></span>
                        <?php } ?>
                      </div>
                    </div>

                    <div class="col-lg-4 col-md-4 align-self-center">
                      <div class="timebox mail">
                        <?php if( get_theme_mod( 'expert_photographer_mail','photographer@example.com')) { ?>
                        <i class="fas fa-envelope-open"></i>
                          <span class="phone"><a href="mailto:<?php echo esc_html( get_theme_mod('expert_photographer_mail','photographer@example.com') ); ?>"><?php echo esc_html( get_theme_mod('expert_photographer_mail','photographer@example.com')); ?></a></span>
                        <?php } ?>
                      </div>
                    </div>

                    <div class="col-lg-4 col-md-4 align-self-center">
                      <div class="timebox">
                        <?php if( get_theme_mod( 'expert_photographer_location','abc raod, 41 street. New York')) { ?>
                          <i class="fas fa-map-marker-alt"></i><span class="phone"><?php echo esc_html( get_theme_mod('expert_photographer_location','abc raod, 41 street. New York')); ?></span>
                        <?php } ?>
                      </div>
                    </div>

                    <div class="col-lg-1 col-md-1 col-12 search-box align-self-center px-0">
                        <span class="search-bar text-md-end">
                            <button type="button" class="open-search"><i class="fas fa-search"></i></button>
                        </span>
                    </div>
                    <div class="clearfix"></div>
                  </div>
                    <div class="search-outer">
                        <div class="inner_searchbox w-100 h-100">
                            <?php get_search_form(); ?>
                        </div>
                        <button type="button" class="search-close"><?php esc_html_e('CLOSE', 'expert-photographer'); ?></button>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>

</header>
