<?php
/**
 * The template for displaying search form.
 *
 * @package Expert Photographer
 * @since 1.0
 */
?>

<form method="get" class="search-form" action="<?php echo esc_url( home_url( '/' ) ); ?>">
	<label>
		<span class="screen-reader-text"><?php esc_html_e( 'Search for:', 'expert-photographer' ); ?></span>
		<input type="search" class="search-field" placeholder="<?php esc_attr_e( 'Search...', 'expert-photographer' ); ?>" value="" name="s">
	</label>
	<button type="submit" class="search-submit" value="<?php esc_attr_e( 'Search', 'expert-photographer' ); ?>">
		<i class="fa fa-search"></i>
	</button>
</form>