<?php

// In your theme's functions.php or equivalent
add_action('customize_controls_enqueue_scripts', function() {
    $version = wp_get_theme()->get('Version');
    
    // Define parameters
    $customizer_params = array(
        'some_key' => 'some_value', // Add your parameters here
    );
    
    wp_enqueue_script(
        'expert-photographer-customize-section-button',
        get_theme_file_uri('assets/js/customize-controls.js'),
        ['customize-controls'],
        $version,
        true
    );

    wp_enqueue_style(
        'expert-photographer-customize-section-button',
        get_theme_file_uri('assets/css/customize-controls.css'),
        ['customize-controls'],
        $version
    );

    wp_localize_script(
        'expert-photographer-customize-section-button',
        'expert_photographer_customizer_params',
        $customizer_params
    );
});


 /**
 * Enqueue scripts and styles.
 */
function expert_photographer_scripts() {
	// Styles	 

	wp_enqueue_style('bootstrap-min',get_template_directory_uri().'/assets/css/bootstrap.min.css');

	// owl
	wp_enqueue_style( 'owl-carousel-css', get_theme_file_uri( '/assets/css/owl.carousel.css' ) );
		
	wp_enqueue_style( 'font-awesome', get_template_directory_uri().'/assets/css/fontawesome-all.css' );
	
	wp_enqueue_style('expert-photographer-editor-style',get_template_directory_uri().'/assets/css/editor-style.css');

	wp_enqueue_style('expert-photographer-main', get_template_directory_uri() . '/assets/css/main.css');

	wp_enqueue_style('expert-photographer-woo', get_template_directory_uri() . '/assets/css/woo.css');
	
	wp_enqueue_style( 'expert-photographer-style', get_stylesheet_uri() );


	wp_enqueue_style('expert-photographer-main', get_stylesheet_uri(), array() );
		wp_style_add_data('expert-photographer-main', 'rtl', 'replace');
	
	// Scripts

	wp_enqueue_script('bootstrap', get_template_directory_uri() . '/assets/js/bootstrap.bundle.min.js', array('jquery'), false, true);

	wp_enqueue_script('expert-photographer-theme-js', get_template_directory_uri() . '/assets/js/theme.js', array('jquery'), false, true);

	wp_enqueue_script( 'owl-carousel-js', get_theme_file_uri( '/assets/js/owl.carousel.js' ), array( 'jquery' ), true );

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}

	// inlin css
	$expert_photographer_inline_style = '';

	$expert_photographer_slider_setting = get_theme_mod( 'expert_photographer_slider_setting', true);
	if($expert_photographer_slider_setting == false) {
	    $expert_photographer_inline_style .= '.page-template-template-frontpage .top-header{';
	    $expert_photographer_inline_style .= 'position:static; border-bottom:1px solid #ccc;';
	    $expert_photographer_inline_style .= '}';
	    $expert_photographer_inline_style .= '.page-template-template-frontpage .timebox span, .page-template-template-frontpage .timebox span a, .page-template-template-frontpage .timebox i{';
	    $expert_photographer_inline_style .= 'color:#000;';
	    $expert_photographer_inline_style .= '}';
	    $expert_photographer_inline_style .= '.page-template-template-frontpage .timebox.call, .page-template-template-frontpage .timebox.mail{';
	    $expert_photographer_inline_style .= 'border-right:1px solid #000;';
	    $expert_photographer_inline_style .= '}';
	}

	wp_add_inline_style( 'expert-photographer-style', $expert_photographer_inline_style );

}
add_action( 'wp_enqueue_scripts', 'expert_photographer_scripts' );

//Admin Enqueue for Admin
function expert_photographer_admin_enqueue_scripts(){
	wp_enqueue_style('expert-photographer-admin-style', esc_url( get_template_directory_uri() ) . '/inc/aboutthemes/admin.css'); 
	wp_enqueue_script('expert-photographer-dismiss-notice-script', get_stylesheet_directory_uri() . '/inc/aboutthemes/theme-admin-notice.js', array('jquery'), null, true);
}
add_action( 'admin_enqueue_scripts', 'expert_photographer_admin_enqueue_scripts' );

// Function to enqueue custom CSS
function expert_photographer_enqueue_custom_css() {
    // Define a unique handle for your inline stylesheet
    $handle = 'expert-photographer-style';
    
    // Get the generated custom CSS
    $expert_photographer_custom_css = "";

    $expert_photographer_blog_layouts = get_theme_mod('expert_photographer_blog_layout_option_setting', 'Default');
    if ($expert_photographer_blog_layouts == 'Default') {
        $expert_photographer_custom_css .= '.blog-item{';
        $expert_photographer_custom_css .= 'text-align:center;';
        $expert_photographer_custom_css .= '}';
    } elseif ($expert_photographer_blog_layouts == 'Left') {
        $expert_photographer_custom_css .= '.blog-item{';
        $expert_photographer_custom_css .= 'text-align:Left;';
        $expert_photographer_custom_css .= '}';
    } elseif ($expert_photographer_blog_layouts == 'Right') {
        $expert_photographer_custom_css .= '.blog-item{';
        $expert_photographer_custom_css .= 'text-align:Right;';
        $expert_photographer_custom_css .= '}';
    }

    // Enqueue the inline stylesheet
    wp_add_inline_style($handle, $expert_photographer_custom_css);

    // Add inline style for Scroll to Top
    $expert_photographer_scroll_top_bg_color = get_theme_mod('expert_photographer_scroll_top_bg_color', '#5a50e7');
    $expert_photographer_scroll_top_color = get_theme_mod('expert_photographer_scroll_top_color', '#fff');
    $expert_photographer_scroll_custom_css = "
        #scrolltop {
            background-color: {$expert_photographer_scroll_top_bg_color};
        }
        #scrolltop span {
            color: {$expert_photographer_scroll_top_color};
        }
    ";
    wp_add_inline_style('expert-photographer-style', $expert_photographer_scroll_custom_css);

    // Add inline style for Preloader
    $expert_photographer_preloader_bg_color = get_theme_mod('expert_photographer_preloader_bg_color', '#ffffff');
    $expert_photographer_preloader_color = get_theme_mod('expert_photographer_preloader_color', '#5a50e7');
    $expert_photographer_preloader_custom_css = "
        .loading {
            background-color: {$expert_photographer_preloader_bg_color};
        }
        .loader {
            border-color: {$expert_photographer_preloader_color};
            color: {$expert_photographer_preloader_color};
            text-shadow: 0 0 10px {$expert_photographer_preloader_color};
        }
        .loader::before {
            border-top-color: {$expert_photographer_preloader_color};
            border-right-color: {$expert_photographer_preloader_color};
        }
        .loader span::before {
            background: {$expert_photographer_preloader_color};
            box-shadow: 0 0 10px {$expert_photographer_preloader_color};
        }
    ";
    wp_add_inline_style('expert-photographer-style', $expert_photographer_preloader_custom_css);
}

// Hook the function to the 'wp_enqueue_scripts' action
add_action('wp_enqueue_scripts', 'expert_photographer_enqueue_custom_css');