<?php
function expert_photographer_upper_header_settings( $wp_customize ) {
$selective_refresh = isset( $wp_customize->selective_refresh ) ? 'postMessage' : 'refresh';

	/*=========================================
	top header
	=========================================*/
	$wp_customize->add_section(
        'expert_photographer_topbar',
        array(
        	'priority'      => 3,
            'title' 		=> __('Header Informations','expert-photographer'),
			'panel'  		=> 'expert_photographer_frontpage_sections',
		)
    );

    // Site Title Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_photographer_topbar' , 
			array(
			'default' => true,
			'sanitize_callback' => 'expert_photographer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
		) 
	);
	
	$wp_customize->add_control(
	'expert_photographer_topbar', 
		array(
			'label'	      => esc_html__( 'Hide / Show Topbar', 'expert-photographer' ),
			'section'     => 'expert_photographer_topbar',
			'settings'    => 'expert_photographer_topbar',
			'type'        => 'checkbox'
		) 
	);

    $wp_customize->add_setting(
		'expert_photographer_call',
		array(
			'default' => '+1800-123-456',
			'sanitize_callback'	=> 'expert_photographer_sanitize_phone_number'
		)
	);
	$wp_customize->add_control(
		'expert_photographer_call',array(
			'label'	=> __('Add Phone Number','expert-photographer'),
			'section'=> 'expert_photographer_topbar',
			'type'=> 'text'
		)
	);

	$wp_customize->add_setting('expert_photographer_mail',array(
			'default' => 'photographer@example.com',
		'sanitize_callback'	=> 'sanitize_email'
	));
	$wp_customize->add_control('expert_photographer_mail',array(
		'label'	=> __('Add Mail Address','expert-photographer'),
		'section'=> 'expert_photographer_topbar',
		'type'=> 'text'
	));

	$wp_customize->add_setting('expert_photographer_location',array(
			'default' => 'abc raod, 41 street. New York',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('expert_photographer_location',array(
		'label'	=> __('Add location','expert-photographer'),
		'section'=> 'expert_photographer_topbar',
		'type'=> 'text'
	));


	$wp_customize->add_setting( 'expert_photographer_upgrade_page_settings_12da',
        array(
            'sanitize_callback' => 'sanitize_text_field'
        )
    );
    $wp_customize->add_control( new Expert_Photographer_Control_Upgrade(
        $wp_customize, 'expert_photographer_upgrade_page_settings_12da',
            array(
                'priority'      => 200,
                'section'       => 'expert_photographer_topbar',
                'settings'      => 'expert_photographer_upgrade_page_settings_12da',
                'label'         => __( 'Expert Photographer Pro comes with additional features.', 'expert-photographer' ),
                'choices'       => array( __( '15+ Ready-Made Sections', 'expert-photographer' ), __( 'One-Click Demo Import', 'expert-photographer' ), __( 'WooCommerce Integrated', 'expert-photographer' ), __( 'Drag & Drop Section Reordering', 'expert-photographer' ),__( 'Advanced Typography Control', 'expert-photographer' ),__( 'Intuitive Customization Options', 'expert-photographer' ),__( '24/7 Support', 'expert-photographer' ), )
            )
        )
    ); 

	// Social Link
	$wp_customize->add_section( 'expert_photographer_social_media', array(
    	'title'      => __( 'Social Media Links', 'expert-photographer' ),
    	'description' => __( 'Add your Social Links', 'expert-photographer' ),
		'panel' => 'expert_photographer_header_section',
      'priority' => 4,
	) );

	$wp_customize->add_setting('expert_photographer_facebook_url',array(
		'default'=> '#',
		'sanitize_callback'	=> 'esc_url_raw'
	));
	$wp_customize->add_control('expert_photographer_facebook_url',array(
		'label'	=> __('Facebook Link','expert-photographer'),
		'section'=> 'expert_photographer_social_media',
		'type'=> 'url'
	));

	$wp_customize->add_setting('expert_photographer_instagram_url',array(
		'default'=> '#',
		'sanitize_callback'	=> 'esc_url_raw'
	));
	$wp_customize->add_control('expert_photographer_instagram_url',array(
		'label'	=> __('Instagram Link','expert-photographer'),
		'section'=> 'expert_photographer_social_media',
		'type'=> 'url'
	));

	$wp_customize->add_setting('expert_photographer_twitter_url',array(
		'default'=> '#',
		'sanitize_callback'	=> 'esc_url_raw'
	));
	$wp_customize->add_control('expert_photographer_twitter_url',array(
		'label'	=> __('Twitter Link','expert-photographer'),
		'section'=> 'expert_photographer_social_media',
		'type'=> 'url'
	));

	$wp_customize->add_setting('expert_photographer_youtube_url',array(
		'default'=> '#',
		'sanitize_callback'	=> 'esc_url_raw'
	));
	$wp_customize->add_control('expert_photographer_youtube_url',array(
		'label'	=> __('Youtube Link','expert-photographer'),
		'section'=> 'expert_photographer_social_media',
		'type'=> 'url'
	));

	$wp_customize->add_setting('expert_photographer_pinterest_url',array(
		'default'=> '#',
		'sanitize_callback'	=> 'esc_url_raw'
	));
	$wp_customize->add_control('expert_photographer_pinterest_url',array(
		'label'	=> __('Pinterest Link','expert-photographer'),
		'section'=> 'expert_photographer_social_media',
		'type'=> 'url'
	));

	$wp_customize->add_setting('expert_photographer_linkedin_url',array(
		'default'=> '#',
		'sanitize_callback'	=> 'esc_url_raw'
	));
	$wp_customize->add_control('expert_photographer_linkedin_url',array(
		'label'	=> __('Linkedin Link','expert-photographer'),
		'section'=> 'expert_photographer_social_media',
		'type'=> 'url'
	));

	$wp_customize->add_setting( 'expert_photographer_upgrade_page_settings_12',
        array(
            'sanitize_callback' => 'sanitize_text_field'
        )
    );
    $wp_customize->add_control( new Expert_Photographer_Control_Upgrade(
        $wp_customize, 'expert_photographer_upgrade_page_settings_12',
            array(
                'priority'      => 200,
                'section'       => 'expert_photographer_social_media',
                'settings'      => 'expert_photographer_upgrade_page_settings_12',
                'label'         => __( 'Expert Photographer Pro comes with additional features.', 'expert-photographer' ),
                'choices'       => array( __( '15+ Ready-Made Sections', 'expert-photographer' ), __( 'One-Click Demo Import', 'expert-photographer' ), __( 'WooCommerce Integrated', 'expert-photographer' ), __( 'Drag & Drop Section Reordering', 'expert-photographer' ),__( 'Advanced Typography Control', 'expert-photographer' ),__( 'Intuitive Customization Options', 'expert-photographer' ),__( '24/7 Support', 'expert-photographer' ), )
            )
        )
    ); 

}
add_action( 'customize_register', 'expert_photographer_upper_header_settings' );