<?php

function expert_photographer_blog_setting( $wp_customize ) {

	$wp_customize->register_control_type( 'Expert_Photographer_Control_Upgrade' );


$selective_refresh = isset( $wp_customize->selective_refresh ) ? 'postMessage' : 'refresh';
	$wp_customize->add_panel(
		'expert_photographer_frontpage_sections', array(
			'priority' => 1,
			'title' => esc_html__( 'Frontpage Sections', 'expert-photographer' ),
		)
	);
	
	/*=========================================
	Slider Section
	=========================================*/
	$wp_customize->add_section(
		'expert_photographer_slider_section', array(
			'title' => esc_html__( 'Slider Section', 'expert-photographer' ),
			'priority' => 13,
			'panel' => 'expert_photographer_frontpage_sections',
		)
	);

	// Slider Hide/ Show Setting // 
	$wp_customize->add_setting( 
		'expert_photographer_slider_setting' , 
			array(
			'default' => true,
			'sanitize_callback' => 'expert_photographer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'expert_photographer_slider_setting', 
		array(
			'label'	      => esc_html__( 'Hide / Show Section', 'expert-photographer' ),
			'section'     => 'expert_photographer_slider_section',
			'settings'    => 'expert_photographer_slider_setting',
			'type'        => 'checkbox'
		) 
	);
	
	for ( $expert_photographer_count = 1; $expert_photographer_count <= 3; $expert_photographer_count++ ) {

	// Add color scheme setting and control.
	$wp_customize->add_setting( 'expert_photographer_slider_page' . $expert_photographer_count, array(
		'sanitize_callback' => 'expert_photographer_sanitize_dropdown_pages'
	) );

	$wp_customize->add_control( 'expert_photographer_slider_page' . $expert_photographer_count, array(
		'label'    => __( 'Select Slide Image Page', 'expert-photographer' ),
		'section'  => 'expert_photographer_slider_section',
		'type'     => 'dropdown-pages'
	) );
	}

	$wp_customize->add_setting(
    	'expert_photographer_slider_btn_text',
    	array(
			'default' => 'Get Started',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);
	$wp_customize->add_control(
		'expert_photographer_slider_btn_text',
		array(
		    'label'   		=> __('Slider Button Text 1','expert-photographer'),
		    'section'		=> 'expert_photographer_slider_section',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);

	$wp_customize->add_setting(
    	'expert_photographer_slider_btn_link',
    	array(
			'default' => '',
			'sanitize_callback' => 'esc_url_raw',
		)
	);
	$wp_customize->add_control( 
		'expert_photographer_slider_btn_link',
		array(
		    'label'   		=> __('Slider Button Link 1','expert-photographer'),
		    'section'		=> 'expert_photographer_slider_section',
			'type' 			=> 'url',
			'transport'         => $selective_refresh,
		)
	);

	$wp_customize->add_setting('expert_photographer_slider_video', array(
		'sanitize_callback'	=> 'esc_url_raw'
	));
	$wp_customize->add_control('expert_photographer_slider_video',array(
		'label'	=> __('Add Video Link','expert-photographer'),
		'section'	=> 'expert_photographer_slider_section',
		'type'		=> 'url'
	));

	$wp_customize->add_setting('expert_photographer_product_clock_timer_end', array(
	    'sanitize_callback' => 'sanitize_text_field',
	));

	$wp_customize->add_control('expert_photographer_product_clock_timer_end', array(
	    'label' => __('Set Timer End Date', 'expert-photographer'),
	    'section' => 'expert_photographer_slider_section',
	    'description' => wp_kses_post( __('Set the end date and time for the timer using the following format: "Month date year hours:minutes:seconds" (e.g., "September 10 2024 12:00:00").', 'expert-photographer')),
	    'type' => 'text',
	));

	$wp_customize->add_setting( 'expert_photographer_upgrade_page_settings_3',
        array(
            'sanitize_callback' => 'sanitize_text_field'
        )
    );
    $wp_customize->add_control( new Expert_Photographer_Control_Upgrade(
        $wp_customize, 'expert_photographer_upgrade_page_settings_3',
            array(
                'priority'      => 200,
                'section'       => 'expert_photographer_slider_section',
                'settings'      => 'expert_photographer_upgrade_page_settings_3',
                'label'         => __( 'Expert Photographer Pro comes with additional features.', 'expert-photographer' ),
                'choices'       => array( __( '15+ Ready-Made Sections', 'expert-photographer' ), __( 'One-Click Demo Import', 'expert-photographer' ), __( 'WooCommerce Integrated', 'expert-photographer' ), __( 'Drag & Drop Section Reordering', 'expert-photographer' ),__( 'Advanced Typography Control', 'expert-photographer' ),__( 'Intuitive Customization Options', 'expert-photographer' ),__( '24/7 Support', 'expert-photographer' ), )
            )
        )
    ); 

	//home page service
	$wp_customize->add_section( 'expert_photographer_services_section' , array(
    	'title'      => __( 'Services Section', 'expert-photographer' ),
    	'priority' => 14,
		'panel' => 'expert_photographer_frontpage_sections'
	) );

	$wp_customize->add_setting( 
		'expert_photographer_services_show_hide' , 
			array(
			'sanitize_callback' => 'expert_photographer_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	'expert_photographer_services_show_hide', 
		array(
			'label'	      => esc_html__( 'Hide / Show Section', 'expert-photographer' ),
			'section'     => 'expert_photographer_services_section',
			'settings'    => 'expert_photographer_services_show_hide',
			'type'        => 'checkbox'
		) 
	);

	$wp_customize->add_setting('expert_photographer_news_heading',array(
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('expert_photographer_news_heading',array(
		'label'	=> __('Add Heading','expert-photographer'),
		'section'=> 'expert_photographer_services_section',
		'type'=> 'text'
	));


	$wp_customize->add_setting(
    	'expert_photographer_section_text',
    	array(
			'sanitize_callback' => 'sanitize_text_field',
		)
	);	
	$wp_customize->add_control( 
		'expert_photographer_section_text',
		array(
		    'label'   		=> __('Section Text','expert-photographer'),
		    'section'		=> 'expert_photographer_services_section',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)
	);

	$expert_photographer_categories = get_categories();
	$expert_photographer_cats = array();
	$expert_photographer_i = 0;
	$expert_photographer_offer_cat[]= 'select';
	foreach($expert_photographer_categories as $expert_photographer_category){
		if($expert_photographer_i==0){
			$expert_photographer_default = $expert_photographer_category->slug;
			$expert_photographer_i++;
		}
		$expert_photographer_offer_cat[$expert_photographer_category->slug] = $expert_photographer_category->name;
	}
	
	$wp_customize->add_setting('expert_photographer_services_section_category',array(
		'default'	=> 'uncategorized',
		'sanitize_callback' => 'expert_photographer_sanitize_choices',
	));
	$wp_customize->add_control('expert_photographer_services_section_category',array(
		'type'    => 'select',
		'choices' => $expert_photographer_offer_cat,
		'label' => __('Select Category','expert-photographer'),
		'section' => 'expert_photographer_services_section',
	));

	$wp_customize->add_setting( 'expert_photographer_upgrade_page_settings_4',
        array(
            'sanitize_callback' => 'sanitize_text_field'
        )
    );
    $wp_customize->add_control( new Expert_Photographer_Control_Upgrade(
        $wp_customize, 'expert_photographer_upgrade_page_settings_4',
            array(
                'priority'      => 200,
                'section'       => 'expert_photographer_services_section',
                'settings'      => 'expert_photographer_upgrade_page_settings_4',
                'label'         => __( 'Expert Photographer Pro comes with additional features.', 'expert-photographer' ),
                'choices'       => array( __( '15+ Ready-Made Sections', 'expert-photographer' ), __( 'One-Click Demo Import', 'expert-photographer' ), __( 'WooCommerce Integrated', 'expert-photographer' ), __( 'Drag & Drop Section Reordering', 'expert-photographer' ),__( 'Advanced Typography Control', 'expert-photographer' ),__( 'Intuitive Customization Options', 'expert-photographer' ),__( '24/7 Support', 'expert-photographer' ), )
            )
        )
    ); 
}

add_action( 'customize_register', 'expert_photographer_blog_setting' );

// service selective refresh
function expert_photographer_blog_section_partials( $wp_customize ){	
	// blog_title
	$wp_customize->selective_refresh->add_partial( 'blog_title', array(
		'selector'            => '.home-blog .title h6',
		'settings'            => 'blog_title',
		'render_callback'  => 'expert_photographer_blog_title_render_callback',
	
	) );
	
	// blog_subtitle
	$wp_customize->selective_refresh->add_partial( 'blog_subtitle', array(
		'selector'            => '.home-blog .title h2',
		'settings'            => 'blog_subtitle',
		'render_callback'  => 'expert_photographer_blog_subtitle_render_callback',
	
	) );
	
	// blog_description
	$wp_customize->selective_refresh->add_partial( 'blog_description', array(
		'selector'            => '.home-blog .title p',
		'settings'            => 'blog_description',
		'render_callback'  => 'expert_photographer_blog_description_render_callback',
	
	) );	
	}

add_action( 'customize_register', 'expert_photographer_blog_section_partials' );

// blog_title
function expert_photographer_blog_title_render_callback() {
	return get_theme_mod( 'blog_title' );
}

// blog_subtitle
function expert_photographer_blog_subtitle_render_callback() {
	return get_theme_mod( 'blog_subtitle' );
}

// service description
function expert_photographer_blog_description_render_callback() {
	return get_theme_mod( 'blog_description' );
}