<?php
/**
 * Theme Page
 *
 * @package Expert Photographer
 */

if ( ! defined( 'EXPERT_PHOTOGRAPHER_FREE_THEME_URL' ) ) {
	define( 'EXPERT_PHOTOGRAPHER_FREE_THEME_URL', 'https://www.seothemesexpert.com/products/free-photographer-wordpress-theme' );
}
if ( ! defined( 'EXPERT_PHOTOGRAPHER_PRO_THEME_URL' ) ) {
	define( 'EXPERT_PHOTOGRAPHER_PRO_THEME_URL', 'https://www.seothemesexpert.com/products/photographer-website-template' );
}
if ( ! defined( 'EXPERT_PHOTOGRAPHER_FREE_DOC_URL' ) ) {
	define( 'EXPERT_PHOTOGRAPHER_FREE_DOC_URL', 'https://demo.seothemesexpert.com/documentation/expert-photographer/' );
}
if ( ! defined( 'EXPERT_PHOTOGRAPHER_DEMO_THEME_URL' ) ) {
	define( 'EXPERT_PHOTOGRAPHER_DEMO_THEME_URL', 'https://demo.seothemesexpert.com/expert-photographer/' );
}
if ( ! defined( 'EXPERT_PHOTOGRAPHER_DOCS_THEME_URL' ) ) {
    define( 'EXPERT_PHOTOGRAPHER_DOCS_THEME_URL', 'https://www.seothemesexpert.com/documentation/expert-photographer-pro/' );
}
if ( ! defined( 'EXPERT_PHOTOGRAPHER_RATE_THEME_URL' ) ) {
    define( 'EXPERT_PHOTOGRAPHER_RATE_THEME_URL', 'https://wordpress.org/support/theme/expert-photographer/reviews/#new-post' );
}
if ( ! defined( 'EXPERT_PHOTOGRAPHER_SUPPORT_THEME_URL' ) ) {
    define( 'EXPERT_PHOTOGRAPHER_SUPPORT_THEME_URL', 'https://wordpress.org/support/theme/expert-photographer/' );
}
if ( ! defined( 'EXPERT_PHOTOGRAPHER_THEME_BUNDLE_URL' ) ) {
    define( 'EXPERT_PHOTOGRAPHER_THEME_BUNDLE_URL', 'https://www.seothemesexpert.com/products/wordpress-theme-bundle' );
}

/**
 * Add theme page
 */
function expert_photographer_menu() {
	add_theme_page( esc_html__( 'About Theme', 'expert-photographer' ), esc_html__( 'About Theme', 'expert-photographer' ), 'edit_theme_options', 'expert-photographer-about', 'expert_photographer_about_display' );
}
add_action( 'admin_menu', 'expert_photographer_menu' );

/**
 * Display About page
 */
function expert_photographer_about_display() { ?>
	<div class="wrap about-wrap full-width-layout">
		<h1 class="d-none"></h1>
		<nav class="nav-tab-wrapper wp-clearfix" aria-label="<?php esc_attr_e( 'Secondary menu', 'expert-photographer' ); ?>">
			<a href="<?php echo esc_url( admin_url( add_query_arg( array( 'page' => 'expert-photographer-about' ), 'themes.php' ) ) ); ?>" class="nav-tab<?php echo ( isset( $_GET['page'] ) && 'expert-photographer-about' === $_GET['page'] && ! isset( $_GET['tab'] ) ) ?' nav-tab-active' : ''; ?>"><?php esc_html_e( 'About', 'expert-photographer' ); ?></a>

			<a href="<?php echo esc_url( admin_url( add_query_arg( array( 'page' => 'expert-photographer-about', 'tab' => 'free_vs_pro' ), 'themes.php' ) ) ); ?>" class="nav-tab<?php echo ( isset( $_GET['tab'] ) && 'free_vs_pro' === $_GET['tab'] ) ?' nav-tab-active' : ''; ?>"><?php esc_html_e( 'Compare free Vs Pro', 'expert-photographer' ); ?></a>
		</nav>

		<?php
			expert_photographer_main_screen();

			expert_photographer_free_vs_pro();
		?>

		<div class="return-to-dashboard">
			<?php if ( current_user_can( 'update_core' ) && isset( $_GET['updated'] ) ) : ?>
				<a href="<?php echo esc_url( self_admin_url( 'update-core.php' ) ); ?>" target="_blank">
					<?php is_multisite() ? esc_html_e( 'Return to Updates', 'expert-photographer' ) : esc_html_e( 'Return to Dashboard &rarr; Updates', 'expert-photographer' ); ?>
				</a> |
			<?php endif; ?>
			<a href="<?php echo esc_url( self_admin_url() ); ?>" target="_blank"><?php is_blog_admin() ? esc_html_e( 'Go to Dashboard &rarr; Home', 'expert-photographer' ) : esc_html_e( 'Go to Dashboard', 'expert-photographer' ); ?></a>
		</div>
	</div>
	<?php
}

/**
 * Output the main about screen.
 */
function expert_photographer_main_screen() {
	if ( isset( $_GET['page'] ) && 'expert-photographer-about' === $_GET['page'] && ! isset( $_GET['tab'] ) ) {
	?>
		<div class="main-col-box">
			<div class="feature-section two-col">
				<div class="card">
					<h2 class="title"><?php esc_html_e( 'Upgrade To Pro', 'expert-photographer' ); ?></h2>
					<p><?php esc_html_e( 'Take a step towards excellence, try our premium theme. Use Code', 'expert-photographer' ) ?><span class="usecode"><?php esc_html_e('" STEPRO10 "', 'expert-photographer'); ?></span></p>
					<p><a href="<?php echo esc_url( EXPERT_PHOTOGRAPHER_PRO_THEME_URL ); ?>" class="button button-primary" target="_blank"><?php esc_html_e( 'Upgrade Pro', 'expert-photographer' ); ?></a></p>
				</div>

				<div class="card">
					<h2 class="title"><?php esc_html_e( 'Lite Documentation', 'expert-photographer' ); ?></h2>
					<p><?php esc_html_e( 'The free theme documentation can help you set up the theme.', 'expert-photographer' ) ?></p>
					<p><a href="<?php echo esc_url( EXPERT_PHOTOGRAPHER_FREE_DOC_URL ); ?>" class="button button-primary" target="_blank"><?php esc_html_e( 'Lite Documentation', 'expert-photographer' ); ?></a></p>
				</div>

				<div class="card">
					<h2 class="title"><?php esc_html_e( 'Theme Info', 'expert-photographer' ); ?></h2>
					<p><?php esc_html_e( 'Know more about Expert Photographer.', 'expert-photographer' ) ?></p>
					<p><a href="<?php echo esc_url( EXPERT_PHOTOGRAPHER_FREE_THEME_URL ); ?>" class="button button-primary" target="_blank"><?php esc_html_e( 'Theme Info', 'expert-photographer' ); ?></a></p>
				</div>

				<div class="card">
					<h2 class="title"><?php esc_html_e( 'Theme Customizer', 'expert-photographer' ); ?></h2>
					<p><?php esc_html_e( 'You can get all theme options in customizer.', 'expert-photographer' ) ?></p>
					<p><a href="<?php echo esc_url( admin_url( 'customize.php' ) ); ?>" class="button button-primary" target="_blank"><?php esc_html_e( 'Customize', 'expert-photographer' ); ?></a></p>
				</div>

				<div class="card">
					<h2 class="title"><?php esc_html_e( 'Need Support?', 'expert-photographer' ); ?></h2>
					<p><?php esc_html_e( 'If you are having some issues with the theme or you want to tweak some thing, you can contact us our expert team will help you.', 'expert-photographer' ) ?></p>
					<p><a href="<?php echo esc_url( EXPERT_PHOTOGRAPHER_SUPPORT_THEME_URL ); ?>" class="button button-primary" target="_blank"><?php esc_html_e( 'Support Forum', 'expert-photographer' ); ?></a></p>
				</div>

				<div class="card">
					<h2 class="title"><?php esc_html_e( 'Review', 'expert-photographer' ); ?></h2>
					<p><?php esc_html_e( 'If you have loved our theme please show your support with the review.', 'expert-photographer' ) ?></p>
					<p><a href="<?php echo esc_url( EXPERT_PHOTOGRAPHER_RATE_THEME_URL ); ?>" class="button button-primary" target="_blank"><?php esc_html_e( 'Rate Us', 'expert-photographer' ); ?></a></p>
				</div>		
			</div>
			<div class="about-theme">
				<?php $expert_photographer_theme = wp_get_theme(); ?>

				<h1><?php echo esc_html( $expert_photographer_theme ); ?></h1>
				<p class="version"><?php esc_html_e( 'Version', 'expert-photographer' ); ?>: <?php echo esc_html($expert_photographer_theme['Version']);?></p>
				<div class="theme-description">
					<p class="actions">
						<a href="<?php echo esc_url( EXPERT_PHOTOGRAPHER_PRO_THEME_URL ); ?>" class="protheme button button-secondary" target="_blank"><?php esc_html_e( 'Upgrade to pro', 'expert-photographer' ); ?></a>

						<a href="<?php echo esc_url( EXPERT_PHOTOGRAPHER_DEMO_THEME_URL ); ?>" class="demo button button-secondary" target="_blank"><?php esc_html_e( 'View Demo', 'expert-photographer' ); ?></a>

						<a href="<?php echo esc_url( EXPERT_PHOTOGRAPHER_THEME_BUNDLE_URL ); ?>" class="bundle button button-secondary" target="_blank"><?php esc_html_e( 'Buy All Themes', 'expert-photographer' ); ?></a>

						<a href="<?php echo esc_url( EXPERT_PHOTOGRAPHER_DOCS_THEME_URL ); ?>" class="docs button button-secondary" target="_blank"><?php esc_html_e( 'Theme Instructions', 'expert-photographer' ); ?></a>
					</p>
				</div>
				<div class="theme-screenshot">
					<img src="<?php echo esc_url( $expert_photographer_theme->get_screenshot() ); ?>" />
				</div>
			</div>
		</div>
	<?php
	}
}

/**
 * Import Demo data for theme using catch themes demo import plugin
 */
function expert_photographer_free_vs_pro() {
	if ( isset( $_GET['tab'] ) && 'free_vs_pro' === $_GET['tab'] ) {
	?>
		<div class="wrap about-wrap">

			<div class="theme-description">
				<p class="actions">
					<a href="<?php echo esc_url( EXPERT_PHOTOGRAPHER_PRO_THEME_URL ); ?>" class="protheme button button-secondary" target="_blank"><?php esc_html_e( 'Upgrade to pro', 'expert-photographer' ); ?></a>

					<a href="<?php echo esc_url( EXPERT_PHOTOGRAPHER_DEMO_THEME_URL ); ?>" class="demo button button-secondary" target="_blank"><?php esc_html_e( 'View Demo', 'expert-photographer' ); ?></a>

					<a href="<?php echo esc_url( EXPERT_PHOTOGRAPHER_THEME_BUNDLE_URL ); ?>" class="bundle button button-secondary" target="_blank"><?php esc_html_e( 'Buy All Themes', 'expert-photographer' ); ?></a>

					<a href="<?php echo esc_url( EXPERT_PHOTOGRAPHER_DOCS_THEME_URL ); ?>" class="docs button button-secondary" target="_blank"><?php esc_html_e( 'Theme Instructions', 'expert-photographer' ); ?></a>
				</p>
			</div>
			<p class="about-description"><?php esc_html_e( 'View Free vs Pro Table below:', 'expert-photographer' ); ?></p>
			<div class="vs-theme-table">
				<table>
					<thead>
						<tr><th scope="col"></th>
							<th class="head" scope="col"><?php esc_html_e( 'Free Theme', 'expert-photographer' ); ?></th>
							<th class="head" scope="col"><?php esc_html_e( 'Pro Theme', 'expert-photographer' ); ?></th>
						</tr>
					</thead>
					<tbody>
						<tr class="odd" scope="row">
							<td headers="features" class="feature"><span><?php esc_html_e( 'One click demo import', 'expert-photographer' ); ?></span></td>
							<td><span class="dashicons dashicons-no-alt"></span></td>
							<td><span class="dashicons dashicons-saved"></span></td>
						</tr>
						<tr class="odd" scope="row">
							<td headers="features" class="feature"><?php esc_html_e( 'Color pallete and font options', 'expert-photographer' ); ?></td>
							<td><span class="dashicons dashicons-no-alt"></span></td>
							<td><span class="dashicons dashicons-saved"></span></td>
						</tr>
						<tr class="odd" scope="row">
							<td headers="features" class="feature"><?php esc_html_e( 'Demo Content has 8 to 10 sections', 'expert-photographer' ); ?></td>
							<td><span class="dashicons dashicons-no-alt"></span></td>
							<td><span class="dashicons dashicons-saved"></span></td>
						</tr>
						<tr class="odd" scope="row">
							<td headers="features" class="feature"><?php esc_html_e( 'Rearrange sections as per your need', 'expert-photographer' ); ?></td>
							<td><span class="dashicons dashicons-no-alt"></span></td>
							<td><span class="dashicons dashicons-saved"></span></td>
						</tr>
						<tr class="odd" scope="row">
							<td headers="features" class="feature"><?php esc_html_e( 'Internal Pages', 'expert-photographer' ); ?></td>
							<td><span class="dashicons dashicons-no-alt"></span></td>
							<td><span class="dashicons dashicons-saved"></span></td>
						</tr>
						<tr class="odd" scope="row">
							<td headers="features" class="feature"><?php esc_html_e( 'Plugin Integration', 'expert-photographer' ); ?></td>
							<td><span class="dashicons dashicons-no-alt"></span></td>
							<td><span class="dashicons dashicons-saved"></span></td>
						</tr>
						<tr class="odd" scope="row">
							<td headers="features" class="feature"><?php esc_html_e( 'Ultimate technical support', 'expert-photographer' ); ?></td>
							<td><span class="dashicons dashicons-no-alt"></span></td>
							<td><span class="dashicons dashicons-saved"></span></td>
						</tr>
						<tr class="odd" scope="row">
							<td headers="features" class="feature"><?php esc_html_e( 'Access our Support Forums', 'expert-photographer' ); ?></td>
							<td><span class="dashicons dashicons-no-alt"></span></td>
							<td><span class="dashicons dashicons-saved"></span></td>
						</tr>
						<tr class="odd" scope="row">
							<td headers="features" class="feature"><?php esc_html_e( 'Get regular updates', 'expert-photographer' ); ?></td>
							<td><span class="dashicons dashicons-no-alt"></span></td>
							<td><span class="dashicons dashicons-saved"></span></td>
						</tr>
						<tr class="odd" scope="row">
							<td headers="features" class="feature"><?php esc_html_e( 'Install theme on unlimited domains', 'expert-photographer' ); ?></td>
							<td><span class="dashicons dashicons-saved"></span></td>
							<td><span class="dashicons dashicons-saved"></span></td>
						</tr>
						<tr class="odd" scope="row">
							<td headers="features" class="feature"><?php esc_html_e( 'Mobile Responsive', 'expert-photographer' ); ?></td>
							<td><span class="dashicons dashicons-saved"></span></td>
							<td><span class="dashicons dashicons-saved"></span></td>
						</tr>
						<tr class="odd" scope="row">
							<td headers="features" class="feature"><?php esc_html_e( 'Easy Customization', 'expert-photographer' ); ?></td>
							<td><span class="dashicons dashicons-saved"></span></td>
							<td><span class="dashicons dashicons-saved"></span></td>
						</tr>
						<tr class="odd" scope="row">
							<td class="feature feature--empty"></td>
							<td class="feature feature--empty"></td>
							<td headers="comp-2" class="td-btn-2"><a target="_blank" class="sidebar-button single-btn protheme button button-secondary" href="<?php echo esc_url(EXPERT_PHOTOGRAPHER_PRO_THEME_URL);?>" target="_blank"><?php esc_html_e( 'Go for Premium', 'expert-photographer' ); ?></a></td>
						</tr>
					</tbody>
				</table>
			</div>
		</div>
	<?php
	}
}