<?php
/**
 * The template for displaying archive pages.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Expert Photographer
 */

get_header(); ?>

<section class="blog-area inarea-blog-2-column-area three">
	<div class="container">
		<div class="row">
			<?php 
	            $expert_photographer_archive_sidebar_setting = get_theme_mod('expert_photographer_archive_sidebar_setting','1');
	            $expert_photographer_sidebar_position = get_theme_mod('expert_photographer_sidebar_position', 'right');
	            $expert_photographer_content_class = ($expert_photographer_archive_sidebar_setting == '') ? 'col-lg-12' : 'col-lg-8';

	            // Set classes for left or right sidebar
	            $expert_photographer_content_order_class = ($expert_photographer_sidebar_position == 'left') ? 'order-lg-2' : '';
	            $expert_photographer_sidebar_order_class = ($expert_photographer_sidebar_position == 'left') ? 'order-lg-1' : '';
            ?>
            <div class="<?php echo esc_attr($expert_photographer_content_class . ' ' . $expert_photographer_content_order_class); ?>">
				<?php if( have_posts() ): ?>
					<?php while( have_posts() ) : the_post(); ?>
						<?php get_template_part('template-parts/content/content-post', get_post_format() ); ?>
					<?php endwhile; ?>
				<?php else: ?>
					<?php get_template_part('template-parts/content/content','none'); ?>
				<?php endif; ?>
			</div>
			<?php if( $expert_photographer_archive_sidebar_setting != '') { ?> 
                <?php get_sidebar(); ?>
            <?php } ?>
		</div>
	</div>
</section>

<?php get_footer(); ?>