<?php if ( get_theme_mod( 'expert_nurses_show_hide_sec', false ) ) : ?>
  <section id="service-sec" class="py-5 px-md-0 px-3">
    <div class="container">
      <div class="text-center">
        <?php
        // Short heading
        $expert_nurses_short_heading = get_theme_mod( 'expert_nurses_serv_short_heading', '' );
        if ( $expert_nurses_short_heading ) :
          ?>
          <p class="serv-short d-inline-block text-capitalize my-0 mb-2">
            <?php echo esc_html( $expert_nurses_short_heading ); ?>
          </p>
        <?php endif; ?>
        <?php
        $expert_nurses_section_title = get_theme_mod( 'expert_nurses_featured_section_title', '' );
        if ( $expert_nurses_section_title ) :
          ?>
          <h2 class="mb-lg-5 mb-4 text-capitalize">
            <?php echo esc_html( $expert_nurses_section_title ); ?>
          </h2>
        <?php endif; ?>
      </div>
      <?php
      $expert_nurses_category_slug   = get_theme_mod( 'expert_nurses_featured_section_category');
      $expert_nurses_posts_per_page  = absint( get_theme_mod( 'expert_nurses_num_posts', 3 ) );
      $query = new WP_Query( array(
        'category_name'  => sanitize_title( $expert_nurses_category_slug ),
        'posts_per_page' => $expert_nurses_posts_per_page,
      ) );
      if ( $query->have_posts() ) : ?>
        <div class="services-carousel owl-carousel">
          <?php
          $expert_nurses_i = 1; // ← index to match the Customizer “team role” fields
          while ( $query->have_posts() ) : $query->the_post();
            ?>
            <div class="item wow fadeInUp" data-wow-delay="0.5s">
              <div class="cat-inner-box">
                <?php if ( has_post_thumbnail() ) : ?>
                  <?php the_post_thumbnail( 'full', array(
                    'alt' => esc_attr( get_the_title() ),
                  ) ); ?>
                <?php else : ?>
                  <img src="<?php echo esc_url( get_stylesheet_directory_uri() . '/assets/images/doctor.png' ); ?>" 
                       alt="<?php echo esc_attr( get_the_title() ); ?>" />
                <?php endif; ?>
                <div class="inner-content px-3 py-4 text-center">
                  <h3 class="mb-2">
                    <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                  </h3>
                  <?php
                  $expert_nurses_team_role = get_theme_mod( 'expert_nurses_team_role' . $expert_nurses_i, '' );
                  if ( $expert_nurses_team_role ) :
                    ?>
                    <p class="team-role"><?php echo esc_html( $expert_nurses_team_role ); ?></p>
                  <?php endif; ?>
                </div>
              </div>
            </div>
            <?php
            $expert_nurses_i++; 
          endwhile;
          wp_reset_postdata();
          ?>
        </div>
      <?php endif; ?>
    </div>
  </section>
<?php endif; ?>