<?php $expert_dental_specialist_topbar = get_theme_mod('expert_dental_specialist_topbar', true);
?>
<?php if (!empty($expert_dental_specialist_topbar)) { ?>
    <div class="top-header py-2 wow fadeInDown">
        <div class="container">
            <div class="top-right">
                 <div class="timing">
                    <?php if (get_theme_mod('expert_dental_specialist_time','Monday - Friday: 08:00 - 22:00')) : ?>
                        <p class="mb-md-0 mb-2 contact-content">
                            <i class="far fa-clock me-2"></i><?php echo esc_html(get_theme_mod('expert_dental_specialist_time','Monday - Friday: 08:00 - 22:00')); ?>
                        </p>
                    <?php endif; ?>
                </div>
                <div class="contact call ms-lg-5 ms-md-4">
                    <?php if (get_theme_mod('expert_dental_specialist_call','Class U: 1234 5678 910')) : ?>
                        <div class="text-md-end contact-col call">
                            <p class="mb-0 contact-content call">
                              <a href="tel:<?php echo esc_attr(get_theme_mod('expert_dental_specialist_call','Class U: 1234 5678 910')); ?>">
                                <i class="fas fa-phone me-2"></i><?php
                                  echo esc_html__('Call us:', 'expert-nurses') . ' ' . esc_html(get_theme_mod('expert_dental_specialist_call','Class U: 1234 5678 910'));
                                ?>
                              </a>
                            </p>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<div class="headerbox my-2">
    <div class="container header-main">
        <div class="row m-0">
            <div class="col-lg-3 col-md-5 col-12 logo-col align-self-center">
                <div class="logo text-center text-md-start">
                    <?php
                        if (has_custom_logo()) {
                            the_custom_logo();
                        } else {
                            $expert_dental_specialist_site_title = get_theme_mod('expert_dental_specialist_site_title_setting', 1);
                            if ($expert_dental_specialist_site_title == '1') {
                                if (is_front_page() && is_home()) { ?>
                                    <h1 class="site-title">
                                        <a href="<?php echo esc_url(home_url('/')); ?>">
                                            <?php bloginfo('name'); ?>
                                        </a>
                                    </h1>
                                <?php } else { ?>
                                    <p class="site-title">
                                        <a href="<?php echo esc_url(home_url('/')); ?>">
                                            <?php bloginfo('name'); ?>
                                        </a>
                                    </p>
                                <?php }
                            }
                            $expert_dental_specialist_tagline = get_theme_mod('expert_dental_specialist_tagline_setting');
                            if ($expert_dental_specialist_tagline) {
                                $expert_dental_specialist_site_desc = get_bloginfo('description'); ?>
                                <p class="site-description"><?php echo esc_html($expert_dental_specialist_site_desc); ?></p>
                            <?php }
                        }
                    ?>
                </div>
            </div>
            <div class="col-lg-7 col-md-3 col-12 align-self-center">
                <!-- Main menu -->
                <div class="innermenubox navbar-menubar responsive-menu navigation_header">
                    <div class="toggle-nav mobile-menu">
                        <button onclick="expert_dental_specialist_openNav()">
                            <i class="fa-solid fa-bars"></i> <!-- Initial hamburger icon -->
                        </button>
                    </div>
                    <div id="mySidenav" class="nav sidenav">
                        <nav id="site-navigation" class="main-navigation navbar navbar-expand-xl" aria-label="<?php esc_attr_e( 'Top Menu', 'expert-nurses' ); ?>">

                            <?php 
                                wp_nav_menu(
                                    array(
                                        'theme_location' => 'primary',
                                        'container_class' => 'main-menu clearfix',
                                        'menu_class' => 'clearfix menu',
                                        'items_wrap' => '<ul id="%1$s" class="%2$s mobile_nav">%3$s</ul>',
                                        'fallback_cb' => 'wp_page_menu',
                                    )
                                );
                            ?>
                            <a href="javascript:void(0)" class="closebtn mobile-menu" onclick="expert_dental_specialist_closeNav()">
                                <i class="fa-solid fa-times"></i> <!-- Close icon for the menu -->
                            </a>
                        </nav>
                    </div>
                </div>
            </div>
            <div class="col-lg-2 col-md-4 align-self-center mb-md-0 mb-3">
                <?php
                $expert_dental_specialist_like_option = get_theme_mod('expert_dental_specialist_like_option');
                ?>
                <div class="header-details">
                    <span class="search-bar my-md-0 my-3 me-3">
                        <button type="button" class="open-search" aria-label="<?php esc_attr_e('Open Search', 'expert-nurses'); ?>">
                            <i class="fas fa-search"></i>
                        </button>
                    </span>
                    <p class="mb-0">
                        <?php if (class_exists('woocommerce')): ?> 
                            <span class="product-cart text-center position-relative pe-2">
                                <a href="<?php echo esc_url(wc_get_cart_url()); ?>" title="<?php esc_attr_e('Shopping cart', 'expert-nurses'); ?>">
                                    <i class="fas fa-shopping-cart me-3"></i>
                                    <?php 
                                    $expert_dental_specialist_cart_count = WC()->cart->get_cart_contents_count(); 
                                    if ($expert_dental_specialist_cart_count > 0): ?>
                                        <span class="cart-count"><?php echo esc_html($expert_dental_specialist_cart_count); ?></span>
                                    <?php endif; ?>
                                </a>
                            </span>
                        <?php endif; ?>
                    </p>
                     <?php if (!empty($expert_dental_specialist_like_option)): ?>
                        <p class="mb-0">
                            <a href="<?php echo esc_url($expert_dental_specialist_like_option); ?>">
                                <i class="far fa-heart me-3"></i>
                            </a>
                        </p>
                    <?php endif; ?>

                    <p class="mb-0">
                        <?php if (class_exists('YITH_WCWL')): ?>
                            <a href="<?php echo esc_url(YITH_WCWL()->get_wishlist_url()); ?>">
                                <i class="far fa-heart"></i>
                            </a>
                        <?php endif; ?>
                    </p>
                </div>
            </div>
            <!-- Search Overlay -->
            <div class="search-outer">
                <div class="inner_searchbox w-100 h-100">
                    <?php get_search_form(); ?>
                </div>
                <button type="button" class="search-close"><?php esc_html_e('X', 'expert-nurses'); ?></button>
            </div>
        </div>
    </div>
</div>