<?php

// Enqueue styles and scripts
add_action('wp_enqueue_scripts', 'expert_nurses_my_theme_enqueue_styles');
function expert_nurses_my_theme_enqueue_styles() {
    $expert_nurses_parent_style = 'expert-dental-specialist-main'; // Style handle of parent theme
    wp_enqueue_style($expert_nurses_parent_style, get_template_directory_uri() . '/assets/css/main.css');
    wp_enqueue_style('expert-nurses-style', get_stylesheet_uri(), array($expert_nurses_parent_style));
}

add_action('wp_enqueue_scripts', 'expert_nurses_script');
function expert_nurses_script() {
    $expert_nurses_parent_script_handle = 'expert-dental-specialist-theme-js'; // Script handle of parent theme
    wp_enqueue_script($expert_nurses_parent_script_handle, get_theme_file_uri('/assets/js/theme.js'), array(), null, true);
}

// Theme setup
if (!function_exists('expert_nurses_setup')) :
    function expert_nurses_setup() {
        add_theme_support('automatic-feed-links');
        add_theme_support('title-tag');
        add_theme_support('custom-header');
        add_theme_support('responsive-embeds');
        add_theme_support('post-thumbnails');
        add_theme_support('align-wide');
        load_theme_textdomain( 'expert-nurses', get_template_directory() . '/languages' );
        add_editor_style(array('assets/css/editor-style.css'));
        add_theme_support('custom-background', apply_filters('expert_nurses_custom_background_args', array(
            'default-color' => 'ffffff',
            'default-image' => '',
        )));

        if ( ! defined( 'EXPERT_NURSES_DEMO_IMPORT_URL' ) ) {
            define( 'EXPERT_NURSES_DEMO_IMPORT_URL', esc_url( admin_url( 'themes.php?page=expertnurses-wizard' ) ) );
        }
        if ( ! defined( 'EXPERT_NURSES_WELCOME_MESSAGE' ) ) {
            define( 'EXPERT_NURSES_WELCOME_MESSAGE', __( 'Welcome! Thank you for choosing Expert Nurses', 'expert-nurses' ) );
        }


        // Define constants for URLs
        if (!defined('EXPERT_DENTAL_SPECIALIST_PREMIUM')) {
            define('EXPERT_DENTAL_SPECIALIST_PREMIUM', 'https://www.seothemesexpert.com/products/nurses-website-template');
        }
        if (!defined('EXPERT_DENTAL_SPECIALIST_FREE_THEME_URL')) {
            define('EXPERT_DENTAL_SPECIALIST_FREE_THEME_URL', 'https://www.seothemesexpert.com/products/expert-nurses-theme');
        }
        if (!defined('EXPERT_DENTAL_SPECIALIST_PRO_THEME_URL')) {
            define('EXPERT_DENTAL_SPECIALIST_PRO_THEME_URL', 'https://www.seothemesexpert.com/products/nurses-website-template');
        }
        if (!defined('EXPERT_DENTAL_SPECIALIST_DEMO_THEME_URL')) {
            define('EXPERT_DENTAL_SPECIALIST_DEMO_THEME_URL', 'https://demo.seothemesexpert.com/expert-nurses/');
        }
        if (!defined('EXPERT_DENTAL_SPECIALIST_FREE_DOCS_THEME_URL')) {
            define('EXPERT_DENTAL_SPECIALIST_FREE_DOCS_THEME_URL', 'https://demo.seothemesexpert.com/documentation/expert-nurses/');
        }
        if (!defined('EXPERT_DENTAL_SPECIALIST_RATE_THEME_URL')) {
            define('EXPERT_DENTAL_SPECIALIST_RATE_THEME_URL', 'https://wordpress.org/support/theme/expert-nurses/reviews/#new-post');
        }
        if (!defined('EXPERT_DENTAL_SPECIALIST_SUPPORT_THEME_URL')) {
            define('EXPERT_DENTAL_SPECIALIST_SUPPORT_THEME_URL', 'https://wordpress.org/support/theme/expert-nurses/');
        }
          if ( ! defined( 'EXPERT_DENTAL_SPECIALIST_DEMO_IMPORT_URL' ) ) {
            define( 'EXPERT_DENTAL_SPECIALIST_DEMO_IMPORT_URL', esc_url( admin_url( 'themes.php?page=expertnurses-wizard' ) ) );
        }

    }
endif;
add_action('after_setup_theme', 'expert_nurses_setup');

// Set content width
function expert_nurses_content_width() {
    $GLOBALS['content_width'] = apply_filters('expert_nurses_content_width', 1170);
}
add_action('after_setup_theme', 'expert_nurses_content_width', 0);

// Register widget areas
function expert_nurses_widgets_init() {
    register_sidebar(array(
        'name' => __('Sidebar Widget Area', 'expert-nurses'),
        'id' => 'expert-dental-specialist-sidebar-primary',
        'description' => __('The Primary Widget Area', 'expert-nurses'),
        'before_widget' => '<aside id="%1$s" class="widget %2$s wow fadeInUp">',
        'after_widget' => '</aside>',
        'before_title' => '<h4 class="widget-title">',
        'after_title' => '</h4><div class="title"><span class="shap"></span></div>',
    ));
    register_sidebar( array(
        'name' => __( 'Footer Widget Area', 'expert-nurses' ),
        'id' => 'expert-dental-specialist-footer-widget-area',
        'description' => __( 'The Footer Widget Area', 'expert-nurses' ),
        'before_widget' => '<div class="footer-widget col-lg-3 col-sm-6 wow fadeIn" data-wow-delay="0.5s"><aside id="%1$s" class="widget %2$s">',
        'after_widget' => '</aside></div>',
        'before_title' => '<h5 class="widget-title w-title">',
        'after_title' => '</h5><span class="shap"></span>',
    ) );
}
add_action('widgets_init', 'expert_nurses_widgets_init');

// Remove customizer settings
function expert_nurses_remove_custom($wp_customize) {

    $wp_customize->remove_setting('expert_dental_specialist_message_text');
    $wp_customize->remove_control('expert_dental_specialist_message_text');

    $wp_customize->remove_section('expert_dental_specialist_our_products_section');
    $wp_customize->remove_section('expert_dental_specialist_dynamic_color_settings');

}
add_action('customize_register', 'expert_nurses_remove_custom', 1000);

function expert_nurses_child_customize_register( $wp_customize ) {

    // Service Section Settings
    $wp_customize->add_section('expert_nurses_service_section', array(
      'title' => __('Our Doctors Section', 'expert-nurses'),
      'panel' => 'expert_dental_specialist_frontpage_sections',
      'priority' => 14,
    ));

    // About Us Hide/ Show Setting // 
    $wp_customize->add_setting( 
        'expert_nurses_show_hide_sec' , 
            array(
            'default' => false,
            'sanitize_callback' => 'expert_dental_specialist_sanitize_checkbox',
            'capability' => 'edit_theme_options',
            'priority' => 2,
        ) 
    );
    $wp_customize->add_control(
    'expert_nurses_show_hide_sec', 
        array(
            'label'       => esc_html__( 'Show / Hide Service Section', 'expert-nurses' ),
            'section'     => 'expert_nurses_service_section',
            'settings'    => 'expert_nurses_show_hide_sec',
            'type'        => 'checkbox'
        ) 
    );

    $wp_customize->add_setting('expert_nurses_serv_short_heading',array(
        'default'=> '',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control('expert_nurses_serv_short_heading',array(
        'label' => __('Add short Heading','expert-nurses'),
        'section'=> 'expert_nurses_service_section',
        'type'=> 'text'
    ));
    
    $wp_customize->add_setting('expert_nurses_featured_section_title', array(
      'default' => '',
      'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control('expert_nurses_featured_section_title', array(
      'label' => __('Add Heading', 'expert-nurses'),
      'section' => 'expert_nurses_service_section',
      'type' => 'text'
    ));

    $expert_nurses_categories = get_categories();
    $cats = array();
    $expert_nurses_i = 0;
    $expert_nurses_offer_cat[] = 'select';
    foreach ($expert_nurses_categories as $expert_nurses_category) {
      if ($expert_nurses_i == 0) {
        $expert_nurses_default = $expert_nurses_category->slug;
        $expert_nurses_i++;
      }
      $expert_nurses_offer_cat[$expert_nurses_category->slug] = $expert_nurses_category->name;
    }

    $wp_customize->add_setting('expert_nurses_featured_section_category', array(
      'default' => '',
      'sanitize_callback' => 'expert_dental_specialist_sanitize_choices',
    ));
    $wp_customize->add_control('expert_nurses_featured_section_category', array(
      'type' => 'select',
      'choices' => $expert_nurses_offer_cat,
      'label' => __('Select Category', 'expert-nurses'),
      'section' => 'expert_nurses_service_section',
    ));

    $wp_customize->add_setting('expert_nurses_num_posts', array(
      'default' => 3,
      'sanitize_callback' => 'absint',
    ));
    $wp_customize->add_control('expert_nurses_num_posts', array(
      'label' => __('Number of Posts to Show', 'expert-nurses'),
      'section' => 'expert_nurses_service_section',
      'type' => 'number',
    ));

    // Get the number of posts to show
    $expert_nurses_posts_to_show = get_theme_mod('expert_nurses_posts_to_show', 3);
    
    // Loop to create settings and controls for each post's price and star rating
    for ($expert_nurses_i = 1; $expert_nurses_i <= $expert_nurses_posts_to_show; $expert_nurses_i++) {

        $wp_customize->add_setting('expert_nurses_team_role' . $expert_nurses_i, array(
            'default' => '',
            'sanitize_callback' => 'sanitize_text_field'
        ));
        $wp_customize->add_control('expert_nurses_team_role' . $expert_nurses_i, array(
            'label'    => __( 'Add Doctor Speciality ', 'expert-nurses') . $expert_nurses_i,
            'section'  => 'expert_nurses_service_section',
            'type'     => 'text',
        ));
    }

    $wp_customize->add_setting( 'expert_dental_specialist_upgrade_page_settings_1sf',
	array(
		'sanitize_callback' => 'sanitize_text_field'
		)
	);
	$wp_customize->add_control( new Expert_Dental_Specialist_Control_Upgrade(
		$wp_customize, 'expert_dental_specialist_upgrade_page_settings_1sf',
			array(
				'priority'      => 200,
				'section'       => 'expert_nurses_service_section',
				'settings'      => 'expert_dental_specialist_upgrade_page_settings_1sf',
				'label'         => __( 'Expert Dental Specialist Pro comes with additional features.', 'expert-dental-specialist' ),
				'choices'       => array( __( '15+ Ready-Made Sections', 'expert-dental-specialist' ), __( 'One-Click Demo Import', 'expert-dental-specialist' ), __( 'WooCommerce Integrated', 'expert-dental-specialist' ), __( 'Drag & Drop Section Reordering', 'expert-dental-specialist' ),__( 'Advanced Typography Control', 'expert-dental-specialist' ),__( 'Intuitive Customization Options', 'expert-dental-specialist' ),__( '24/7 Support', 'expert-dental-specialist' ), )
			)
		)
	); 




    $wp_customize->add_section(
    'expert_nurses_dynamic_color_settings', array(
        'title' => esc_html__( 'Dynamic Color Options', 'expert-nurses' ),
        'priority' => 1,
        'panel' => 'expert_dental_specialist_typography',
        )
    );

    $wp_customize->add_setting('expert_nurses_dynamic_color_one', array(
        'default'           => '#E55368',
        'sanitize_callback' => 'sanitize_hex_color',
    ));
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'expert_nurses_dynamic_color_one', array(
        'label'    => __('First Dynamic Color', 'expert-nurses'),
        'section'  => 'expert_nurses_dynamic_color_settings',
    )));

    $wp_customize->add_setting('expert_nurses_dynamic_color_two', array(
        'default'           => '#141D4F',
        'sanitize_callback' => 'sanitize_hex_color',
    ));
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'expert_nurses_dynamic_color_two', array(
        'label'    => __('Second Dynamic Color', 'expert-nurses'),
        'section'  => 'expert_nurses_dynamic_color_settings',
    )));

    $wp_customize->add_setting( 'expert_nurses_upgrade_page_settings_20_color',
        array(
            'sanitize_callback' => 'sanitize_text_field'
        )
    );
    $wp_customize->add_control( new Expert_Dental_Specialist_Control_Upgrade(
        $wp_customize, 'expert_nurses_upgrade_page_settings_20_color',
            array(
                'priority'      => 200,
                'section'       => 'expert_nurses_dynamic_color_settings',
                'settings'      => 'expert_nurses_upgrade_page_settings_20_color',
                'label'         => __( 'Expert Dental Specialist Pro comes with additional features.', 'expert-nurses' ),
                'choices'       => array( __( '15+ Ready-Made Sections', 'expert-nurses' ), __( 'One-Click Demo Import', 'expert-nurses' ), __( 'WooCommerce Integrated', 'expert-nurses' ), __( 'Drag & Drop Section Reordering', 'expert-nurses' ),__( 'Advanced Typography Control', 'expert-nurses' ),__( 'Intuitive Customization Options', 'expert-nurses' ),__( '24/7 Support', 'expert-nurses' ), )
            )
        )
    );


}
add_action( 'customize_register', 'expert_nurses_child_customize_register', 20 );

function expert_nurses_customize_css() {
    $expert_nurses_dynamic_color_one = get_theme_mod( 'expert_nurses_dynamic_color_one', '#E55368' );
    $expert_nurses_dynamic_color_two = get_theme_mod( 'expert_nurses_dynamic_color_two', '#141D4F' );

    $expert_nurses_custom_css = "
        :root {
            --color-primary1: {$expert_nurses_dynamic_color_one} !important;
            --color-primary2: {$expert_nurses_dynamic_color_two} !important;
        }
    ";

    // Add the custom CSS inline to the site
    wp_add_inline_style( 'expert-nurses-style', $expert_nurses_custom_css );
}
add_action( 'wp_enqueue_scripts', 'expert_nurses_customize_css' );