</div>
<?php
    $expert_dental_specialist_footer_bg_color = get_theme_mod('expert_expert_dental_specialist_footer_bg_color');
    $expert_dental_specialist_footer_bg_image = get_theme_mod('expert_expert_dental_specialist_footer_bg_image');
    $expert_dental_specialist_footer_opacity = get_theme_mod('expert_expert_dental_specialist_footer_bg_image_opacity', 50);
    $expert_dental_specialist_opacity_decimal = $expert_dental_specialist_footer_opacity / 100;

    // Compose inline styles for footer background
    $expert_dental_specialist_footer_styles = 'background-color: ' . esc_attr($expert_dental_specialist_footer_bg_color) . ';';
    if ($expert_dental_specialist_footer_bg_image) {
        $expert_dental_specialist_footer_styles .= ' background-image: linear-gradient(rgba(0,0,0,' . (1 - $expert_dental_specialist_opacity_decimal) . '), rgba(0,0,0,' . (1 - $expert_dental_specialist_opacity_decimal) . ')), url(' . esc_url($expert_dental_specialist_footer_bg_image) . ');';
    }
?>
<footer class="footer-area" style="<?php echo esc_attr($expert_dental_specialist_footer_styles); ?>">  
	<div class="container"> 
		<?php 
		$expert_dental_specialist_footer_widgets_setting = get_theme_mod('expert_expert_dental_specialist_footer_widgets_setting', '1');

		do_action('expert_expert_dental_specialist_footer_above'); 
		
		if ($expert_dental_specialist_footer_widgets_setting != '') { 
			if (is_active_sidebar('expert-dental-specialist-footer-widget-area')) { ?>
				<div class="row footer-row"> 
					<?php dynamic_sidebar('expert-dental-specialist-footer-widget-area'); ?>
				</div>  
			<?php 
			} else { ?>
				<div class="row footer-row">
					<div class="footer-widget col-lg-3 col-sm-6 wow fadeIn" data-wow-delay="0.3s">
						<aside id="search-3" class="widget widget_search default_footer_search">
							<h2 class="widget-title w-title"><?php esc_html_e('Search', 'expert-nurses'); ?></h2>
							<?php get_search_form(); ?>
						</aside>
					</div>
					<div class="footer-widget col-lg-3 col-sm-6 wow fadeIn" data-wow-delay="0.5s">
						<aside id="archives-2" class="widget widget_archive">
							<h2 class="widget-title w-title"><?php esc_html_e('Recent Posts', 'expert-nurses'); ?></h2>
							<ul>
								<?php
								wp_get_archives(array(
									'type' => 'postbypost',
									'format' => 'html',
									'limit'  => 5,
								));
								?>
							</ul>
						</aside>
					</div>
					<div class="footer-widget col-lg-3 col-sm-6 wow fadeIn" data-wow-delay="0.7s">
						<aside id="pages-2" class="widget widget_pages">
							<h2 class="widget-title w-title"><?php esc_html_e('Pages', 'expert-nurses'); ?></h2>
							<ul>
								<?php
								wp_list_pages(array(
									'title_li' => '',
									'number'  => 5,
								));
								?>
							</ul>
						</aside>
					</div>
					<div class="footer-widget col-lg-3 col-sm-6 wow fadeIn" data-wow-delay="0.9s">
						<aside id="categories-2" class="widget widget_categories">
							<h2 class="widget-title w-title"><?php esc_html_e('Categories', 'expert-nurses'); ?></h2>
							<ul>
								<?php
								wp_list_categories(array(
									'title_li' => '',
									'number'  => 5,
								));
								?>
							</ul>
						</aside>
					</div>
				</div>
			<?php } 
		} ?>
	</div>

	<?php 
		$expert_expert_dental_specialist_footer_copyright = get_theme_mod('expert_expert_dental_specialist_footer_copyright','');
	?>
	<?php $expert_expert_dental_specialist_footer_copyright_setting = get_theme_mod('expert_expert_dental_specialist_footer_copyright_setting','1');
	 if( $expert_expert_dental_specialist_footer_copyright_setting != ''){?>
		<div class="copy-right wow flipInX" data-wow-delay="0.5s"> 
			<div class="container">
				<p class="copyright-text">	
					<?php
						echo esc_html( apply_filters('expert_expert_dental_specialist_footer_copyright',($expert_expert_dental_specialist_footer_copyright)));
				    ?>
					<?php if ( empty($expert_expert_dental_specialist_footer_copyright) ) { ?>
					    <?php
					        echo esc_html__( 'Copyright &copy; 2025,', 'expert-nurses' );
					    ?>
					    <a href="<?php echo esc_url('https://www.seothemesexpert.com/products/expert-nurses-theme'); ?>" target="_blank">
					        <?php
					            echo esc_html__( 'Expert Nurses', 'expert-nurses' );
					        ?>
					    </a>
					    <span> | </span>

					    <a href="https://wordpress.org/" target="_blank">
					        <?php
					            echo esc_html__( 'WordPress Theme', 'expert-nurses' );
					        ?>
					    </a>
					<?php } ?>
				</p>
			</div>
		</div>
	<?php } ?>
	<?php $expert_expert_dental_specialist_scroll_top = get_theme_mod('expert_expert_dental_specialist_scroll_top_setting','1');
      if($expert_expert_dental_specialist_scroll_top == '1') { ?>
		<a id="scrolltop"><span><?php esc_html_e('TOP','expert-nurses'); ?><span></a>
	<?php } ?>
</footer>
</div>
<?php wp_footer(); ?>
</body>
</html>