<?php
/**
 * Template Name: Custom Home
 */

get_header(); ?>

<main id="content" role="main">
	<?php do_action( 'expert_lawyer_above_slider' ); ?>

	<?php if( get_theme_mod('expert_lawyer_slider_hide_show',false) != false){ ?>
		<?php
		$container_type = get_theme_mod('expert_lawyer_boxfull_width', ''); // Get the selected container type
		// Define the default container class
		$container_class = '';
		
		// If container or container-fluid is selected, update the container class
		if ($container_type === 'container' || $container_type === 'container-fluid') {
			$container_class = $container_type;
		}
		?>
	<div class="<?php echo esc_attr($container_class); ?>">
		<section id="slider">
		  	<div id="carouselExampleIndicators" class="carousel slide" data-ride="carousel"> 
			    <?php $expert_lawyer_slider_pages = array();
			      	for ( $count = 1; $count <= 4; $count++ ) {
				        $mod = intval( get_theme_mod( 'expert_lawyer_slider' . $count ));
				        if ( 'page-none-selected' != $mod ) {
				          	$expert_lawyer_slider_pages[] = $mod;
				        }
			      	}
			      	if( !empty($expert_lawyer_slider_pages) ) :
			        $args = array(
			          	'post_type' => 'page',
			          	'post__in' => $expert_lawyer_slider_pages,
			          	'orderby' => 'post__in'
			        );
			        $query = new WP_Query( $args );
			        if ( $query->have_posts() ) :
			          $i = 1;
			    ?>     
			    <div class="carousel-inner" role="listbox">
			      	<?php  while ( $query->have_posts() ) : $query->the_post(); ?>
			        <div <?php if($i == 1){echo 'class="carousel-item active"';} else{ echo 'class="carousel-item"';}?>>
			          	<?php if ( has_post_thumbnail() ) {
							$thumbnail_url = get_the_post_thumbnail_url( get_the_ID(), 'full' );
							?>
							<img src="<?php echo esc_url( $thumbnail_url ); ?>" alt="<?php the_title_attribute(); ?>" />
						<?php } else { ?>
							<img src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/slider.png' ); ?>" alt="<?php the_title_attribute(); ?>" />
						<?php } ?>
						<?php
							$expert_lawyer_slider_effect = get_theme_mod('expert_lawyer_slider_effect', '') 
						?>
			          	<div class="carousel-caption <?php echo ($expert_lawyer_slider_effect); ?>">
				            <div class="inner_carousel">
				              	<h1><?php the_title();?></h1>
				              	<p><?php $expert_lawyer_excerpt = get_the_excerpt(); echo esc_html( expert_lawyer_string_limit_words( $expert_lawyer_excerpt, esc_attr(get_theme_mod('expert_lawyer_slider_excerpt_length','15') ) )); ?></p>
				            </div>
				            <div class="read-btn">
				              <a href="<?php the_permalink();?>" class="aaaa" title="<?php esc_attr_e( 'READ MORE', 'expert-lawyer' ); ?>"><?php esc_html_e('READ MORE','expert-lawyer'); ?>
				              </a>
					       	</div>
			          	</div>
			        </div>
			      	<?php $i++; endwhile; 
			      	wp_reset_postdata();?>
			    </div>
			    <?php else : ?>
			    <div class="no-postfound"></div>
			      <?php endif;
			    endif;?>
			    <a class="carousel-control-prev" href="#carouselExampleIndicators" role="button" data-slide="prev">
			      <span class="carousel-control-prev-icon" aria-hidden="true"><i class="fas fa-chevron-left"></i></span>
			    </a>
			    <a class="carousel-control-next" href="#carouselExampleIndicators" role="button" data-slide="next">
			      <span class="carousel-control-next-icon" aria-hidden="true"><i class="fas fa-chevron-right"></i></span>
			    </a>
		  	</div>  
		  	<div class="clearfix"></div>
		</section>
	<?php }?>

	<?php do_action('expert_lawyer_below_slider'); ?>
	<?php
		$container_type = get_theme_mod('expert_lawyer_boxfull_width', ''); // Get the selected container type
		// Define the default container class
		$container_class = 'container';
		
		// If container or container-fluid is selected, update the container class
		if ($container_type === 'container' || $container_type === 'container-fluid') {
			$container_class = $container_type;
		}
		?>
	<div class="<?php echo esc_attr($container_class); ?>">
	<?php if( get_theme_mod('expert_lawyer_post') != ''){ ?>
		<section id="about_us">
				<?php
		        $expert_lawyer_postData =  get_theme_mod('expert_lawyer_post');
		        if($expert_lawyer_postData){
		          	$args = array( 'name' => esc_html($expert_lawyer_postData ,'expert-lawyer'));
	          		$query = new WP_Query( $args );
		          	if ( $query->have_posts() ) :
			            while ( $query->have_posts() ) : $query->the_post(); ?>
				            <div class="row m-0">
				            	<div class="col-lg-7 col-md-6">
					                <div class="text-chooseus">
					                    <h2><?php the_title(); ?></h2>
					                    <p><?php the_excerpt(); ?></p>
					                    <div class="more-btn">      
					                      	<a href="<?php the_permalink(); ?>"><?php esc_html_e('More About Us','expert-lawyer'); ?></a>
					                    </div>
					                </div>
				                </div>
				              	<div class="col-lg-5 col-md-6">
				              	<div class="image-box">
				                  	<div class="img-aboutus"><?php if(has_post_thumbnail()) { ?><?php the_post_thumbnail(); ?><?php } ?></div>
				               		</div>
				            	</div>
				            </div>
			            <?php endwhile; 
			            wp_reset_postdata();?>
		            <?php else : ?>
		              <div class="no-postfound"></div>
		            <?php
		        endif;} ?>   
		</section>
	<?php }?> 

	<?php do_action('expert_lawyer_below_about_us_section'); ?>

	<div class="container lz-content">
	  	<?php while ( have_posts() ) : the_post(); ?>
	        <?php the_content(); ?>
	    <?php endwhile; // end of the loop. ?>
	</div>
</main>

<?php get_footer(); ?>