<?php
/**
 * expert-lawyer: Customizer
 *
 * @subpackage expert-lawyer
 * @since 1.0
 */

function expert_lawyer_customize_register( $wp_customize ) {

	$wp_customize->add_setting('expert_lawyer_logo_size',array(
		'sanitize_callback'	=> 'expert_lawyer_sanitize_float'
	));
	$wp_customize->add_control('expert_lawyer_logo_size',array(
		'type' => 'range',
		'label' => __('Logo Size','expert-lawyer'),
		'section' => 'title_tagline'
	));

	$wp_customize->add_setting('expert_lawyer_logo_padding',array(
		'sanitize_callback'	=> 'esc_html'
	));
	$wp_customize->add_control('expert_lawyer_logo_padding',array(
		'label' => __('Logo Padding','expert-lawyer'),
		'section' => 'title_tagline'
	));

	$wp_customize->add_setting('expert_lawyer_logo_top_padding',array(
		'default' => '',
		'sanitize_callback'	=> 'expert_lawyer_sanitize_float'
	));
	$wp_customize->add_control('expert_lawyer_logo_top_padding',array(
		'type' => 'number',
		'description' => __('Top','expert-lawyer'),
		'section' => 'title_tagline',
	));

	$wp_customize->add_setting('expert_lawyer_logo_bottom_padding',array(
		'default' => '',
		'sanitize_callback'	=> 'expert_lawyer_sanitize_float'
	));
	$wp_customize->add_control('expert_lawyer_logo_bottom_padding',array(
		'type' => 'number',
		'description' => __('Bottom','expert-lawyer'),
		'section' => 'title_tagline',
	));

	$wp_customize->add_setting('expert_lawyer_logo_left_padding',array(
		'default' => '',
		'sanitize_callback'	=> 'expert_lawyer_sanitize_float'
	));
	$wp_customize->add_control('expert_lawyer_logo_left_padding',array(
		'type' => 'number',
		'description' => __('Left','expert-lawyer'),
		'section' => 'title_tagline',
	));

	$wp_customize->add_setting('expert_lawyer_logo_right_padding',array(
		'default' => '',
		'sanitize_callback'	=> 'expert_lawyer_sanitize_float'
	));
	$wp_customize->add_control('expert_lawyer_logo_right_padding',array(
		'type' => 'number',
		'description' => __('Right','expert-lawyer'),
		'section' => 'title_tagline',
	));

	$wp_customize->add_setting('expert_lawyer_show_site_title',array(
		'default' => true,
		'sanitize_callback'	=> 'expert_lawyer_sanitize_checkbox'
	));
	$wp_customize->add_control('expert_lawyer_show_site_title',array(
		'type' => 'checkbox',
		'label' => __('Show / Hide Site Title','expert-lawyer'),
		'section' => 'title_tagline'
	));

	$wp_customize->add_setting('expert_lawyer_site_title_fontsize',array(
		'default' => '',
		'sanitize_callback'	=> 'expert_lawyer_sanitize_float'
	));
	$wp_customize->add_control('expert_lawyer_site_title_fontsize',array(
		'type' => 'number',
		'label' => __('Site Title Font Size','expert-lawyer'),
		'section' => 'title_tagline',
	));
	
	$wp_customize->add_setting( 'expert_lawyer_site_title_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'expert_lawyer_site_title_color', array(
		'label' => 'Site Title Color',
		'section' => 'title_tagline',
	)));

	$wp_customize->add_setting('expert_lawyer_show_tagline',array(
		'default' => true,
		'sanitize_callback'	=> 'expert_lawyer_sanitize_checkbox'
	));
	$wp_customize->add_control('expert_lawyer_show_tagline',array(
		'type' => 'checkbox',
		'label' => __('Show / Hide Site Tagline','expert-lawyer'),
		'section' => 'title_tagline'
	));

	$wp_customize->add_setting('expert_lawyer_site_tagline_font_size',array(
		'default' => '',
		'sanitize_callback' => 'expert_lawyer_sanitize_float'
	));
	$wp_customize->add_control('expert_lawyer_site_tagline_font_size',array(
		'type' => 'number',
		'label' => __('Site Tagline Font Size','expert-lawyer'),
		'section' => 'title_tagline',
	));

	$wp_customize->add_setting( 'expert_lawyer_site_tagline_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'expert_lawyer_site_tagline_color', array(
		'label' => 'Site Tagline Color',
		'section' => 'title_tagline',
	)));

	$wp_customize->add_panel( 'expert_lawyer_panel_id', array(
		'priority' => 10,
		'capability' => 'edit_theme_options',
		'theme_supports' => '',
		'title' => __( 'Theme Settings', 'expert-lawyer' ),
	) );

	$wp_customize->add_section( 'expert_lawyer_theme_options_section', array(
    	'title'      => __( 'General Settings', 'expert-lawyer' ),
		'priority'   => 30,
		'panel' => 'expert_lawyer_panel_id'
	) );

	// Add Settings and Controls for Layout
	$wp_customize->add_setting('expert_lawyer_theme_options',array(
		'default' => 'Right Sidebar',
		'sanitize_callback' => 'expert_lawyer_sanitize_choices'	        
	));
	$wp_customize->add_control('expert_lawyer_theme_options',array(
		'type' => 'radio',
		'label' => __('Do you want this section','expert-lawyer'),
		'section' => 'expert_lawyer_theme_options_section',
		'choices' => array(
			'Left Sidebar' => __('Left Sidebar','expert-lawyer'),
			'Right Sidebar' => __('Right Sidebar','expert-lawyer'),
			'One Column' => __('One Column','expert-lawyer'),
			'Three Columns' => __('Three Columns','expert-lawyer'),
			'Four Columns' => __('Four Columns','expert-lawyer'),
			'Grid Layout' => __('Grid Layout','expert-lawyer')
		),
	));

	$wp_customize->add_setting( 'expert_lawyer_boxfull_width', array(
		'default'           => '',
		'sanitize_callback' => 'expert_lawyer_sanitize_choices'
	));
	
	$wp_customize->add_control( 'expert_lawyer_boxfull_width', array(
		'label'    => __( 'Section Width', 'expert-lawyer' ),
		'section'  => 'expert_lawyer_theme_options_section',
		'type'     => 'select',
		'choices'  => array(
			'container'  => __('Box Width', 'expert-lawyer'),
			'container-fluid' => __('Full Width', 'expert-lawyer'),
			'none' => __('None', 'expert-lawyer')
		),
	));

	$wp_customize->add_setting( 'expert_lawyer_dropdown_anim', array(
		'default'           => 'None',
		'sanitize_callback' => 'expert_lawyer_sanitize_choices'
	));
	$wp_customize->add_control( 'expert_lawyer_dropdown_anim', array(
		'label'    => __( 'Menu Dropdown Animations', 'expert-lawyer' ),
		'section'  => 'expert_lawyer_theme_options_section',
		'type'     => 'select',
		'choices'  => array(
			'bounceInUp'  => __('bounceInUp', 'expert-lawyer'),
			'fadeInUp' => __('fadeInUp', 'expert-lawyer'),
			'zoomIn'    => __('zoomIn', 'expert-lawyer'),
			'None'    => __('None', 'expert-lawyer')
		),
	));

	// Top Bar
	$wp_customize->add_section( 'expert_lawyer_contact_details', array(
    	'title'      => __( 'Top Bar', 'expert-lawyer' ),
		'priority'   => null,
		'panel' => 'expert_lawyer_panel_id'
	) );

	$wp_customize->add_setting('expert_lawyer_hide_show_topbar',array(
    	'default' => false,
    	'sanitize_callback'	=> 'expert_lawyer_sanitize_checkbox'
	));
	$wp_customize->add_control('expert_lawyer_hide_show_topbar',array(
   	'type' => 'checkbox',
   	'label' => __('Show / Hide Topbar','expert-lawyer'),
   	'section' => 'expert_lawyer_contact_details',
	));

	$wp_customize->add_setting('expert_lawyer_time',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('expert_lawyer_time',array(
		'label'	=> __('Timing','expert-lawyer'),
		'section'=> 'expert_lawyer_contact_details',
		'setting'=> 'expert_lawyer_time',
		'type'=> 'text'
	));

	$wp_customize->add_setting('expert_lawyer_call',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('expert_lawyer_call',array(
		'label'	=> __('Phone Text','expert-lawyer'),
		'section'=> 'expert_lawyer_contact_details',
		'setting'=> 'expert_lawyer_call',
		'type'=> 'text'
	));

	$wp_customize->add_setting('expert_lawyer_call1',array(
		'default'=> '',
		'sanitize_callback'	=> 'expert_lawyer_sanitize_phone_number'
	));	
	$wp_customize->add_control('expert_lawyer_call1',array(
		'label'	=> __('Phone Number','expert-lawyer'),
		'section'=> 'expert_lawyer_contact_details',
		'setting'=> 'expert_lawyer_call1',
		'type'=> 'text'
	));

	$wp_customize->add_setting('expert_lawyer_mail',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('expert_lawyer_mail',array(
		'label'	=> __('Email Text','expert-lawyer'),
		'section'=> 'expert_lawyer_contact_details',
		'setting'=> 'expert_lawyer_mail',
		'type'=> 'text'
	));	

	$wp_customize->add_setting('expert_lawyer_mail1',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_email'
	));	
	$wp_customize->add_control('expert_lawyer_mail1',array(
		'label'	=> __('Email Address','expert-lawyer'),
		'section'=> 'expert_lawyer_contact_details',
		'setting'=> 'expert_lawyer_mail1',
		'type'=> 'text'
	));	

	$wp_customize->add_setting('expert_lawyer_btn_text',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('expert_lawyer_btn_text',array(
		'label'	=> __('Add Button Text','expert-lawyer'),
		'section'	=> 'expert_lawyer_contact_details',
		'setting'	=> 'expert_lawyer_btn_text',
		'type'	=> 'text'
	));

	$wp_customize->add_setting('expert_lawyer_btn_link',array(
		'default'	=> '',
		'sanitize_callback'	=> 'esc_url_raw'
	));	
	$wp_customize->add_control('expert_lawyer_btn_link',array(
		'label'	=> __('Add Button Link','expert-lawyer'),
		'section'	=> 'expert_lawyer_contact_details',
		'setting'	=> 'expert_lawyer_btn_link',
		'type'	=> 'url'
	));

	$wp_customize->add_setting( 'expert_lawyer_topbaricn_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'expert_lawyer_topbaricn_color', array(
		'label' => 'Topbar Icon Color',
		'section' => 'expert_lawyer_contact_details',
	)));

	$wp_customize->add_setting( 'expert_lawyer_topbartext_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'expert_lawyer_topbartext_color', array(
		'label' => 'Topbar Text Color',
		'section' => 'expert_lawyer_contact_details',
	)));

	$wp_customize->add_setting( 'expert_lawyer_topbarbtn_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'expert_lawyer_topbarbtn_color', array(
		'label' => 'Button Text Color',
		'section' => 'expert_lawyer_contact_details',
	)));

	$wp_customize->add_setting( 'expert_lawyer_topbarbtnbg_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'expert_lawyer_topbarbtnbg_color', array(
		'label' => 'Button Bg Color',
		'section' => 'expert_lawyer_contact_details',
	)));

	$wp_customize->add_setting( 'expert_lawyer_topbarbg_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'expert_lawyer_topbarbg_color', array(
		'label' => 'Background Color',
		'section' => 'expert_lawyer_contact_details',
	)));

	$wp_customize->add_setting( 'expert_lawyer_topbarmenu_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'expert_lawyer_topbarmenu_color', array(
		'label' => 'Menu Color',
		'section' => 'expert_lawyer_contact_details',
	)));

	$wp_customize->add_setting( 'expert_lawyer_topbarmenuhvrbg_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'expert_lawyer_topbarmenuhvrbg_color', array(
		'label' => 'Menu Hover Bg Color',
		'section' => 'expert_lawyer_contact_details',
	)));

	$wp_customize->add_setting( 'expert_lawyer_topbarmenubg_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'expert_lawyer_topbarmenubg_color', array(
		'label' => 'Menu Bg Color',
		'section' => 'expert_lawyer_contact_details',
	)));

	//social icons
	$wp_customize->add_section( 'expert_lawyer_social', array(
    	'title'      => __( 'Social Icons', 'expert-lawyer' ),
		'priority'   => null,
		'panel' => 'expert_lawyer_panel_id'
	) );

	$wp_customize->add_setting('expert_lawyer_facebook_url',array(
		'default'	=> '',
		'sanitize_callback'	=> 'esc_url_raw'
	));	
	$wp_customize->add_control('expert_lawyer_facebook_url',array(
		'label'	=> __('Add Facebook Link','expert-lawyer'),
		'section'	=> 'expert_lawyer_social',
		'setting'	=> 'expert_lawyer_facebook_url',
		'type'	=> 'url'
	));

	$wp_customize->add_setting('expert_lawyer_twitter_url',array(
		'default'	=> '',
		'sanitize_callback'	=> 'esc_url_raw'
	));	
	$wp_customize->add_control('expert_lawyer_twitter_url',array(
		'label'	=> __('Add Twitter Link','expert-lawyer'),
		'section'	=> 'expert_lawyer_social',
		'setting'	=> 'expert_lawyer_twitter_url',
		'type'	=> 'url'
	));

	$wp_customize->add_setting('expert_lawyer_linkedin_url',array(
		'default'	=> '',
		'sanitize_callback'	=> 'esc_url_raw'
	));
	$wp_customize->add_control('expert_lawyer_linkedin_url',array(
		'label'	=> __('Add Linkedin Link','expert-lawyer'),
		'section'	=> 'expert_lawyer_social',
		'setting'	=> 'expert_lawyer_linkedin_url',
		'type'	=> 'url'
	));

	$wp_customize->add_setting('expert_lawyer_insta_url',array(
		'default'	=> '',
		'sanitize_callback'	=> 'esc_url_raw'
	));	
	$wp_customize->add_control('expert_lawyer_insta_url',array(
		'label'	=> __('Add Instagram link','expert-lawyer'),
		'section'	=> 'expert_lawyer_social',
		'setting'	=> 'expert_lawyer_insta_url',
		'type'	=> 'url'
	));

	$wp_customize->add_setting('expert_lawyer_pinterest_url',array(
		'default'	=> '',
		'sanitize_callback'	=> 'esc_url_raw'
	));	
	$wp_customize->add_control('expert_lawyer_pinterest_url',array(
		'label'	=> __('Add Pintrest Link','expert-lawyer'),
		'section'	=> 'expert_lawyer_social',
		'setting'	=> 'expert_lawyer_pinterest_url',
		'type'	=> 'url'
	));

	$wp_customize->add_setting('expert_lawyer_you_tube_url',array(
		'default'	=> '',
		'sanitize_callback'	=> 'esc_url_raw'
	));	
	$wp_customize->add_control('expert_lawyer_you_tube_url',array(
		'label'	=> __('Add YouTube Link','expert-lawyer'),
		'section'	=> 'expert_lawyer_social',
		'setting'	=> 'expert_lawyer_you_tube_url',
		'type'	=> 'url'
	));

	$wp_customize->add_setting( 'expert_lawyer_timeicon_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'expert_lawyer_timeicon_color', array(
		'label' => 'Time Icon Color',
		'section' => 'expert_lawyer_social',
	)));

	$wp_customize->add_setting( 'expert_lawyer_timetext_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'expert_lawyer_timetext_color', array(
		'label' => 'Time Text Color',
		'section' => 'expert_lawyer_social',
	)));

	$wp_customize->add_setting( 'expert_lawyer_socialicon_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'expert_lawyer_socialicon_color', array(
		'label' => 'Social Icon Color',
		'section' => 'expert_lawyer_social',
	)));

	$wp_customize->add_setting( 'expert_lawyer_socialiconbg_color1', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'expert_lawyer_socialiconbg_color1', array(
		'label' => 'Background Color 1',
		'section' => 'expert_lawyer_social',
	)));

	$wp_customize->add_setting( 'expert_lawyer_socialiconbg_color2', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'expert_lawyer_socialiconbg_color2', array(
		'label' => 'Background Color 2',
		'section' => 'expert_lawyer_social',
	)));
	
	//home page slider
	$wp_customize->add_section( 'expert_lawyer_slider_section' , array(
    	'title'      => __( 'Slider Settings', 'expert-lawyer' ),
		'priority'   => null,
		'panel' => 'expert_lawyer_panel_id'
	) );

	$wp_customize->add_setting('expert_lawyer_slider_hide_show',array(
    	'default' => false,
    	'sanitize_callback'	=> 'expert_lawyer_sanitize_checkbox'
	));
	$wp_customize->add_control('expert_lawyer_slider_hide_show',array(
   	'type' => 'checkbox',
   	'label' => __('Show / Hide slider','expert-lawyer'),
   	'description' => __('Image Size ( 1600px x 582px )','expert-lawyer'),
   	'section' => 'expert_lawyer_slider_section',
	));

	$wp_customize->add_setting( 'expert_lawyer_slider_effect', array(
		'default'           => '',
		'sanitize_callback' => 'expert_lawyer_sanitize_choices'
	));
	$wp_customize->add_control( 'expert_lawyer_slider_effect', array(
		'label'    => __( 'Onload Transactions Effects', 'expert-lawyer' ),
		'section'  => 'expert_lawyer_slider_section',
		'type'     => 'select',
		'choices'  => array(
			'bounceInLeft'  => __('bounceInLeft', 'expert-lawyer'),
			'bounceInRight' => __('bounceInRight', 'expert-lawyer'),
			'bounceInUp'    => __('bounceInUp', 'expert-lawyer'),
			'bounceInDown'    => __('bounceInDown', 'expert-lawyer'),
			'zoomIn'  => __('zoomIn', 'expert-lawyer'),
			'zoomOut' => __('zoomOut', 'expert-lawyer'),
			'fadeInDown'    => __('fadeInDown', 'expert-lawyer'),
			'fadeInUp'    => __('fadeInUp', 'expert-lawyer'),
			'fadeInLeft'  => __('fadeInLeft', 'expert-lawyer'),
			'fadeInRight' => __('fadeInRight', 'expert-lawyer'),
			'flip-up'    => __('flip-up', 'expert-lawyer'),
			'none'    => __('none', 'expert-lawyer')
		),
	));

	for ( $count = 1; $count <= 4; $count++ ) {
		$wp_customize->add_setting( 'expert_lawyer_slider' . $count, array(
			'default'           => '',
			'sanitize_callback' => 'expert_lawyer_sanitize_dropdown_pages'
		) );
		$wp_customize->add_control( 'expert_lawyer_slider' . $count, array(
			'label'    => __( 'Select Slide Image Page', 'expert-lawyer' ),
			'section'  => 'expert_lawyer_slider_section',
			'type'     => 'dropdown-pages'
		) );
	}

	$wp_customize->add_setting('expert_lawyer_slider_excerpt_length',array(
		'default' => '15',
		'sanitize_callback'	=> 'expert_lawyer_sanitize_float'
	));
	$wp_customize->add_control('expert_lawyer_slider_excerpt_length',array(
		'type' => 'number',
		'label' => __('Slider Excerpt Length','expert-lawyer'),
		'section' => 'expert_lawyer_slider_section',
	));

	$wp_customize->add_setting('expert_lawyer_slider_title_font_size',array(
		'default' => '',
		'sanitize_callback'	=> 'expert_lawyer_sanitize_float'
	));
	$wp_customize->add_control('expert_lawyer_slider_title_font_size',array(
		'type' => 'number',
		'label' => __('Title Font Size','expert-lawyer'),
		'section' => 'expert_lawyer_slider_section',
	));

	$wp_customize->add_setting('expert_lawyer_slider_text_font_size',array(
		'default' => '',
		'sanitize_callback'	=> 'expert_lawyer_sanitize_float'
	));
	$wp_customize->add_control('expert_lawyer_slider_text_font_size',array(
		'type' => 'number',
		'label' => __('Text Font Size','expert-lawyer'),
		'section' => 'expert_lawyer_slider_section',
	));

	$wp_customize->add_setting('expert_lawyer_slider_btn_font_size',array(
		'default' => '',
		'sanitize_callback'	=> 'expert_lawyer_sanitize_float'
	));
	$wp_customize->add_control('expert_lawyer_slider_btn_font_size',array(
		'type' => 'number',
		'label' => __('Button Font Size','expert-lawyer'),
		'section' => 'expert_lawyer_slider_section',
	));

	$wp_customize->add_setting('expert_lawyer_slider_opacity',array(
		'default' => '',
		'sanitize_callback'	=> 'expert_lawyer_sanitize_float'
	));
	$wp_customize->add_control('expert_lawyer_slider_opacity',array(
		'type' => 'range',
		'label' => __('Image Opacity','expert-lawyer'),
		'section' => 'expert_lawyer_slider_section',
		'input_attrs' => array(
			'min' => 0,
			'max' => 1,
			'step' => 0.1,
		),
	));

	$wp_customize->add_setting( 'expert_lawyer_slidertitle_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'expert_lawyer_slidertitle_color', array(
		'label' => 'Title Color',
		'section' => 'expert_lawyer_slider_section',
	)));

	$wp_customize->add_setting( 'expert_lawyer_slidertext_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'expert_lawyer_slidertext_color', array(
		'label' => 'Text Color',
		'section' => 'expert_lawyer_slider_section',
	)));

	$wp_customize->add_setting( 'expert_lawyer_sliderbtn_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'expert_lawyer_sliderbtn_color', array(
		'label' => 'Button text Color',
		'section' => 'expert_lawyer_slider_section',
	)));

	$wp_customize->add_setting( 'expert_lawyer_sliderbtnbdr_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'expert_lawyer_sliderbtnbdr_color', array(
		'label' => 'Button Border Color',
		'section' => 'expert_lawyer_slider_section',
	)));

	$wp_customize->add_setting( 'expert_lawyer_slidernp_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'expert_lawyer_slidernp_color', array(
		'label' => 'Next/Pre Arrow Color',
		'section' => 'expert_lawyer_slider_section',
	)));

	//Abut Us
	$wp_customize->add_section('expert_lawyer_about_us',array(
		'title'	=> __('About Us','expert-lawyer'),
		'description' => __('<b>Note :</b> Add content here.','expert-lawyer'),
		'panel' => 'expert_lawyer_panel_id',
	));

	$args = array('numberposts' => -1);
	$post_list = get_posts($args);
	$i = 0;
	$psts[]='Select';  
	foreach($post_list as $post){
		$psts[$post->post_title] = $post->post_title;
	}

	$wp_customize->add_setting('expert_lawyer_post',array(
		'sanitize_callback' => 'expert_lawyer_sanitize_choices',
	));
	$wp_customize->add_control('expert_lawyer_post',array(
		'type'    => 'select',
		'choices' => $psts,
		'label' => __('Select Post','expert-lawyer'),
		'section' => 'expert_lawyer_about_us',
	));

	$wp_customize->add_setting('expert_lawyer_about_title_font_size',array(
		'default' => '',
		'sanitize_callback'	=> 'expert_lawyer_sanitize_float'
	));
	$wp_customize->add_control('expert_lawyer_about_title_font_size',array(
		'type' => 'number',
		'label' => __('Title Font Size','expert-lawyer'),
		'section' => 'expert_lawyer_about_us',
	));

	$wp_customize->add_setting('expert_lawyer_about_text_font_size',array(
		'default' => '',
		'sanitize_callback'	=> 'expert_lawyer_sanitize_float'
	));
	$wp_customize->add_control('expert_lawyer_about_text_font_size',array(
		'type' => 'number',
		'label' => __('Text Font Size','expert-lawyer'),
		'section' => 'expert_lawyer_about_us',
	));

	$wp_customize->add_setting('expert_lawyer_about_img_size',array(
		'default' => '',
		'sanitize_callback'	=> 'expert_lawyer_sanitize_float'
	));
	$wp_customize->add_control('expert_lawyer_about_img_size',array(
		'type' => 'number',
		'label' => __('Image Size','expert-lawyer'),
		'section' => 'expert_lawyer_about_us',
	));

	$wp_customize->add_setting('expert_lawyer_about_section_padding',array(
      'default' => '',
      'sanitize_callback'	=> 'expert_lawyer_sanitize_float'
	));
	$wp_customize->add_control('expert_lawyer_about_section_padding',array(
		'type' => 'number',
		'label' => __('Section Top Bottom Padding','expert-lawyer'),
		'section' => 'expert_lawyer_about_us',
	));

   $wp_customize->add_setting( 'expert_lawyer_about_color', array(
	'default' => '',
	'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'expert_lawyer_about_color', array(
		'label' => 'Title Color',
		'section' => 'expert_lawyer_about_us',
	)));

	$wp_customize->add_setting( 'expert_lawyer_abouttext_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'expert_lawyer_abouttext_color', array(
		'label' => 'Text Color',
		'section' => 'expert_lawyer_about_us',
	)));

	$wp_customize->add_setting( 'expert_lawyer_aboutbtn_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'expert_lawyer_aboutbtn_color', array(
		'label' => 'Button Text Color',
		'section' => 'expert_lawyer_about_us',
	)));

	$wp_customize->add_setting( 'expert_lawyer_aboutbtnbg_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'expert_lawyer_aboutbtnbg_color', array(
		'label' => 'Button Bg Color',
		'section' => 'expert_lawyer_about_us',
	)));

	$wp_customize->add_setting( 'expert_lawyer_aboutbdr1_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'expert_lawyer_aboutbdr1_color', array(
		'label' => 'Image Border 1 Color',
		'section' => 'expert_lawyer_about_us',
	)));

	$wp_customize->add_setting( 'expert_lawyer_aboutbdr2_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'expert_lawyer_aboutbdr2_color', array(
		'label' => 'Image Border 2 Color',
		'section' => 'expert_lawyer_about_us',
	)));

	//Footer
 	$wp_customize->add_section( 'expert_lawyer_footer', array(
    	'title'      => __( 'Footer Setting', 'expert-lawyer' ),
		'priority'   => null,
		'panel' => 'expert_lawyer_panel_id'
	) );

	$wp_customize->add_setting('expert_lawyer_show_back_totop',array(
 		'default' => true,
   	'sanitize_callback'	=> 'expert_lawyer_sanitize_checkbox'
	));
	$wp_customize->add_control('expert_lawyer_show_back_totop',array(
   	'type' => 'checkbox',
   	'label' => __('Show / Hide Back to Top','expert-lawyer'),
   	'section' => 'expert_lawyer_footer'
	));

 	$wp_customize->add_setting('expert_lawyer_footer_link',array(
		'default'	=> 'https://www.luzuk.com/products/free-lawyer-wordpress-theme/',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('expert_lawyer_footer_link',array(
		'label'	=> __('Copyright Link','expert-lawyer'),
		'section'	=> 'expert_lawyer_footer',
		'setting'	=> 'expert_lawyer_footer_link',
		'type'		=> 'text'
	));

	$wp_customize->add_setting('expert_lawyer_footer_copy',array(
		'default'	=> 'Lawyer WordPress Theme By Luzuk',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('expert_lawyer_footer_copy',array(
		'label'	=> __('Copyright Text','expert-lawyer'),
		'section'	=> 'expert_lawyer_footer',
		'setting'	=> 'expert_lawyer_footer_copy',
		'type'		=> 'text'
	));

	$wp_customize->add_setting('expert_lawyer_footer_copy_font_size',array(
		'default' => '',
		'sanitize_callback'	=> 'expert_lawyer_sanitize_float'
	));
	$wp_customize->add_control('expert_lawyer_footer_copy_font_size',array(
		'type' => 'number',
		'label' => __('Text Font Size','expert-lawyer'),
		'section' => 'expert_lawyer_footer',
	));

	$wp_customize->add_setting('expert_lawyer_copyright_padding',array(
		'default' => '',
		'sanitize_callback'	=> 'expert_lawyer_sanitize_float'
 	));
 	$wp_customize->add_control('expert_lawyer_copyright_padding',array(
		'type' => 'number',
		'label' => __('Copyright Top Bottom Padding','expert-lawyer'),
		'section' => 'expert_lawyer_footer',
	));

	$wp_customize->add_setting( 'expert_lawyer_copyright_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'expert_lawyer_copyright_color', array(
		'label' => 'Copyright Text Color',
		'section' => 'expert_lawyer_footer',
	)));

	$wp_customize->add_setting( 'expert_lawyer_copyrightbg_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'expert_lawyer_copyrightbg_color', array(
		'label' => 'Copyright Bg Color',
		'section' => 'expert_lawyer_footer',
	)));

	$wp_customize->add_setting( 'expert_lawyer_footer_title_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'expert_lawyer_footer_title_color', array(
		'label' => 'Footer Text Color',
		'section' => 'expert_lawyer_footer',
	)));

	$wp_customize->add_setting( 'expert_lawyer_footer_menu_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'expert_lawyer_footer_menu_color', array(
		'label' => 'Footer Menu Color',
		'section' => 'expert_lawyer_footer',
	)));

	$wp_customize->get_setting( 'blogname' )->transport          = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport   = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport  = 'postMessage';

	$wp_customize->selective_refresh->add_partial( 'blogname', array(
		'selector' => '.site-title a',
		'render_callback' => 'expert_lawyer_customize_partial_blogname',
	) );
	$wp_customize->selective_refresh->add_partial( 'blogdescription', array(
		'selector' => '.site-description',
		'render_callback' => 'expert_lawyer_customize_partial_blogdescription',
	) );
}
add_action( 'customize_register', 'expert_lawyer_customize_register' );

function expert_lawyer_customize_partial_blogname() {
	bloginfo( 'name' );
}

function expert_lawyer_customize_partial_blogdescription() {
	bloginfo( 'description' );
}

function expert_lawyer_is_static_front_page() {
	return ( is_front_page() && ! is_home() );
}

function expert_lawyer_is_view_with_layout_option() {
	// This option is available on all pages. It's also available on archives when there isn't a sidebar.
	return ( is_page() || ( is_archive() && ! is_active_sidebar( 'sidebar-1' ) ) );
}

/**
 * Singleton class for handling the theme's customizer integration.
 *
 * @since  1.0.0
 * @access public
 */
final class Expert_Lawyer_Customize {

	/**
	 * Returns the instance.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return object
	 */
	public static function get_instance() {

		static $instance = null;

		if ( is_null( $instance ) ) {
			$instance = new self;
			$instance->setup_actions();
		}

		return $instance;
	}

	/**
	 * Constructor method.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function __construct() {}

	/**
	 * Sets up initial actions.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function setup_actions() {

		// Register panels, sections, settings, controls, and partials.
		add_action( 'customize_register', array( $this, 'sections' ) );

		// Register scripts and styles for the controls.
		add_action( 'customize_controls_enqueue_scripts', array( $this, 'enqueue_control_scripts' ), 0 );
	}

	/**
	 * Sets up the customizer sections.
	 *
	 * @since  1.0.0
	 * @access public
	 * @param  object  $manager
	 * @return void
	 */
	public function sections( $manager ) {

		// Load custom sections.
		load_template( trailingslashit( get_template_directory() ) . '/inc/section-pro.php' );

		// Register custom section types.
		$manager->register_section_type( 'Expert_Lawyer_Customize_Section_Pro' );

		// Register sections.
		$manager->add_section(
			new Expert_Lawyer_Customize_Section_Pro(
				$manager,
				'expert_lawyer_example_1',
				array(
					'priority' => 9,
					'title'    => esc_html__( 'Expert Lawyer Pro', 'expert-lawyer' ),
					'pro_text' => esc_html__( 'Go Pro','expert-lawyer' ),
					'pro_url'  => esc_url( 'https://www.luzuk.com/products/lawyer-wordpress-theme/' ),
				)
			)
		);
	}

	/**
	 * Loads theme customizer CSS.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return void
	 */
	public function enqueue_control_scripts() {

		wp_enqueue_script( 'expert-lawyer-customize-controls', trailingslashit( esc_url(get_template_directory_uri()) ) . '/assets/js/customize-controls.js', array( 'customize-controls' ) );

		wp_enqueue_style( 'expert-lawyer-customize-controls', trailingslashit( esc_url(get_template_directory_uri()) ) . '/assets/css/customize-controls.css' );
	}
}

// Doing this customizer thang!
Expert_Lawyer_Customize::get_instance();