<?php

if ( ! get_theme_mod( 'expert_coaching_enable_team_section', false ) ) {
	return;
}

$content_id   = $designation = $social_links = $section_content = array();
$content_type = get_theme_mod( 'expert_coaching_team_content_type', 'page' );

for ( $i = 1; $i <= 3; $i++ ) {
	$team_id                 = get_theme_mod( 'expert_coaching_team_content_' . $content_type . '_' . $i );
	$content_id[]            = $team_id;
	$designation[ $team_id ] = get_theme_mod( 'expert_coaching_team_designation_' . $i );
	$social_links_str        = get_theme_mod( 'expert_coaching_team_social_links_' . $i );
	if ( ! empty( $social_links_str ) ) {
		$social_links[ $team_id ] = explode( ',', get_theme_mod( 'expert_coaching_team_social_links_' . $i ) );
	}
}

$args = array(
	'post_type'           => $content_type,
	'posts_per_page'      => absint( 3 ),
	'ignore_sticky_posts' => true,
);

if ( ! empty( array_filter( $content_id ) ) ) {
	$args['post__in'] = array_filter( $content_id );
	$args['orderby']  = 'post__in';
} else {
	$args['orderby'] = 'date';
}

$query = new WP_Query( $args );
if ( $query->have_posts() ) :
	while ( $query->have_posts() ) :
		$query->the_post();
		$section_content[] = array(
			'id'            => get_the_ID(),
			'title'         => get_the_title(),
			'permalink'     => get_the_permalink(),
			'thumbnail_url' => get_the_post_thumbnail_url( get_the_ID(), 'full' ),
		);
	endwhile;
	wp_reset_postdata();
endif;

$section_content = apply_filters( 'expert_coaching_team_section_content', $section_content );

expert_coaching_render_team_section( $section_content, $designation, $social_links );

/**
 * Render Team Section.
 */
function expert_coaching_render_team_section( $section_content, $designation, $social_links ) {
	$section_title     = get_theme_mod( 'expert_coaching_team_section_title', __( 'Our Team', 'expert-coaching' ) );
	$section_text      = get_theme_mod( 'expert_coaching_team_section_text' );
	$team_button_label = get_theme_mod( 'expert_coaching_team_button_label', __( 'View All', 'expert-coaching' ) );
	$team_button_link  = get_theme_mod( 'expert_coaching_team_button_link' );
	$team_button_link  = ! empty( $team_button_link ) ? $team_button_link : '#';

	?>
	<section id="expert_coaching_team_section" class="ascendoor-coach-frontpage-section expert-coaching-teams-section team-style-1">
		<?php
		if ( is_customize_preview() ) :
			expert_coaching_section_link( 'expert_coaching_team_section' );
		endif;
		?>
		<div class="ascendoor-wrapper">
			<?php if ( ! empty( $section_title || $section_text ) ) : ?>
				<div class="section-header-subtitle">
					<h3 class="section-title"><?php echo esc_html( $section_title ); ?></h3>
					<p class="section-subtitle"><?php echo esc_html( $section_text ); ?></p>
				</div>
			<?php endif; ?>
			<div class="expert-coaching-section-body">
				<div class="expert-coaching-teams-section-wrapper expert-coaching-navigation">
					<?php
					$i = 1;
					foreach ( $section_content as $content ) {
						$team_id = $content['id'];
						?>
						<div class="teams-single wow fadeInUp" data-wow-delay="<?php echo esc_attr( $i * 200 ); ?>ms">
							<?php if ( ! empty( $content['thumbnail_url'] ) ) { ?>
								<div class="teams-img">
									<img src="<?php echo esc_html( $content['thumbnail_url'] ); ?>" class="trending_item_img" alt="<?php echo esc_attr( $content['title'] ); ?>">
								</div>
							<?php } ?>
							<div class="teams-detial">
								<h3 class="team-name">
									<a href="<?php echo esc_url( $content['permalink'] ); ?>"><?php echo esc_html( $content['title'] ); ?></a>
								</h3>
								<?php if ( ! empty( $designation[ $team_id ] ) ) : ?>
									<p class="team-designation"><?php echo esc_html( $designation[ $team_id ] ); ?></p>
									<?php
								endif;
								if ( ! empty( $social_links[ $team_id ] ) ) {
									?>
									<div class="teams-social">
										<?php $i = 1; foreach ( $social_links[ $team_id ] as $link ) { ?>
											<a class="wow fadeInUp" data-wow-delay="<?php echo esc_attr( $i * 200 ); ?>ms" href="<?php echo esc_url( $link ); ?>" target="_blank"></a>
											<?php
											$i++;
											?>
										<?php } ?>
									</div>
								<?php } ?>
							</div>
						</div>
						<?php
						$i++;
					}
					?>
				</div>
				<?php if ( ! empty( $team_button_label ) ) { ?>
					<div class="expert-coaching-teams-view-all ascendoor-coach-button">
						<a href="<?php echo esc_url( $team_button_link ); ?>"><?php echo esc_html( $team_button_label ); ?></a>
					</div>
				<?php } ?>
			</div>
		</div>
	</section>
	<?php
}
