<?php
if ( ! get_theme_mod( 'expert_coaching_enable_featured_video_section', false ) ) {
	return;
}

$section_content                  = array();
$section_content['text']          = get_theme_mod( 'expert_coaching_featured_video_text' );
$section_content['title']         = get_theme_mod( 'expert_coaching_featured_video_title', __( 'Watch the Video', 'expert-coaching' ) );
$section_content['description']   = get_theme_mod( 'expert_coaching_featured_video_short_description' );
$section_content['section_image'] = get_theme_mod( 'expert_coaching_featured_video_section_image' );
$section_content['video_url']     = get_theme_mod( 'expert_coaching_featured_video_video_link' );

$section_content = apply_filters( 'expert_coaching_featured_video_section_content', $section_content );
expert_coaching_render_featured_video_section( $section_content );

/**
 * Render Featured Video Section.
 */
function expert_coaching_render_featured_video_section( $section_content ) {
	if ( empty( $section_content ) ) {
		return;
	}
	?>
	<section id="expert_coaching_featured_video_section" class="ascendoor-coach-frontpage-section expert-coaching-product-video-section always-pad section-has-background video-style-2 video-left">
		<?php
		if ( is_customize_preview() ) :
			expert_coaching_section_link( 'expert_coaching_featured_video_section' );
		endif;

		if ( ! empty( $section_content['section_image'] ) ) {
			?>
			<div class="expert-coaching-product-video-background-img">
				<img src="<?php echo esc_url( $section_content['section_image'] ); ?>">
			</div>
			<?php
		}
		?>
		<div class="ascendoor-wrapper">
			<div class="video-details-wrapper">
				<div class="expert-coaching-product-video-details">
					<div class="section-header-subtitle small-title">
						<h3 class="section-title video-detail-title wow fadeInUp" data-splitting data-wow-delay="200ms"><?php echo esc_html( $section_content['title'] ); ?></h3>
						<p class="section-subtitle video-detail-subtitle"><?php echo esc_html( $section_content['text'] ); ?></p>
					</div>
					<div class="video-detail">
						<p><?php echo wp_kses_post( $section_content['description'] ); ?></p>
					</div>
					<?php
					if ( ! empty( $section_content['video_url'] ) ) {
						?>
						<a href="<?php echo esc_url( $section_content['video_url'] ); ?>" class="expert-coaching-video-popup expert-coaching-video-play-btn"><i class="fas fa-play"></i></a>
						<?php
					}
					?>
				</div>
			</div>
		</div>
	</section>
	<?php
}
