<?php
/**
 * Expert Coaching functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Expert Coaching
 */

if ( ! function_exists( 'expert_coaching_setup' ) ) :
	function expert_coaching_setup() {
		/*
		* Make child theme available for translation.
		* Translations can be filed in the /languages/ directory.
		*/
		load_child_theme_textdomain( 'expert-coaching', get_stylesheet_directory() . '/languages' );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );

		add_theme_support( 'title-tag' );

		add_theme_support( 'register_block_pattern' );

		add_theme_support( 'register_block_style' );

		add_theme_support( 'wp-block-styles' );

		add_theme_support( 'align-wide' );

		add_theme_support( 'responsive-embeds' );
	}
endif;
add_action( 'after_setup_theme', 'expert_coaching_setup' );

if ( ! function_exists( 'expert_coaching_enqueue_styles' ) ) :
	/**
	 * Enqueue scripts and styles.
	 */
	function expert_coaching_enqueue_styles() {
		$parenthandle = 'ascendoor-coach-style';
		$theme        = wp_get_theme();

		// Append .min if SCRIPT_DEBUG is false.
		$min = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';

		wp_enqueue_style(
			$parenthandle,
			get_template_directory_uri() . '/style.css',
			array(
				'ascendoor-coach-slick-style',
				'ascendoor-coach-fontawesome-style',
				'ascendoor-coach-google-fonts',
			),
			$theme->parent()->get( 'Version' )
		);

		wp_enqueue_style(
			'expert-coaching-style',
			get_stylesheet_uri(),
			array( $parenthandle ),
			$theme->get( 'Version' )
		);

		wp_enqueue_script( 'expert-coaching-script', get_stylesheet_directory_uri() . '/assets/js/custom' . $min . '.js', array( 'jquery', 'ascendoor-coach-custom-script' ), $theme->get( 'Version' ), true );
	}

endif;

add_action( 'wp_enqueue_scripts', 'expert_coaching_enqueue_styles' );

// Custom Controls.
require get_theme_file_path() . '/inc/custom-controls.php';

// Customizer Section.
require get_theme_file_path() . '/inc/customizer.php';

function expert_coaching_custom_header_setup() {
	add_theme_support(
		'custom-header',
		apply_filters(
			'ascendoor_coach_custom_header_args',
			array(
				'default-image'      => '',
				'default-text-color' => 'D20A0A',
				'width'              => 1000,
				'height'             => 250,
				'flex-height'        => true,
				'wp-head-callback'   => 'ascendoor_coach_header_style',
			)
		)
	);
}
add_action( 'after_setup_theme', 'expert_coaching_custom_header_setup' );

function admin_style() {
	?>
	<style type="text/css">
		.notice.notice-info.ascendoor-coach-demo-data {
			display: none !important;
		}
	</style>
	<?php
}
add_action( 'admin_enqueue_scripts', 'admin_style' );

/**
 * Renders customizer section link
 */
function expert_coaching_section_link( $section_id ) {
	$section_name      = str_replace( 'expert_coaching_', ' ', $section_id );
	$section_name      = str_replace( '_', ' ', $section_name );
	$starting_notation = '#';
	?>
	<span class="section-link">
		<span class="section-link-title"><?php echo esc_html( $section_name ); ?></span>
	</span>
	<style type="text/css">
		<?php echo $starting_notation . $section_id; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>:hover .section-link {
			visibility: visible;
		}
	</style>
	<?php
}

/**
 * One Click Demo Import after import setup.
 */
if ( class_exists( 'OCDI_Plugin' ) ) {
	require get_theme_file_path() . '/inc/ocdi.php';
}
